/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.commons.logging.Log;
import org.opencms.flex.CmsFlexController;
import org.opencms.flex.CmsFlexRequest;
import org.opencms.jsp.I_CmsJspTagParamParent;
import org.opencms.main.CmsLog;

public class CmsJspTagAddParams
extends TagSupport
implements I_CmsJspTagParamParent,
TryCatchFinally {
    private static final Log LOG = CmsLog.getLog(CmsJspTagAddParams.class);
    private static final long serialVersionUID = 1L;
    private ParamState m_state;

    @Override
    public void addParameter(String name, String value) {
        if (this.m_state != null) {
            this.m_state.addParameter(name, value);
        }
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        this.clearState();
    }

    public int doStartTag() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest((ServletRequest)request)) {
            CmsFlexController controller = CmsFlexController.getController((ServletRequest)request);
            this.m_state = new ParamState(controller.getCurrentRequest());
            this.m_state.init();
        } else {
            LOG.error((Object)"Using <cms:addparams> tag outside of a Flex request");
        }
        return 1;
    }

    private void clearState() {
        if (this.m_state != null) {
            ParamState state = this.m_state;
            this.m_state = null;
            state.undoChanges();
        }
    }

    public static class ParamState {
        private CmsFlexRequest m_request;
        private Map<String, String[]> m_savedParams;
        private Set<String> m_savedDynamicParams;

        public ParamState(CmsFlexRequest request) {
            this.m_request = request;
        }

        public void addParameter(String key, String value) {
            this.m_request.addParameterMap(Collections.singletonMap(key, new String[]{value}));
            this.m_request.getDynamicParameters().add(key);
        }

        public void init() {
            this.m_savedParams = this.m_request.getParameterMap();
            this.m_savedDynamicParams = this.m_request.getDynamicParameters();
            HashMap params = Maps.newHashMap();
            if (this.m_savedParams != null) {
                params.putAll(this.m_savedParams);
            }
            this.m_request.setParameterMap(params);
            HashSet dynamicParams = Sets.newHashSet(this.m_savedDynamicParams);
            this.m_request.setDynamicParameters(dynamicParams);
        }

        public void undoChanges() {
            this.m_request.setParameterMap(this.m_savedParams);
            this.m_request.setDynamicParameters(this.m_savedDynamicParams);
        }
    }
}

