/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspResourceWrapper;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsJspTagInfo
extends TagSupport {
    private static final Log LOG = CmsLog.getLog(CmsJspTagInfo.class);
    private static final long serialVersionUID = -3881095296148023924L;
    private static final String[] SYSTEM_PROPERTIES = new String[]{"opencms.version", "opencms.url", "opencms.uri", "opencms.webapp", "opencms.webbasepath", "opencms.request.uri", "opencms.request.element.uri", "opencms.request.folder", "opencms.request.encoding", "opencms.request.locale", "opencms.title", "opencms.description", "opencms.keywords"};
    private static final List<String> SYSTEM_PROPERTIES_LIST = Arrays.asList(SYSTEM_PROPERTIES);
    private String m_property;

    public static String getDescriptionInfo(CmsFlexController controller, HttpServletRequest req) {
        String result = null;
        CmsObject cms = controller.getCmsObject();
        try {
            CmsJspStandardContextBean contextBean = CmsJspStandardContextBean.getInstance((ServletRequest)req);
            if (contextBean.isDetailRequest()) {
                CmsJspResourceWrapper res = contextBean.getDetailContent();
                result = cms.readPropertyObject(res, "Description", false).getValue();
            }
            if (result == null) {
                result = cms.readPropertyObject(cms.getRequestContext().getUri(), "Description", true).getValue();
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(result)) {
            result = "";
        }
        return result;
    }

    public static String getKeywordsInfo(CmsFlexController controller, HttpServletRequest req) {
        String result = null;
        CmsObject cms = controller.getCmsObject();
        try {
            CmsJspStandardContextBean contextBean = CmsJspStandardContextBean.getInstance((ServletRequest)req);
            if (contextBean.isDetailRequest()) {
                CmsJspResourceWrapper res = contextBean.getDetailContent();
                result = cms.readPropertyObject(res, "Keywords", false).getValue();
            }
            if (result == null) {
                result = cms.readPropertyObject(cms.getRequestContext().getUri(), "Keywords", true).getValue();
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(result)) {
            result = "";
        }
        return result;
    }

    public static String getTitleInfo(CmsFlexController controller, HttpServletRequest req) {
        String result = null;
        CmsObject cms = controller.getCmsObject();
        try {
            CmsJspResourceWrapper res;
            CmsXmlContent content;
            CmsJspStandardContextBean contextBean = CmsJspStandardContextBean.getInstance((ServletRequest)req);
            if (contextBean.isDetailRequest() && (result = (content = CmsXmlContentFactory.unmarshal(cms, res = contextBean.getDetailContent(), (ServletRequest)req)).getHandler().getTitleMapping(cms, content, cms.getRequestContext().getLocale())) == null) {
                result = cms.readPropertyObject(res, "Title", false).getValue();
            }
            if (result == null) {
                result = cms.readPropertyObject(cms.getRequestContext().getUri(), "Title", true).getValue();
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(result)) {
            result = "";
        }
        return result;
    }

    public static String infoTagAction(String property, HttpServletRequest req) {
        if (property == null) {
            CmsMessageContainer errMsgContainer = Messages.get().container("GUI_ERR_INVALID_INFO_PROP_0");
            return Messages.getLocalizedMessage(errMsgContainer, (ServletRequest)req);
        }
        CmsFlexController controller = CmsFlexController.getController((ServletRequest)req);
        String result = null;
        switch (SYSTEM_PROPERTIES_LIST.indexOf(property)) {
            case 0: {
                result = OpenCms.getSystemInfo().getVersionNumber();
                break;
            }
            case 1: {
                result = req.getRequestURL().toString();
                break;
            }
            case 2: {
                result = req.getRequestURI();
                break;
            }
            case 3: {
                result = OpenCms.getSystemInfo().getWebApplicationName();
                break;
            }
            case 4: {
                result = OpenCms.getSystemInfo().getWebApplicationRfsPath();
                break;
            }
            case 5: {
                result = controller.getCmsObject().getRequestContext().getUri();
                break;
            }
            case 6: {
                result = controller.getCurrentRequest().getElementUri();
                break;
            }
            case 7: {
                result = CmsResource.getParentFolder(controller.getCmsObject().getRequestContext().getUri());
                break;
            }
            case 8: {
                result = controller.getCmsObject().getRequestContext().getEncoding();
                break;
            }
            case 9: {
                result = controller.getCmsObject().getRequestContext().getLocale().toString();
                break;
            }
            case 10: {
                result = CmsJspTagInfo.getTitleInfo(controller, req);
                break;
            }
            case 11: {
                result = CmsJspTagInfo.getDescriptionInfo(controller, req);
                break;
            }
            case 12: {
                result = CmsJspTagInfo.getKeywordsInfo(controller, req);
                break;
            }
            default: {
                result = System.getProperty(property);
                if (result != null) break;
                CmsMessageContainer errMsgContainer = Messages.get().container("GUI_ERR_INVALID_INFO_PROP_1", property);
                return Messages.getLocalizedMessage(errMsgContainer, (ServletRequest)req);
            }
        }
        return result;
    }

    public int doStartTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                String result = CmsJspTagInfo.infoTagAction(this.m_property, (HttpServletRequest)req);
                this.pageContext.getOut().print(result);
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "info"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        return 0;
    }

    public String getProperty() {
        return this.m_property != null ? this.m_property : "";
    }

    public void release() {
        super.release();
        this.m_property = null;
    }

    public void setProperty(String name) {
        if (name != null) {
            this.m_property = name.toLowerCase();
        }
    }
}

