/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspImageScalerTagSupport;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspImageBean;
import org.opencms.loader.CmsImageScaler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.staticexport.CmsLinkManager;

public class CmsJspTagScaleImage
extends CmsJspImageScalerTagSupport {
    private static final Log LOG = CmsLog.getLog(CmsJspTagScaleImage.class);
    private static final long serialVersionUID = -6639978110802734737L;
    private List<String> m_hiDpiVariantList;
    private String m_var;

    public static CmsJspImageBean imageTagAction(CmsObject cms, String imageUri, CmsImageScaler targetScaler, List<String> hiDpiVariantList) throws CmsException {
        CmsJspImageBean image = new CmsJspImageBean(cms, imageUri, targetScaler);
        if (hiDpiVariantList != null && hiDpiVariantList.size() > 0) {
            for (String hiDpiVariant : hiDpiVariantList) {
                CmsJspImageBean hiDpiVersion = image.createHiDpiVariation(hiDpiVariant);
                if (hiDpiVersion == null) continue;
                image.addHiDpiImage(hiDpiVariant, hiDpiVersion);
            }
        }
        return image;
    }

    public int doEndTag() throws JspException {
        this.release();
        return 6;
    }

    public int doStartTag() {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                CmsJspImageBean scaledImage;
                block6: {
                    scaledImage = null;
                    try {
                        CmsFlexController controller = CmsFlexController.getController(req);
                        CmsObject cms = controller.getCmsObject();
                        String src = CmsLinkManager.getAbsoluteUri(this.m_src, controller.getCurrentRequest().getElementUri());
                        scaledImage = CmsJspTagScaleImage.imageTagAction(cms, src, this.m_scaler, this.m_hiDpiVariantList);
                    }
                    catch (CmsException e) {
                        if (!LOG.isWarnEnabled()) break block6;
                        LOG.warn((Object)Messages.get().getBundle().key("ERR_IMAGE_TAG_VFS_ACCESS_1", this.m_src), (Throwable)e);
                    }
                }
                this.pageContext.getRequest().setAttribute(this.m_var, scaledImage);
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "scaleImage"), (Throwable)ex);
                }
                return 0;
            }
        }
        return 1;
    }

    @Override
    public void release() {
        this.m_hiDpiVariantList = null;
        this.m_var = null;
        super.release();
    }

    public void setHiDpiVariants(String value) {
        this.m_hiDpiVariantList = new ArrayList<String>(4);
        String[] multipliers = StringUtils.split((String)value, (char)',');
        Collections.addAll(this.m_hiDpiVariantList, multipliers);
    }

    public void setVar(String value) {
        this.m_var = value;
    }
}

