/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.jsonpart;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONObject;
import org.opencms.jsp.jsonpart.CmsJsonPart;
import org.opencms.main.CmsLog;

public class CmsJsonPartFilter
implements Filter {
    static final Log LOG = CmsLog.getLog(CmsJsonPartFilter.class);
    public static final String KEY_PARTS = "parts";
    public static final String PARAM_JSON = "__json";
    private ThreadLocal<Boolean> m_isNested = new ThreadLocal();

    public static boolean isJsonRequest(ServletRequest request) {
        HttpServletRequest sr = (HttpServletRequest)request;
        return sr.getQueryString() != null && sr.getQueryString().contains("__json=true");
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (CmsJsonPartFilter.isJsonRequest(request)) {
            if (this.m_isNested.get() == null) {
                try {
                    this.m_isNested.set(Boolean.TRUE);
                    RequestWrapper reqWrapper = new RequestWrapper((HttpServletRequest)request);
                    ResponseWrapper resWrapper = new ResponseWrapper((HttpServletResponse)response);
                    chain.doFilter((ServletRequest)reqWrapper, (ServletResponse)resWrapper);
                    byte[] data = resWrapper.getBytes();
                    String content = new String(data, resWrapper.getCharacterEncoding());
                    String transformedContent = this.transformContent(content);
                    byte[] transformedData = transformedContent.getBytes("UTF-8");
                    response.setContentType("application/json; charset=UTF-8");
                    response.setContentLength(transformedData.length);
                    response.getOutputStream().write(transformedData);
                    response.getOutputStream().flush();
                }
                finally {
                    this.m_isNested.set(null);
                }
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    private String transformContent(String content) {
        try {
            List<CmsJsonPart> parts = CmsJsonPart.parseJsonParts(content);
            JSONArray keys = new JSONArray();
            JSONObject output = new JSONObject();
            for (CmsJsonPart part : parts) {
                if (output.has(part.getKey())) {
                    LOG.warn((Object)("Duplicate key for JSON parts: " + part.getKey()));
                }
                keys.put(part.getKey());
                output.put(part.getKey(), part.getValue());
            }
            output.put(KEY_PARTS, keys);
            return output.toString();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return content;
        }
    }

    class RequestWrapper
    extends HttpServletRequestWrapper {
        public RequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getParameter(String name) {
            if ("__disableDirectEdit".equals(name)) {
                return Boolean.TRUE.toString();
            }
            return super.getParameter(name);
        }

        public Map<String, String[]> getParameterMap() {
            HashMap result = Maps.newHashMap((Map)super.getParameterMap());
            result.put("__disableDirectEdit", new String[]{"true"});
            return result;
        }

        public Enumeration<String> getParameterNames() {
            HashSet keys = Sets.newHashSet();
            keys.add("__disableDirectEdit");
            return new Vector(keys).elements();
        }

        public String[] getParameterValues(String name) {
            return super.getParameterValues(name);
        }
    }

    class ResponseWrapper
    extends HttpServletResponseWrapper {
        ByteArrayOutputStream m_byteStream;
        PrintWriter m_printWriter;

        public ResponseWrapper(HttpServletResponse response) {
            super(response);
            this.m_byteStream = new ByteArrayOutputStream();
        }

        public byte[] getBytes() {
            if (this.m_printWriter != null) {
                this.m_printWriter.flush();
            }
            return this.m_byteStream.toByteArray();
        }

        public ServletOutputStream getOutputStream() {
            return new ServletOutputStream(){

                public void write(byte[] b) throws IOException {
                    ResponseWrapper.this.m_byteStream.write(b);
                }

                public void write(byte[] b, int off, int len) {
                    ResponseWrapper.this.m_byteStream.write(b, off, len);
                }

                public void write(int b) {
                    ResponseWrapper.this.m_byteStream.write(b);
                }

                public boolean isReady() {
                    return null != ResponseWrapper.this.m_byteStream;
                }

                public void setWriteListener(WriteListener writeListener) {
                }
            };
        }

        public PrintWriter getWriter() throws IOException {
            if (this.m_printWriter == null) {
                this.m_printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.m_byteStream, this.getResponse().getCharacterEncoding()));
            }
            return this.m_printWriter;
        }

        public void setContentLength(int len) {
        }
    }
}

