/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationPagination;

public class CmsSearchConfigurationPagination
implements I_CmsSearchConfigurationPagination {
    public static final List<Integer> DEFAULT_PAGE_SIZE = Collections.singletonList(10);
    public static final int DEFAULT_PAGE_NAV_LENGTH = 5;
    public static final String DEFAULT_PAGE_PARAM = "page";
    private final String m_pageParam;
    private final List<Integer> m_pageSizes;
    private final int m_pageSizeAllRemainingPages;
    private final int m_pageNavLength;

    public CmsSearchConfigurationPagination(String pageParam, Integer pageSize, Integer pageNavLength) {
        this(pageParam, null != pageSize ? Collections.singletonList(pageSize) : null, pageNavLength);
    }

    public CmsSearchConfigurationPagination(String pageParam, List<Integer> pageSizes, Integer pageNavLength) {
        String string = this.m_pageParam = pageParam == null ? DEFAULT_PAGE_PARAM : pageParam;
        if (pageSizes == null || pageSizes.isEmpty()) {
            this.m_pageSizes = DEFAULT_PAGE_SIZE;
        } else {
            this.m_pageSizes = new ArrayList<Integer>();
            this.m_pageSizes.addAll(pageSizes);
        }
        this.m_pageSizeAllRemainingPages = this.m_pageSizes.get(this.m_pageSizes.size() - 1);
        this.m_pageNavLength = pageNavLength == null ? 5 : pageNavLength;
    }

    public static I_CmsSearchConfigurationPagination create(String pageParam, List<Integer> pageSizes, Integer pageNavLength) {
        return pageParam != null || pageSizes != null || pageNavLength != null ? new CmsSearchConfigurationPagination(pageParam, pageSizes, pageNavLength) : null;
    }

    @Override
    public int getNumPages(long numFound) {
        int result = 1;
        for (int pageSize : this.m_pageSizes) {
            if ((numFound -= (long)pageSize) <= 0L) {
                return result;
            }
            ++result;
        }
        result = (int)((long)result + (numFound - 1L) / (long)this.m_pageSizeAllRemainingPages);
        return result;
    }

    @Override
    public int getPageNavLength() {
        return this.m_pageNavLength;
    }

    @Override
    public String getPageParam() {
        return this.m_pageParam;
    }

    @Override
    @Deprecated
    public int getPageSize() {
        return this.m_pageSizeAllRemainingPages;
    }

    @Override
    public List<Integer> getPageSizes() {
        ArrayList<Integer> pageSizes = new ArrayList<Integer>(this.m_pageSizes.size());
        for (Integer pageSize : this.m_pageSizes) {
            pageSizes.add((int)pageSize);
        }
        return pageSizes;
    }

    @Override
    public int getSizeOfPage(int pageNum) {
        if (pageNum < 1) {
            throw new IllegalArgumentException("You try to determine the size of page " + pageNum + ". But a valid page number must be greater than 0.");
        }
        if (pageNum <= this.m_pageSizes.size()) {
            return this.m_pageSizes.get(pageNum - 1);
        }
        return this.m_pageSizeAllRemainingPages;
    }

    @Override
    public int getStartOfPage(int pageNum) {
        if (pageNum < 1) {
            throw new IllegalArgumentException("The number of the page, you request the index of the first item for must be greater than 0, but is \"" + pageNum + "\".");
        }
        int result = 0;
        for (int i = 0; i < this.m_pageSizes.size(); ++i) {
            if (pageNum > 1) {
                result += this.m_pageSizes.get(i).intValue();
                --pageNum;
                continue;
            }
            return result;
        }
        return result += (pageNum - 1) * this.m_pageSizeAllRemainingPages;
    }
}

