/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.search.config.CmsSearchConfigurationCommon;
import org.opencms.jsp.search.config.CmsSearchConfigurationDidYouMean;
import org.opencms.jsp.search.config.CmsSearchConfigurationFacetField;
import org.opencms.jsp.search.config.CmsSearchConfigurationFacetQuery;
import org.opencms.jsp.search.config.CmsSearchConfigurationFacetRange;
import org.opencms.jsp.search.config.CmsSearchConfigurationGeoFilter;
import org.opencms.jsp.search.config.CmsSearchConfigurationHighlighting;
import org.opencms.jsp.search.config.CmsSearchConfigurationPagination;
import org.opencms.jsp.search.config.CmsSearchConfigurationSortOption;
import org.opencms.jsp.search.config.CmsSearchConfigurationSorting;
import org.opencms.jsp.search.config.I_CmsSearchConfiguration;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationCommon;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationDidYouMean;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacet;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetField;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetQuery;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetRange;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationGeoFilter;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationHighlighting;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationPagination;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationSortOption;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationSorting;
import org.opencms.jsp.search.config.parser.I_CmsSearchConfigurationParser;
import org.opencms.jsp.search.config.parser.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.solr.CmsSolrIndex;

public class CmsJSONSearchConfigurationParser
implements I_CmsSearchConfigurationParser {
    protected static final Log LOG = CmsLog.getLog(CmsJSONSearchConfigurationParser.class);
    public static final String JSON_KEY_QUERYPARAM = "queryparam";
    public static final String JSON_KEY_LAST_QUERYPARAM = "lastqueryparam";
    public static final String JSON_KEY_ESCAPE_QUERY_CHARACTERS = "escapequerychars";
    public static final String JSON_KEY_RELOADED_PARAM = "reloadedparam";
    public static final String JSON_KEY_SEARCH_FOR_EMPTY_QUERY = "searchforemptyquery";
    public static final String JSON_KEY_IGNORE_QUERY = "ignorequery";
    public static final String JSON_KEY_IGNORE_RELEASE_DATE = "ignoreReleaseDate";
    public static final String JSON_KEY_MAX_RETURNED_RESULTS = "maxReturnedResults";
    public static final String JSON_KEY_IGNORE_EXPIRATION_DATE = "ignoreExpirationDate";
    public static final String JSON_KEY_QUERY_MODIFIER = "querymodifier";
    public static final String JSON_KEY_PAGEPARAM = "pageparam";
    public static final String JSON_KEY_INDEX = "index";
    public static final String JSON_KEY_CORE = "core";
    public static final String JSON_KEY_EXTRASOLRPARAMS = "extrasolrparams";
    public static final String JSON_KEY_ADDITIONAL_PARAMETERS = "additionalrequestparams";
    public static final String JSON_KEY_ADDITIONAL_PARAMETERS_PARAM = "param";
    public static final String JSON_KEY_ADDITIONAL_PARAMETERS_SOLRQUERY = "solrquery";
    public static final String JSON_KEY_PAGESIZE = "pagesize";
    public static final String JSON_KEY_PAGENAVLENGTH = "pagenavlength";
    public static final String JSON_KEY_FIELD_FACETS = "fieldfacets";
    public static final String JSON_KEY_RANGE_FACETS = "rangefacets";
    public static final String JSON_KEY_QUERY_FACET = "queryfacet";
    public static final String JSON_KEY_FACET_LIMIT = "limit";
    public static final String JSON_KEY_FACET_MINCOUNT = "mincount";
    public static final String JSON_KEY_FACET_LABEL = "label";
    public static final String JSON_KEY_FACET_FIELD = "field";
    public static final String JSON_KEY_FACET_NAME = "name";
    public static final String JSON_KEY_FACET_PREFIX = "prefix";
    public static final String JSON_KEY_FACET_ORDER = "order";
    public static final String JSON_KEY_FACET_FILTERQUERYMODIFIER = "filterquerymodifier";
    public static final String JSON_KEY_FACET_ISANDFACET = "isAndFacet";
    public static final String JSON_KEY_FACET_IGNOREALLFACETFILTERS = "ignoreAllFacetFilters";
    public static final String JSON_KEY_FACET_EXCLUDETAGS = "excludeTags";
    public static final String JSON_KEY_FACET_PRESELECTION = "preselection";
    public static final String JSON_KEY_RANGE_FACET_RANGE = "range";
    public static final String JSON_KEY_RANGE_FACET_START = "start";
    public static final String JSON_KEY_RANGE_FACET_END = "end";
    public static final String JSON_KEY_RANGE_FACET_GAP = "gap";
    public static final String JSON_KEY_RANGE_FACET_OTHER = "other";
    public static final String JSON_KEY_RANGE_FACET_HARDEND = "hardend";
    public static final String JSON_KEY_QUERY_FACET_QUERY = "queryitems";
    public static final String JSON_KEY_QUERY_FACET_QUERY_QUERY = "query";
    public static final String JSON_KEY_QUERY_FACET_QUERY_LABEL = "label";
    public static final String JSON_KEY_SORTPARAM = "sortby";
    public static final String JSON_KEY_DEFAULT_SORT_OPTION = "defaultSortOption";
    public static final String JSON_KEY_SORTOPTIONS = "sortoptions";
    public static final String JSON_KEY_SORTOPTION_LABEL = "label";
    public static final String JSON_KEY_SORTOPTION_PARAMVALUE = "paramvalue";
    public static final String JSON_KEY_SORTOPTION_SOLRVALUE = "solrvalue";
    public static final String JSON_KEY_HIGHLIGHTER = "highlighter";
    public static final String JSON_KEY_HIGHLIGHTER_FIELD = "field";
    public static final String JSON_KEY_HIGHLIGHTER_SNIPPETS = "snippets";
    public static final String JSON_KEY_HIGHLIGHTER_FRAGSIZE = "fragsize";
    public static final String JSON_KEY_HIGHLIGHTER_ALTERNATE_FIELD = "alternateField";
    public static final String JSON_KEY_HIGHLIGHTER_MAX_LENGTH_ALTERNATE_FIELD = "maxAlternateFieldLength";
    public static final String JSON_KEY_HIGHLIGHTER_SIMPLE_PRE = "simple.pre";
    public static final String JSON_KEY_HIGHLIGHTER_SIMPLE_POST = "simple.post";
    public static final String JSON_KEY_HIGHLIGHTER_FORMATTER = "formatter";
    public static final String JSON_KEY_HIGHLIGHTER_FRAGMENTER = "fragmenter";
    public static final String JSON_KEY_HIGHLIGHTER_FASTVECTORHIGHLIGHTING = "useFastVectorHighlighting";
    public static final String JSON_KEY_DIDYOUMEAN = "didYouMean";
    public static final String JSON_KEY_DIDYOUMEAN_QUERYPARAM = "didYouMeanQueryParam";
    public static final String JSON_KEY_DIDYOUMEAN_COLLATE = "didYouMeanCollate";
    public static final String JSON_KEY_DIDYOUMEAN_COUNT = "didYouMeanCount";
    public static final String JSON_KEY_GEO_FILTER = "geofilter";
    public static final String JSON_KEY_GEO_FILTER_COORDINATES = "coordinates";
    public static final String JSON_KEY_GEO_FILTER_COORDINATES_PARAM = "coordinatesparam";
    public static final String JSON_KEY_GEO_FILTER_FIELD_NAME = "fieldName";
    public static final String JSON_KEY_GEO_FILTER_RADIUS = "radius";
    public static final String JSON_KEY_GEO_FILTER_RADIUS_PARAM = "radiusparam";
    public static final String JSON_KEY_GEO_FILTER_UNITS = "units";
    public static final String JSON_KEY_GEO_FILTER_UNITS_PARAM = "unitsparam";
    public static final String DEFAULT_QUERY_PARAM = "q";
    public static final String DEFAULT_LAST_QUERY_PARAM = "lq";
    public static final String DEFAULT_RELOADED_PARAM = "reloaded";
    protected JSONObject m_configObject;
    private I_CmsSearchConfiguration m_baseConfig;

    public CmsJSONSearchConfigurationParser(String json) throws JSONException {
        this.init(json, null);
    }

    public CmsJSONSearchConfigurationParser(String json, I_CmsSearchConfiguration baseConfig) throws JSONException {
        this.init(json, baseConfig);
    }

    protected static List<String> parseMandatoryStringValues(JSONObject json, String key) throws JSONException {
        ArrayList<String> list = null;
        JSONArray array = json.getJSONArray(key);
        list = new ArrayList<String>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            try {
                String entry = array.getString(i);
                list.add(entry);
                continue;
            }
            catch (JSONException e) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_OPTIONAL_STRING_ENTRY_UNPARSABLE_1", key), (Throwable)e);
            }
        }
        return list;
    }

    protected static Boolean parseOptionalBooleanValue(JSONObject json, String key) {
        try {
            return json.getBoolean(key);
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_OPTIONAL_BOOLEAN_MISSING_1", key), (Throwable)e);
            return null;
        }
    }

    protected static Integer parseOptionalIntValue(JSONObject json, String key) {
        try {
            return json.getInt(key);
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_OPTIONAL_INTEGER_MISSING_1", key), (Throwable)e);
            return null;
        }
    }

    protected static String parseOptionalStringValue(JSONObject json, String key) {
        try {
            return json.getString(key);
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_OPTIONAL_STRING_MISSING_1", key), (Throwable)e);
            return null;
        }
    }

    protected static List<String> parseOptionalStringValues(JSONObject json, String key) {
        List<String> list = null;
        try {
            list = CmsJSONSearchConfigurationParser.parseMandatoryStringValues(json, key);
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_OPTIONAL_STRING_LIST_MISSING_1", key), (Throwable)e);
            return null;
        }
        return list;
    }

    @Override
    public I_CmsSearchConfigurationCommon parseCommon(CmsObject cms) {
        String indexName = this.getIndex(cms);
        return new CmsSearchConfigurationCommon(this.getQueryParam(), this.getLastQueryParam(), this.getEscapeQueryChars(), this.getFirstCallParam(), this.getSearchForEmptyQuery(), this.getIgnoreQuery(), this.getQueryModifier(), indexName, this.getCore(), this.getExtraSolrParams(), this.getAdditionalParameters(), this.getIgnoreReleaseDate(), this.getIgnoreExpirationDate(), this.getMaxReturnedResults(indexName));
    }

    @Override
    public I_CmsSearchConfigurationDidYouMean parseDidYouMean() {
        try {
            JSONObject didYouMean = this.m_configObject.getJSONObject(JSON_KEY_DIDYOUMEAN);
            String param = CmsJSONSearchConfigurationParser.parseOptionalStringValue(didYouMean, JSON_KEY_DIDYOUMEAN_QUERYPARAM);
            if (null == param) {
                param = this.getQueryParam();
            }
            Boolean collate = CmsJSONSearchConfigurationParser.parseOptionalBooleanValue(didYouMean, JSON_KEY_DIDYOUMEAN_COLLATE);
            Integer count = CmsJSONSearchConfigurationParser.parseOptionalIntValue(didYouMean, JSON_KEY_DIDYOUMEAN_COUNT);
            return new CmsSearchConfigurationDidYouMean(param, collate, count);
        }
        catch (JSONException e) {
            if (null == this.m_baseConfig) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_NO_HIGHLIGHTING_CONFIG_0"), (Throwable)e);
                }
                return null;
            }
            return this.m_baseConfig.getDidYouMeanConfig();
        }
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetField> parseFieldFacets() {
        Map<String, I_CmsSearchConfigurationFacetField> facetConfigs = new LinkedHashMap<String, I_CmsSearchConfigurationFacetField>();
        try {
            JSONArray fieldFacets = this.m_configObject.getJSONArray(JSON_KEY_FIELD_FACETS);
            for (int i = 0; i < fieldFacets.length(); ++i) {
                I_CmsSearchConfigurationFacetField config = this.parseFieldFacet(fieldFacets.getJSONObject(i));
                if (config == null) continue;
                facetConfigs.put(config.getName(), config);
            }
        }
        catch (JSONException e) {
            if (null == this.m_baseConfig) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_NO_FACET_CONFIG_0"), (Throwable)e);
                }
            }
            facetConfigs = this.m_baseConfig.getFieldFacetConfigs();
        }
        return facetConfigs;
    }

    @Override
    public I_CmsSearchConfigurationGeoFilter parseGeoFilter() {
        try {
            JSONObject geoFilter = this.m_configObject.getJSONObject(JSON_KEY_GEO_FILTER);
            String coordinates = CmsJSONSearchConfigurationParser.parseOptionalStringValue(geoFilter, JSON_KEY_GEO_FILTER_COORDINATES);
            String coordinatesParam = CmsJSONSearchConfigurationParser.parseOptionalStringValue(geoFilter, JSON_KEY_GEO_FILTER_COORDINATES_PARAM);
            String fieldName = CmsJSONSearchConfigurationParser.parseOptionalStringValue(geoFilter, JSON_KEY_GEO_FILTER_FIELD_NAME);
            String radius = CmsJSONSearchConfigurationParser.parseOptionalStringValue(geoFilter, JSON_KEY_GEO_FILTER_RADIUS);
            String radiusParam = CmsJSONSearchConfigurationParser.parseOptionalStringValue(geoFilter, JSON_KEY_GEO_FILTER_RADIUS_PARAM);
            String units = CmsJSONSearchConfigurationParser.parseOptionalStringValue(geoFilter, JSON_KEY_GEO_FILTER_UNITS);
            String unitsParam = CmsJSONSearchConfigurationParser.parseOptionalStringValue(geoFilter, JSON_KEY_GEO_FILTER_UNITS_PARAM);
            return new CmsSearchConfigurationGeoFilter(coordinates, coordinatesParam, fieldName, radius, radiusParam, units, unitsParam);
        }
        catch (JSONException e) {
            if (null == this.m_baseConfig) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_NO_GEOFILTER_CONFIG_0"), (Throwable)e);
                }
                return null;
            }
            return this.m_baseConfig.getGeoFilterConfig();
        }
    }

    @Override
    public I_CmsSearchConfigurationHighlighting parseHighlighter() {
        try {
            JSONObject highlighter = this.m_configObject.getJSONObject(JSON_KEY_HIGHLIGHTER);
            String field = highlighter.getString("field");
            Integer snippets = CmsJSONSearchConfigurationParser.parseOptionalIntValue(highlighter, JSON_KEY_HIGHLIGHTER_SNIPPETS);
            Integer fragsize = CmsJSONSearchConfigurationParser.parseOptionalIntValue(highlighter, JSON_KEY_HIGHLIGHTER_FRAGSIZE);
            String alternateField = CmsJSONSearchConfigurationParser.parseOptionalStringValue(highlighter, JSON_KEY_HIGHLIGHTER_ALTERNATE_FIELD);
            Integer maxAlternateFieldLength = CmsJSONSearchConfigurationParser.parseOptionalIntValue(highlighter, JSON_KEY_HIGHLIGHTER_MAX_LENGTH_ALTERNATE_FIELD);
            String pre = CmsJSONSearchConfigurationParser.parseOptionalStringValue(highlighter, JSON_KEY_HIGHLIGHTER_SIMPLE_PRE);
            String post = CmsJSONSearchConfigurationParser.parseOptionalStringValue(highlighter, JSON_KEY_HIGHLIGHTER_SIMPLE_POST);
            String formatter = CmsJSONSearchConfigurationParser.parseOptionalStringValue(highlighter, JSON_KEY_HIGHLIGHTER_FORMATTER);
            String fragmenter = CmsJSONSearchConfigurationParser.parseOptionalStringValue(highlighter, JSON_KEY_HIGHLIGHTER_FRAGMENTER);
            Boolean useFastVectorHighlighting = CmsJSONSearchConfigurationParser.parseOptionalBooleanValue(highlighter, JSON_KEY_HIGHLIGHTER_FASTVECTORHIGHLIGHTING);
            return new CmsSearchConfigurationHighlighting(field, snippets, fragsize, alternateField, maxAlternateFieldLength, pre, post, formatter, fragmenter, useFastVectorHighlighting);
        }
        catch (JSONException e) {
            if (null == this.m_baseConfig) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_NO_HIGHLIGHTING_CONFIG_0"), (Throwable)e);
                }
                return null;
            }
            return this.m_baseConfig.getHighlighterConfig();
        }
    }

    @Override
    public I_CmsSearchConfigurationPagination parsePagination() {
        return CmsSearchConfigurationPagination.create(this.getPageParam(), this.getPageSizes(), this.getPageNavLength());
    }

    @Override
    public I_CmsSearchConfigurationFacetQuery parseQueryFacet() {
        try {
            JSONObject queryFacetObject = this.m_configObject.getJSONObject(JSON_KEY_QUERY_FACET);
            try {
                List<I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem> queries = this.parseFacetQueryItems(queryFacetObject);
                String label = CmsJSONSearchConfigurationParser.parseOptionalStringValue(queryFacetObject, "label");
                Boolean isAndFacet = CmsJSONSearchConfigurationParser.parseOptionalBooleanValue(queryFacetObject, JSON_KEY_FACET_ISANDFACET);
                List<String> preselection = CmsJSONSearchConfigurationParser.parseOptionalStringValues(queryFacetObject, JSON_KEY_FACET_PRESELECTION);
                Boolean ignoreAllFacetFilters = CmsJSONSearchConfigurationParser.parseOptionalBooleanValue(queryFacetObject, JSON_KEY_FACET_IGNOREALLFACETFILTERS);
                List<String> excludeTags = CmsJSONSearchConfigurationParser.parseOptionalStringValues(queryFacetObject, JSON_KEY_FACET_EXCLUDETAGS);
                return new CmsSearchConfigurationFacetQuery(queries, label, isAndFacet, preselection, ignoreAllFacetFilters, excludeTags);
            }
            catch (JSONException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_QUERY_FACET_MANDATORY_KEY_MISSING_1", JSON_KEY_QUERY_FACET_QUERY), (Throwable)e);
                return null;
            }
        }
        catch (JSONException e) {
            return null != this.m_baseConfig ? this.m_baseConfig.getQueryFacetConfig() : null;
        }
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetRange> parseRangeFacets() {
        Map<String, I_CmsSearchConfigurationFacetRange> facetConfigs = new LinkedHashMap<String, I_CmsSearchConfigurationFacetRange>();
        try {
            JSONArray rangeFacets = this.m_configObject.getJSONArray(JSON_KEY_RANGE_FACETS);
            for (int i = 0; i < rangeFacets.length(); ++i) {
                I_CmsSearchConfigurationFacetRange config = this.parseRangeFacet(rangeFacets.getJSONObject(i));
                if (config == null) continue;
                facetConfigs.put(config.getName(), config);
            }
        }
        catch (JSONException e) {
            if (null == this.m_baseConfig) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_NO_FACET_CONFIG_0"), (Throwable)e);
                }
            }
            facetConfigs = this.m_baseConfig.getRangeFacetConfigs();
        }
        return facetConfigs;
    }

    @Override
    public I_CmsSearchConfigurationSorting parseSorting() {
        List<I_CmsSearchConfigurationSortOption> options = this.getSortOptions();
        String defaultOptionParamValue = CmsJSONSearchConfigurationParser.parseOptionalStringValue(this.m_configObject, JSON_KEY_DEFAULT_SORT_OPTION);
        I_CmsSearchConfigurationSortOption defaultSortOption = null;
        if (null != defaultOptionParamValue) {
            Iterator<I_CmsSearchConfigurationSortOption> optIterator = options.iterator();
            while (null == defaultSortOption && optIterator.hasNext()) {
                I_CmsSearchConfigurationSortOption opt = optIterator.next();
                if (!Objects.equals(opt.getParamValue(), defaultOptionParamValue)) continue;
                defaultSortOption = opt;
            }
        }
        if (null == defaultSortOption && !options.isEmpty()) {
            defaultSortOption = options.get(0);
        }
        return CmsSearchConfigurationSorting.create(this.getSortParam(), options, defaultSortOption);
    }

    protected Map<String, String> getAdditionalParameters() {
        HashMap<String, String> result;
        try {
            JSONArray additionalParams = this.m_configObject.getJSONArray(JSON_KEY_ADDITIONAL_PARAMETERS);
            result = new HashMap<String, String>(additionalParams.length());
            for (int i = 0; i < additionalParams.length(); ++i) {
                try {
                    JSONObject currentParam = additionalParams.getJSONObject(i);
                    String param = currentParam.getString(JSON_KEY_ADDITIONAL_PARAMETERS_PARAM);
                    String solrQuery = CmsJSONSearchConfigurationParser.parseOptionalStringValue(currentParam, JSON_KEY_ADDITIONAL_PARAMETERS_SOLRQUERY);
                    result.put(param, solrQuery);
                    continue;
                }
                catch (JSONException e) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_ADDITIONAL_PARAMETER_CONFIG_WRONG_0"), (Throwable)e);
                }
            }
        }
        catch (JSONException e) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_ADDITIONAL_PARAMETER_CONFIG_NOT_PARSED_0"), (Throwable)e);
            return null != this.m_baseConfig ? this.m_baseConfig.getGeneralConfig().getAdditionalParameters() : new HashMap();
        }
        return result;
    }

    protected String getCore() {
        try {
            return this.m_configObject.getString(JSON_KEY_CORE);
        }
        catch (JSONException e) {
            if (null == this.m_baseConfig) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_NO_CORE_SPECIFIED_0"), (Throwable)e);
                }
                return null;
            }
            return this.m_baseConfig.getGeneralConfig().getSolrCore();
        }
    }

    protected Boolean getEscapeQueryChars() {
        Boolean isEscape = CmsJSONSearchConfigurationParser.parseOptionalBooleanValue(this.m_configObject, JSON_KEY_ESCAPE_QUERY_CHARACTERS);
        return null == isEscape && this.m_baseConfig != null ? Boolean.valueOf(this.m_baseConfig.getGeneralConfig().getEscapeQueryChars()) : isEscape;
    }

    protected String getExtraSolrParams() {
        try {
            return this.m_configObject.getString(JSON_KEY_EXTRASOLRPARAMS);
        }
        catch (JSONException e) {
            if (null == this.m_baseConfig) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_NO_EXTRA_PARAMETERS_0"), (Throwable)e);
                }
                return "";
            }
            return this.m_baseConfig.getGeneralConfig().getExtraSolrParams();
        }
    }

    protected String getFirstCallParam() {
        String param = CmsJSONSearchConfigurationParser.parseOptionalStringValue(this.m_configObject, JSON_KEY_RELOADED_PARAM);
        if (param == null) {
            return null != this.m_baseConfig ? this.m_baseConfig.getGeneralConfig().getReloadedParam() : DEFAULT_RELOADED_PARAM;
        }
        return param;
    }

    protected Boolean getIgnoreExpirationDate() {
        Boolean isIgnoreExpirationDate = CmsJSONSearchConfigurationParser.parseOptionalBooleanValue(this.m_configObject, JSON_KEY_IGNORE_EXPIRATION_DATE);
        return null == isIgnoreExpirationDate && this.m_baseConfig != null ? Boolean.valueOf(this.m_baseConfig.getGeneralConfig().getIgnoreExpirationDate()) : isIgnoreExpirationDate;
    }

    protected Boolean getIgnoreQuery() {
        Boolean isIgnoreQuery = CmsJSONSearchConfigurationParser.parseOptionalBooleanValue(this.m_configObject, JSON_KEY_IGNORE_QUERY);
        return null == isIgnoreQuery && this.m_baseConfig != null ? Boolean.valueOf(this.m_baseConfig.getGeneralConfig().getIgnoreQueryParam()) : isIgnoreQuery;
    }

    protected Boolean getIgnoreReleaseDate() {
        Boolean isIgnoreReleaseDate = CmsJSONSearchConfigurationParser.parseOptionalBooleanValue(this.m_configObject, JSON_KEY_IGNORE_RELEASE_DATE);
        return null == isIgnoreReleaseDate && this.m_baseConfig != null ? Boolean.valueOf(this.m_baseConfig.getGeneralConfig().getIgnoreReleaseDate()) : isIgnoreReleaseDate;
    }

    protected String getIndex(CmsObject cms) {
        String indexName = null;
        try {
            indexName = this.m_configObject.getString(JSON_KEY_INDEX);
        }
        catch (JSONException e) {
            if (null == this.m_baseConfig) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_NO_INDEX_SPECIFIED_0"), (Throwable)e);
                }
            }
            indexName = this.m_baseConfig.getGeneralConfig().getSolrIndex();
        }
        return null != indexName ? indexName : (cms.getRequestContext().getCurrentProject().isOnlineProject() ? "Solr Online" : "Solr Offline");
    }

    protected String getLastQueryParam() {
        String param = CmsJSONSearchConfigurationParser.parseOptionalStringValue(this.m_configObject, JSON_KEY_LAST_QUERYPARAM);
        if (param == null) {
            return null != this.m_baseConfig ? this.m_baseConfig.getGeneralConfig().getLastQueryParam() : DEFAULT_LAST_QUERY_PARAM;
        }
        return param;
    }

    protected int getMaxReturnedResults(String indexName) {
        Integer maxReturnedResults = CmsJSONSearchConfigurationParser.parseOptionalIntValue(this.m_configObject, JSON_KEY_MAX_RETURNED_RESULTS);
        if (null != maxReturnedResults) {
            return maxReturnedResults;
        }
        if (this.m_baseConfig != null) {
            return this.m_baseConfig.getGeneralConfig().getMaxReturnedResults();
        }
        try {
            CmsSolrIndex idx = OpenCms.getSearchManager().getIndexSolr(indexName);
            if (null != idx) {
                return idx.getMaxProcessedResults();
            }
        }
        catch (Throwable t) {
            LOG.debug((Object)("Parsing JSON search configuration for none-CmsSolrIndex " + indexName + ". Setting max processed results to unlimited."));
        }
        return -1;
    }

    protected Integer getPageNavLength() {
        return CmsJSONSearchConfigurationParser.parseOptionalIntValue(this.m_configObject, JSON_KEY_PAGENAVLENGTH);
    }

    protected String getPageParam() {
        return CmsJSONSearchConfigurationParser.parseOptionalStringValue(this.m_configObject, JSON_KEY_PAGEPARAM);
    }

    protected List<Integer> getPageSizes() {
        try {
            return Collections.singletonList(this.m_configObject.getInt(JSON_KEY_PAGESIZE));
        }
        catch (JSONException e) {
            ArrayList<Integer> result = null;
            String pageSizesString = null;
            try {
                pageSizesString = this.m_configObject.getString(JSON_KEY_PAGESIZE);
                String[] pageSizesArray = pageSizesString.split("-");
                if (pageSizesArray.length > 0) {
                    result = new ArrayList<Integer>(pageSizesArray.length);
                    for (int i = 0; i < pageSizesArray.length; ++i) {
                        result.add(Integer.valueOf(pageSizesArray[i]));
                    }
                }
                return result;
            }
            catch (NumberFormatException | JSONException e1) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_PARSING_PAGE_SIZES_FAILED_1", pageSizesString), (Throwable)e);
                if (null == this.m_baseConfig) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)Messages.get().getBundle().key("LOG_NO_PAGESIZE_SPECIFIED_0"), (Throwable)e);
                    }
                    return null;
                }
                return this.m_baseConfig.getPaginationConfig().getPageSizes();
            }
        }
    }

    protected String getQueryModifier() {
        String queryModifier = CmsJSONSearchConfigurationParser.parseOptionalStringValue(this.m_configObject, JSON_KEY_QUERY_MODIFIER);
        return null == queryModifier && null != this.m_baseConfig ? this.m_baseConfig.getGeneralConfig().getQueryModifier() : queryModifier;
    }

    protected String getQueryParam() {
        String param = CmsJSONSearchConfigurationParser.parseOptionalStringValue(this.m_configObject, JSON_KEY_QUERYPARAM);
        if (param == null) {
            return null != this.m_baseConfig ? this.m_baseConfig.getGeneralConfig().getQueryParam() : DEFAULT_QUERY_PARAM;
        }
        return param;
    }

    protected Boolean getSearchForEmptyQuery() {
        Boolean isSearchForEmptyQuery = CmsJSONSearchConfigurationParser.parseOptionalBooleanValue(this.m_configObject, JSON_KEY_SEARCH_FOR_EMPTY_QUERY);
        return isSearchForEmptyQuery == null && null != this.m_baseConfig ? Boolean.valueOf(this.m_baseConfig.getGeneralConfig().getSearchForEmptyQueryParam()) : isSearchForEmptyQuery;
    }

    protected List<I_CmsSearchConfigurationSortOption> getSortOptions() {
        List<I_CmsSearchConfigurationSortOption> options = new LinkedList<I_CmsSearchConfigurationSortOption>();
        try {
            JSONArray sortOptions = this.m_configObject.getJSONArray(JSON_KEY_SORTOPTIONS);
            for (int i = 0; i < sortOptions.length(); ++i) {
                I_CmsSearchConfigurationSortOption option = this.parseSortOption(sortOptions.getJSONObject(i));
                if (option == null) continue;
                options.add(option);
            }
        }
        catch (JSONException e) {
            if (null == this.m_baseConfig) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_NO_SORT_CONFIG_0"), (Throwable)e);
                }
            }
            options = this.m_baseConfig.getSortConfig().getSortOptions();
        }
        return options;
    }

    protected String getSortParam() {
        return CmsJSONSearchConfigurationParser.parseOptionalStringValue(this.m_configObject, JSON_KEY_SORTPARAM);
    }

    protected void init(String configString, I_CmsSearchConfiguration baseConfig) throws JSONException {
        this.m_configObject = new JSONObject(configString);
        this.m_baseConfig = baseConfig;
    }

    protected I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem parseFacetQueryItem(JSONObject item) {
        String query;
        try {
            query = item.getString(JSON_KEY_QUERY_FACET_QUERY_QUERY);
        }
        catch (JSONException e) {
            return null;
        }
        String label = CmsJSONSearchConfigurationParser.parseOptionalStringValue(item, "label");
        return new CmsSearchConfigurationFacetQuery.CmsFacetQueryItem(query, label);
    }

    protected List<I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem> parseFacetQueryItems(JSONObject queryFacetObject) throws JSONException {
        JSONArray items = queryFacetObject.getJSONArray(JSON_KEY_QUERY_FACET_QUERY);
        ArrayList<I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem> result = new ArrayList<I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem>(items.length());
        for (int i = 0; i < items.length(); ++i) {
            I_CmsSearchConfigurationFacetQuery.I_CmsFacetQueryItem item = this.parseFacetQueryItem(items.getJSONObject(i));
            if (item == null) continue;
            result.add(item);
        }
        return result;
    }

    protected I_CmsSearchConfigurationFacetField parseFieldFacet(JSONObject fieldFacetObject) {
        try {
            I_CmsSearchConfigurationFacet.SortOrder order;
            String field = fieldFacetObject.getString("field");
            String name = CmsJSONSearchConfigurationParser.parseOptionalStringValue(fieldFacetObject, JSON_KEY_FACET_NAME);
            String label = CmsJSONSearchConfigurationParser.parseOptionalStringValue(fieldFacetObject, "label");
            Integer minCount = CmsJSONSearchConfigurationParser.parseOptionalIntValue(fieldFacetObject, JSON_KEY_FACET_MINCOUNT);
            Integer limit = CmsJSONSearchConfigurationParser.parseOptionalIntValue(fieldFacetObject, JSON_KEY_FACET_LIMIT);
            String prefix = CmsJSONSearchConfigurationParser.parseOptionalStringValue(fieldFacetObject, JSON_KEY_FACET_PREFIX);
            String sorder = CmsJSONSearchConfigurationParser.parseOptionalStringValue(fieldFacetObject, JSON_KEY_FACET_ORDER);
            try {
                order = I_CmsSearchConfigurationFacet.SortOrder.valueOf(sorder);
            }
            catch (Exception e) {
                order = null;
            }
            String filterQueryModifier = CmsJSONSearchConfigurationParser.parseOptionalStringValue(fieldFacetObject, JSON_KEY_FACET_FILTERQUERYMODIFIER);
            Boolean isAndFacet = CmsJSONSearchConfigurationParser.parseOptionalBooleanValue(fieldFacetObject, JSON_KEY_FACET_ISANDFACET);
            List<String> preselection = CmsJSONSearchConfigurationParser.parseOptionalStringValues(fieldFacetObject, JSON_KEY_FACET_PRESELECTION);
            Boolean ignoreFilterAllFacetFilters = CmsJSONSearchConfigurationParser.parseOptionalBooleanValue(fieldFacetObject, JSON_KEY_FACET_IGNOREALLFACETFILTERS);
            List<String> excludeTags = CmsJSONSearchConfigurationParser.parseOptionalStringValues(fieldFacetObject, JSON_KEY_FACET_EXCLUDETAGS);
            return new CmsSearchConfigurationFacetField(field, name, minCount, limit, prefix, label, order, filterQueryModifier, isAndFacet, preselection, ignoreFilterAllFacetFilters, excludeTags);
        }
        catch (JSONException e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_FIELD_FACET_MANDATORY_KEY_MISSING_1", "field"), (Throwable)e);
            return null;
        }
    }

    protected I_CmsSearchConfigurationFacetRange parseRangeFacet(JSONObject rangeFacetObject) {
        try {
            String range = rangeFacetObject.getString(JSON_KEY_RANGE_FACET_RANGE);
            String name = CmsJSONSearchConfigurationParser.parseOptionalStringValue(rangeFacetObject, JSON_KEY_FACET_NAME);
            String label = CmsJSONSearchConfigurationParser.parseOptionalStringValue(rangeFacetObject, "label");
            Integer minCount = CmsJSONSearchConfigurationParser.parseOptionalIntValue(rangeFacetObject, JSON_KEY_FACET_MINCOUNT);
            String start = rangeFacetObject.getString(JSON_KEY_RANGE_FACET_START);
            String end = rangeFacetObject.getString(JSON_KEY_RANGE_FACET_END);
            String gap = rangeFacetObject.getString(JSON_KEY_RANGE_FACET_GAP);
            List<String> sother = CmsJSONSearchConfigurationParser.parseOptionalStringValues(rangeFacetObject, JSON_KEY_RANGE_FACET_OTHER);
            Boolean hardEnd = CmsJSONSearchConfigurationParser.parseOptionalBooleanValue(rangeFacetObject, JSON_KEY_RANGE_FACET_HARDEND);
            ArrayList<I_CmsSearchConfigurationFacetRange.Other> other = null;
            if (sother != null) {
                other = new ArrayList<I_CmsSearchConfigurationFacetRange.Other>(sother.size());
                for (String so : sother) {
                    try {
                        I_CmsSearchConfigurationFacetRange.Other o = I_CmsSearchConfigurationFacetRange.Other.valueOf(so);
                        other.add(o);
                    }
                    catch (Exception e) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_INVALID_OTHER_OPTION_1", so), (Throwable)e);
                    }
                }
            }
            Boolean isAndFacet = CmsJSONSearchConfigurationParser.parseOptionalBooleanValue(rangeFacetObject, JSON_KEY_FACET_ISANDFACET);
            List<String> preselection = CmsJSONSearchConfigurationParser.parseOptionalStringValues(rangeFacetObject, JSON_KEY_FACET_PRESELECTION);
            Boolean ignoreAllFacetFilters = CmsJSONSearchConfigurationParser.parseOptionalBooleanValue(rangeFacetObject, JSON_KEY_FACET_IGNOREALLFACETFILTERS);
            List<String> excludeTags = CmsJSONSearchConfigurationParser.parseOptionalStringValues(rangeFacetObject, JSON_KEY_FACET_EXCLUDETAGS);
            return new CmsSearchConfigurationFacetRange(range, start, end, gap, other, hardEnd, name, minCount, label, isAndFacet, preselection, ignoreAllFacetFilters, excludeTags);
        }
        catch (JSONException e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_RANGE_FACET_MANDATORY_KEY_MISSING_1", "range, start, end, gap"), (Throwable)e);
            return null;
        }
    }

    protected I_CmsSearchConfigurationSortOption parseSortOption(JSONObject json) {
        try {
            String solrValue = json.getString(JSON_KEY_SORTOPTION_SOLRVALUE);
            String paramValue = CmsJSONSearchConfigurationParser.parseOptionalStringValue(json, JSON_KEY_SORTOPTION_PARAMVALUE);
            paramValue = paramValue == null ? solrValue : paramValue;
            String label = CmsJSONSearchConfigurationParser.parseOptionalStringValue(json, "label");
            label = label == null ? paramValue : label;
            return new CmsSearchConfigurationSortOption(label, paramValue, solrValue);
        }
        catch (JSONException e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_SORT_OPTION_NOT_PARSABLE_1", JSON_KEY_SORTOPTION_SOLRVALUE), (Throwable)e);
            return null;
        }
    }
}

