/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.config.parser;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.jsp.search.config.CmsSearchConfigurationCommon;
import org.opencms.jsp.search.config.I_CmsSearchConfiguration;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationCommon;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationDidYouMean;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetField;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetQuery;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationFacetRange;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationGeoFilter;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationHighlighting;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationPagination;
import org.opencms.jsp.search.config.I_CmsSearchConfigurationSorting;
import org.opencms.jsp.search.config.parser.I_CmsSearchConfigurationParser;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.util.CmsPair;

public class CmsPlainQuerySearchConfigurationParser
implements I_CmsSearchConfigurationParser {
    protected static final Log LOG = CmsLog.getLog(CmsPlainQuerySearchConfigurationParser.class);
    private static final String DEFAULT_FL = "id,path";
    protected String m_queryString;
    private I_CmsSearchConfiguration m_baseConfig;

    public CmsPlainQuerySearchConfigurationParser(String query) {
        this(query, null);
    }

    public CmsPlainQuerySearchConfigurationParser(String query, I_CmsSearchConfiguration baseConfig) {
        if (null != query && !((String)query).startsWith("fl=") && !((String)query).contains("&fl=")) {
            query = (String)query + "&fl=id,path";
        }
        this.m_queryString = query;
        this.m_baseConfig = baseConfig;
    }

    @Override
    public I_CmsSearchConfigurationCommon parseCommon(CmsObject cms) {
        Integer maxResNum;
        String indexName;
        CmsPair<String, String> maxResultsExtract;
        CmsPair<String, String> coreExtract;
        block8: {
            String queryString = this.m_queryString;
            CmsPair<String, String> idxExtract = this.extractParam(queryString, "index");
            coreExtract = this.extractParam(idxExtract.getFirst(), "core");
            maxResultsExtract = this.extractParam(coreExtract.getFirst(), "maxresults");
            String resString = maxResultsExtract.getSecond();
            indexName = idxExtract.getSecond();
            if (null != indexName) {
                indexName = indexName.trim();
            }
            if (null == indexName) {
                indexName = cms.getRequestContext().getCurrentProject().isOnlineProject() ? "Solr Online" : "Solr Offline";
            }
            maxResNum = null;
            if (null != resString) {
                try {
                    maxResNum = Integer.valueOf(resString);
                }
                catch (NumberFormatException e) {
                    if (!LOG.isErrorEnabled()) break block8;
                    LOG.error((Object)("Ignoring param \"maxresults=" + resString + "\" since its not a valid integer."), (Throwable)e);
                }
            }
        }
        if (null == maxResNum) {
            try {
                CmsSolrIndex idx = OpenCms.getSearchManager().getIndexSolr(indexName);
                maxResNum = null != idx ? Integer.valueOf(idx.getMaxProcessedResults()) : Integer.valueOf(-1);
            }
            catch (Throwable t) {
                LOG.debug((Object)("Parsing plain search configuration for none-CmsSolrIndex " + indexName + ". Setting max processed results to unlimited."));
                maxResNum = -1;
            }
        }
        return new CmsSearchConfigurationCommon(null, null, null, null, Boolean.TRUE, Boolean.TRUE, null, indexName, coreExtract.getSecond(), maxResultsExtract.getFirst(), null, null, null, maxResNum);
    }

    @Override
    public I_CmsSearchConfigurationDidYouMean parseDidYouMean() {
        return null != this.m_baseConfig ? this.m_baseConfig.getDidYouMeanConfig() : null;
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetField> parseFieldFacets() {
        return null != this.m_baseConfig ? this.m_baseConfig.getFieldFacetConfigs() : Collections.emptyMap();
    }

    @Override
    public I_CmsSearchConfigurationGeoFilter parseGeoFilter() {
        return null;
    }

    @Override
    public I_CmsSearchConfigurationHighlighting parseHighlighter() {
        return null != this.m_baseConfig ? this.m_baseConfig.getHighlighterConfig() : null;
    }

    @Override
    public I_CmsSearchConfigurationPagination parsePagination() {
        return null != this.m_baseConfig ? this.m_baseConfig.getPaginationConfig() : null;
    }

    @Override
    public I_CmsSearchConfigurationFacetQuery parseQueryFacet() {
        return null != this.m_baseConfig ? this.m_baseConfig.getQueryFacetConfig() : null;
    }

    @Override
    public Map<String, I_CmsSearchConfigurationFacetRange> parseRangeFacets() {
        return null != this.m_baseConfig ? this.m_baseConfig.getRangeFacetConfigs() : Collections.emptyMap();
    }

    @Override
    public I_CmsSearchConfigurationSorting parseSorting() {
        return null != this.m_baseConfig ? this.m_baseConfig.getSortConfig() : null;
    }

    CmsPair<String, String> extractParam(String params, String paramKey) {
        String extract = null;
        int beginIdx = ((String)params).indexOf(paramKey + "=");
        if (beginIdx >= 0) {
            String sub = ((String)params).substring(beginIdx + paramKey.length() + 1);
            int endIdx = sub.indexOf("&");
            if (endIdx >= 0) {
                extract = sub.substring(0, endIdx);
                params = ((String)params).substring(0, beginIdx) + sub.substring(endIdx + 1);
            } else {
                extract = sub;
                params = beginIdx > 0 ? ((String)params).substring(0, beginIdx - 1) : "";
            }
        }
        return new CmsPair<String, Object>((String)params, extract);
    }
}

