/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.search.result;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.search.result.I_CmsSearchResourceBean;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.search.CmsSearchResource;
import org.opencms.util.CmsCollectionsGenericWrapper;

public class CmsSearchResourceBean
implements I_CmsSearchResourceBean {
    final CmsSearchResource m_searchResource;
    private Map<String, String> m_stringfields;
    private Map<String, Date> m_datefields;
    private Map<String, List<String>> m_multivaluedfields;
    private Map<String, CmsJspContentAccessBean> m_localizedContent;
    final CmsObject m_cmsObject;

    public CmsSearchResourceBean(CmsSearchResource searchResource, CmsObject cms) {
        this.m_searchResource = searchResource;
        this.m_cmsObject = cms;
    }

    @Override
    public Map<String, Date> getDateFields() {
        if (this.m_datefields == null) {
            this.m_datefields = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object fieldName) {
                    return CmsSearchResourceBean.this.getSearchResource().getDateField(fieldName.toString());
                }
            });
        }
        return this.m_datefields;
    }

    @Override
    public Map<String, String> getFields() {
        if (this.m_stringfields == null) {
            this.m_stringfields = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object fieldName) {
                    return CmsSearchResourceBean.this.getSearchResource().getField(fieldName.toString());
                }
            });
        }
        return this.m_stringfields;
    }

    @Override
    public Map<String, List<String>> getMultiValuedFields() {
        if (this.m_multivaluedfields == null) {
            this.m_multivaluedfields = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object fieldName) {
                    return CmsSearchResourceBean.this.getSearchResource().getMultivaluedField(fieldName.toString());
                }
            });
        }
        return this.m_multivaluedfields;
    }

    @Override
    public CmsSearchResource getSearchResource() {
        return this.m_searchResource;
    }

    @Override
    public CmsJspContentAccessBean getXmlContent() {
        CmsJspContentAccessBean accessBean = null;
        try {
            accessBean = new CmsJspContentAccessBean(this.m_cmsObject, this.m_searchResource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return accessBean;
    }

    @Override
    public Map<String, CmsJspContentAccessBean> getXmlContentInLocale() {
        if (this.m_localizedContent == null) {
            this.m_localizedContent = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object locale) {
                    CmsJspContentAccessBean accessBean = null;
                    try {
                        accessBean = new CmsJspContentAccessBean(CmsSearchResourceBean.this.m_cmsObject, CmsLocaleManager.getLocale((String)locale), CmsSearchResourceBean.this.m_searchResource);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return accessBean;
                }
            });
        }
        return this.m_localizedContent;
    }
}

