/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.userdata;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.xml.content.CmsXmlContent;

public class CmsUserDataRequestConfig {
    private static final Log LOG = CmsLog.getLog(CmsUserDataRequestConfig.class);
    private CmsObject m_cms;
    private CmsXmlContent m_content;
    private Locale m_locale;

    public CmsUserDataRequestConfig(CmsObject cms, CmsXmlContent content, Locale locale) {
        this.m_content = content;
        this.m_cms = cms;
        this.m_locale = OpenCms.getLocaleManager().getBestMatchingLocale(locale, content.getLocales(), content.getLocales());
    }

    public String getMailSubject() {
        return this.getText("MailSubject");
    }

    public String getMailText() {
        return this.getText("MailText");
    }

    public long getRequestLifetime() {
        String lifetimeStr = this.getText("LinkHoursValid");
        long hours = 24L;
        try {
            hours = Long.parseLong(lifetimeStr.trim());
        }
        catch (NumberFormatException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return hours * 60L * 60L * 1000L;
    }

    public String getText(String key) {
        if (this.m_content.hasValue(key, this.m_locale)) {
            try {
                return this.m_content.getValue(key, this.m_locale).getStringValue(this.m_cms);
            }
            catch (Exception e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return "???" + key + "???";
    }
}

