/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.userdata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.jsp.userdata.CmsUserDataRequestInfo;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsFileUtil;

public class CmsUserDataRequestStore {
    private static final Log LOG = CmsLog.getLog(CmsUserDataRequestStore.class);
    private CmsObject m_adminCms;
    private File m_folder;

    public CmsUserDataRequestStore() {
        LOG.debug((Object)"Creating user data request store.");
    }

    public static boolean isValidKey(String key) {
        return StringUtils.isAlphanumeric((CharSequence)key);
    }

    public void cleanup() {
        File[] files = this.m_folder.listFiles();
        if (files != null) {
            for (File file : files) {
                String key = file.getName();
                try {
                    CmsUserDataRequestInfo info = this.load(key).orElse(null);
                    if (info == null || !info.isExpired()) continue;
                    file.delete();
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    public void initialize(CmsObject adminCms) {
        this.m_adminCms = adminCms;
        this.m_folder = new File(OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf("userdata-requests"));
        if (!this.m_folder.exists()) {
            this.m_folder.mkdir();
        }
        OpenCms.getExecutor().scheduleWithFixedDelay(() -> this.cleanup(), 30L, 30L, TimeUnit.MINUTES);
    }

    public Optional<CmsUserDataRequestInfo> load(String key) {
        if (!CmsUserDataRequestStore.isValidKey(key)) {
            return Optional.empty();
        }
        File child = new File(this.m_folder, key);
        if (child.exists() && child.isFile()) {
            Optional<CmsUserDataRequestInfo> optional;
            FileInputStream stream = new FileInputStream(child);
            try {
                byte[] data = CmsFileUtil.readFully((InputStream)stream, false);
                optional = Optional.of(new CmsUserDataRequestInfo(new String(data, "UTF-8")));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    return Optional.empty();
                }
            }
            stream.close();
            return optional;
        }
        LOG.info((Object)("user data request " + key + " not found."));
        return Optional.empty();
    }

    public void save(CmsUserDataRequestInfo info) {
        if (!CmsUserDataRequestStore.isValidKey(info.getId())) {
            return;
        }
        File child = new File(this.m_folder, info.getId());
        try (FileOutputStream out = new FileOutputStream(child);){
            out.write(info.toJson().getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

