/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.htmlparser.util.ParserException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeFolderSubSitemap;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.json.JSONTokener;
import org.opencms.jsp.CmsJspResourceWrapper;
import org.opencms.jsp.util.A_CmsJspValueWrapper;
import org.opencms.jsp.util.CmsJspContentAccessValueWrapper;
import org.opencms.jsp.util.CmsJspVfsAccessBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.util.CmsHtmlConverter;
import org.opencms.util.CmsHtmlExtractor;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public final class CmsJspElFunctions {
    private static final Log LOG = CmsLog.getLog(CmsJspElFunctions.class);

    private CmsJspElFunctions() {
    }

    public static void addToList(List<Object> list, Object value) {
        list.add(value);
    }

    public static CmsObject convertCmsObject(Object input) {
        ServletRequest req;
        CmsObject result;
        if (input instanceof CmsObject) {
            result = (CmsObject)input;
        } else if (input instanceof ServletRequest) {
            result = CmsFlexController.getCmsObject((ServletRequest)input);
        } else if (input instanceof PageContext) {
            result = CmsFlexController.getCmsObject(((PageContext)input).getRequest());
        } else {
            try {
                result = OpenCms.initCmsObject(String.valueOf(input));
                req = CmsJspElFunctions.convertRequest(input);
                if (req instanceof HttpServletRequest) {
                    result.getRequestContext().setSiteRoot(OpenCms.getSiteManager().matchRequest((HttpServletRequest)req).getSiteRoot());
                }
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                result = null;
            }
        }
        if (result == null) {
            try {
                result = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
                req = CmsJspElFunctions.convertRequest(input);
                if (req instanceof HttpServletRequest) {
                    result.getRequestContext().setSiteRoot(OpenCms.getSiteManager().matchRequest((HttpServletRequest)req).getSiteRoot());
                }
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Date convertDate(Object input) {
        Date result;
        block8: {
            if (input instanceof Date) {
                result = (Date)input;
            } else if (input instanceof Long) {
                result = new Date((Long)input);
            } else {
                String str = String.valueOf(input);
                try {
                    long l = Long.parseLong(str);
                    result = new Date(l);
                }
                catch (NumberFormatException e) {
                    try {
                        result = DateFormat.getDateInstance().parse(str);
                    }
                    catch (ParseException e1) {
                        result = null;
                    }
                    if (result != null) break block8;
                    result = new Date(0L);
                }
            }
        }
        return result;
    }

    public static Double convertDouble(Object input) {
        Double result = null;
        if (input instanceof Double) {
            result = (Double)input;
        } else if (input instanceof Number) {
            result = ((Number)input).doubleValue();
        } else if (input instanceof A_CmsJspValueWrapper) {
            result = ((A_CmsJspValueWrapper)input).getToDouble();
        } else if (input != null) {
            String str = String.valueOf(input);
            str = str.replace(',', '.');
            try {
                result = Double.valueOf(str);
            }
            catch (NumberFormatException e) {
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        return result;
    }

    public static List<Object> convertList(List<Object> input, String attributeName) {
        ArrayList<Object> result = new ArrayList<Object>(input.size());
        for (Object item : input) {
            try {
                result.add(PropertyUtils.getProperty((Object)item, (String)attributeName));
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }
        return result;
    }

    public static Locale convertLocale(Object input) {
        Locale locale = input instanceof Locale ? (Locale)input : CmsLocaleManager.getLocale(String.valueOf(input));
        return locale;
    }

    public static CmsResource convertRawResource(CmsObject cms, Object input) throws CmsException {
        CmsResourceFilter filter = CmsResourceFilter.ignoreExpirationOffline(cms);
        CmsResource result = input instanceof CmsResource ? (CmsResource)input : (input instanceof String ? (CmsUUID.isValidUUID((String)input) ? cms.readResource(CmsUUID.valueOf((String)input), filter) : cms.readResource(cms.getRequestContext().removeSiteRoot((String)input), filter)) : (input instanceof CmsUUID ? cms.readResource((CmsUUID)input, filter) : cms.readResource(String.valueOf(input), filter)));
        return result;
    }

    public static ServletRequest convertRequest(Object input) {
        ServletRequest req = null;
        if (input instanceof ServletRequest) {
            req = (ServletRequest)input;
        } else if (input instanceof PageContext) {
            req = ((PageContext)input).getRequest();
        }
        return req;
    }

    public static CmsJspResourceWrapper convertResource(CmsObject cms, Object input) throws CmsException {
        CmsJspResourceWrapper result = input instanceof CmsResource ? CmsJspResourceWrapper.wrap(cms, (CmsResource)input) : CmsJspResourceWrapper.wrap(cms, CmsJspElFunctions.convertRawResource(cms, input));
        return result;
    }

    public static List<CmsJspResourceWrapper> convertResourceList(CmsObject cms, List<CmsResource> list) {
        ArrayList<CmsJspResourceWrapper> result = new ArrayList<CmsJspResourceWrapper>(list.size());
        for (CmsResource res : list) {
            result.add(CmsJspResourceWrapper.wrap(cms, res));
        }
        return result;
    }

    public static CmsUUID convertUUID(Object input) {
        CmsUUID uuid = input instanceof CmsUUID ? (CmsUUID)input : (input instanceof byte[] ? new CmsUUID((byte[])input) : new CmsUUID(String.valueOf(input)));
        return uuid;
    }

    public static List<Object> createList() {
        return new ArrayList<Object>();
    }

    public static CmsObject getCmsObject(Object input) {
        return CmsJspElFunctions.convertCmsObject(input);
    }

    public static Integer getListSize(Collection<Object> input) {
        if (input != null) {
            return input.size();
        }
        return 0;
    }

    public static String getModuleParam(String name, String key) {
        CmsModule module = OpenCms.getModuleManager().getModule(name);
        if (module != null) {
            return module.getParameter(key);
        }
        return null;
    }

    @Deprecated
    public static String getNavigationUri(Object input) {
        ServletRequest req = CmsJspElFunctions.convertRequest(input);
        if (req == null) {
            return null;
        }
        return CmsJspElFunctions.getCmsObject(input).getRequestContext().getUri();
    }

    public static String getRequestLink(String url) {
        return CmsRequestUtil.getRequestLink(url);
    }

    public static String getRequestParam(String url, String paramName) {
        String[] result;
        int pos;
        Map<Object, Object> params = Collections.emptyMap();
        if (CmsStringUtil.isNotEmpty(url) && (pos = url.indexOf("?")) >= 0) {
            params = CmsRequestUtil.createParameterMap(url.substring(pos + 1));
        }
        if ((result = (String[])params.get(paramName)) != null) {
            return result[0];
        }
        return null;
    }

    public static CmsJspVfsAccessBean getVfsAccessBean(Object input) {
        return CmsJspVfsAccessBean.create(CmsJspElFunctions.convertCmsObject(input));
    }

    public static boolean isSubSitemap(CmsResource resource) {
        return resource != null && CmsResourceTypeFolderSubSitemap.isSubSitemap(resource);
    }

    public static boolean isWrapper(Object value) {
        return value instanceof A_CmsJspValueWrapper;
    }

    public static String jsonGetString(Object maybeJsonString, Object key) {
        try {
            if (maybeJsonString == null) {
                return null;
            }
            String jsonString = (String)maybeJsonString;
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(jsonString)) {
                return null;
            }
            JSONObject json = new JSONObject(jsonString);
            String keyString = (String)key;
            return json.optString(keyString);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, String> jsonToMap(String jsonString) {
        HashMap result = Maps.newHashMap();
        if (jsonString != null) {
            try {
                JSONObject json = new JSONObject(jsonString);
                for (String key : json.keySet()) {
                    String value = json.optString(key);
                    if (value == null) continue;
                    result.put(key, value);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static String lookup(String key, String map) {
        return CmsJspElFunctions.lookup(key, map, "");
    }

    public static String lookup(String key, String map, String defaultValue) {
        Map<String, String> values = CmsStringUtil.splitAsMap(map, "|", ":");
        String result = values.get(key);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(result)) {
            return defaultValue;
        }
        return result;
    }

    public static Long mathCeil(Object param) {
        Long result = null;
        if (param instanceof Long || param instanceof Integer) {
            result = ((Number)param).longValue();
        } else {
            Double d = CmsJspElFunctions.convertDouble(param);
            if (d != null) {
                result = (long)Math.ceil(d);
            }
        }
        return result;
    }

    public static Long mathFloor(Object param) {
        Long result = null;
        if (param instanceof Long || param instanceof Integer) {
            result = ((Number)param).longValue();
        } else {
            Double d = CmsJspElFunctions.convertDouble(param);
            if (d != null) {
                result = (long)Math.floor(d);
            }
        }
        return result;
    }

    public static Long mathRound(Object param) {
        Long result = null;
        if (param instanceof Long || param instanceof Integer) {
            result = ((Number)param).longValue();
        } else {
            Double d = CmsJspElFunctions.convertDouble(param);
            if (d != null) {
                result = Math.round(d);
            }
        }
        return result;
    }

    public static Object parseJson(String value) {
        value = value.trim();
        JSONTokener tok = new JSONTokener(value);
        try {
            return tok.nextValue();
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static String repairHtml(String input) {
        CmsHtmlConverter converter = new CmsHtmlConverter();
        String result = converter.convertToStringSilent(input);
        return result == null ? "" : result;
    }

    public static String stripHtml(Object input) {
        if (input instanceof CmsJspContentAccessValueWrapper) {
            CmsJspContentAccessValueWrapper wrapper = (CmsJspContentAccessValueWrapper)input;
            if (wrapper.getExists()) {
                return wrapper.getContentValue().getPlainText(wrapper.getCmsObject());
            }
            return "";
        }
        try {
            return CmsHtmlExtractor.extractText(String.valueOf(input), OpenCms.getSystemInfo().getDefaultEncoding());
        }
        catch (ParserException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public static Double toNumber(Object input, Object def) {
        Double result = CmsJspElFunctions.convertDouble(input);
        if (result == null) {
            result = CmsJspElFunctions.convertDouble(def);
        }
        if (result == null) {
            result = -1.0;
        }
        return result;
    }

    public static String trimToSize(String input, int length) {
        return CmsStringUtil.trimToSize(input, length, " ...");
    }

    public static boolean validateRegex(String value, String regex) {
        return CmsStringUtil.validateRegex(value, regex, true);
    }
}

