/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspResourceWrapper;
import org.opencms.jsp.util.A_CmsJspValueWrapper;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.types.CmsXmlVarLinkValue;

public class CmsJspLinkWrapper
extends AbstractCollection<String> {
    private static final Log LOG = CmsLog.getLog(CmsJspLinkWrapper.class);
    protected CmsObject m_cms;
    protected String m_link;
    protected Boolean m_internal;
    protected Optional<CmsResource> m_resource;
    protected Map<String, String> m_stringCache = new ConcurrentHashMap<String, String>();
    private boolean m_allowEmpty;

    public CmsJspLinkWrapper(CmsObject cms, String link) {
        this(cms, link, false);
    }

    public CmsJspLinkWrapper(CmsObject cms, String link, boolean allowEmpty) {
        this.m_cms = cms;
        this.m_link = link;
        this.m_allowEmpty = allowEmpty;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsJspLinkWrapper) {
            return obj.toString().equals(this.toString());
        }
        return false;
    }

    public boolean getIsInternal() {
        if (this.m_internal == null) {
            this.m_internal = this.isEmpty() ? Boolean.FALSE : Boolean.valueOf(null != CmsXmlVarLinkValue.getInternalPathAndQuery(this.m_cms, this.getServerLink()));
        }
        return this.m_internal;
    }

    public String getLink() {
        return this.m_stringCache.computeIfAbsent("link", k -> !this.isEmpty() ? A_CmsJspValueWrapper.substituteLink(this.m_cms, this.m_link) : "");
    }

    public String getLiteral() {
        return this.m_link;
    }

    public String getOnlineLink() {
        return this.m_stringCache.computeIfAbsent("online", k -> !this.isEmpty() ? OpenCms.getLinkManager().getOnlineLink(this.m_cms, this.m_link) : "");
    }

    public String getPermaLink() {
        return this.m_stringCache.computeIfAbsent("perma", k -> !this.isEmpty() ? OpenCms.getLinkManager().getPermalink(this.m_cms, this.m_link) : "");
    }

    public CmsJspResourceWrapper getResource() {
        if (this.m_resource == null) {
            try {
                String link = CmsXmlVarLinkValue.getInternalPathAndQuery(this.m_cms, this.getServerLink());
                if (link == null) {
                    this.m_resource = Optional.empty();
                } else {
                    CmsLink linkObj = new CmsLink(null, CmsRelationType.HYPERLINK, link, true);
                    linkObj.checkConsistency(this.m_cms);
                    this.m_resource = Optional.ofNullable(linkObj.getResource());
                }
            }
            catch (Exception e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                this.m_resource = Optional.empty();
            }
        }
        if (this.m_resource.isPresent()) {
            return CmsJspResourceWrapper.wrap(this.m_cms, this.m_resource.get());
        }
        return null;
    }

    public String getServerLink() {
        return this.m_stringCache.computeIfAbsent("server", k -> !this.isEmpty() ? OpenCms.getLinkManager().getServerLink(this.m_cms, this.m_link) : "");
    }

    public String getToString() {
        return this.toString();
    }

    public URI getToURI() {
        return this.toURI();
    }

    @Override
    public int hashCode() {
        if (this.m_link == null) {
            return 0;
        }
        return this.toString().hashCode();
    }

    @Override
    public boolean isEmpty() {
        if (this.m_allowEmpty) {
            return this.m_link == null;
        }
        return CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_link);
    }

    @Override
    public Iterator<String> iterator() {
        return this.isEmpty() ? Collections.emptyIterator() : Collections.singletonList(this.toString()).iterator();
    }

    @Override
    public int size() {
        return this.isEmpty() ? 0 : 1;
    }

    @Override
    public String toString() {
        return this.getLink();
    }

    public URI toURI() {
        if (this.m_link == null) {
            return null;
        }
        try {
            return new URI(this.m_link);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

