/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsObject;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.util.CmsFormatterInfoWrapper;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.jsp.util.I_CmsFormatterInfo;
import org.opencms.main.OpenCms;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsResourceTypeInfoWrapper
implements I_CmsFormatterInfo {
    private boolean m_active;
    private List<I_CmsFormatterBean> m_activeFormatters = new ArrayList<I_CmsFormatterBean>();
    private Multimap<String, I_CmsFormatterBean> m_activeFormattersByContainerType = ArrayListMultimap.create();
    private CmsObject m_cms;
    private CmsADEConfigData m_config;
    private I_CmsResourceType m_type;
    private CmsJspStandardContextBean m_context;

    public CmsResourceTypeInfoWrapper(CmsJspStandardContextBean context, CmsObject cms, CmsADEConfigData config, I_CmsResourceType type) {
        this.m_cms = cms;
        this.m_config = config;
        this.m_type = type;
        this.m_context = context;
        for (I_CmsFormatterBean formatter : config.getActiveFormatters().values()) {
            if (!formatter.getResourceTypeNames().contains(type.getTypeName())) continue;
            this.m_activeFormatters.add(formatter);
            for (String containerType : formatter.getContainerTypes()) {
                this.m_activeFormattersByContainerType.put((Object)containerType, (Object)formatter);
            }
        }
        this.m_active = this.m_config.getResourceTypes().stream().anyMatch(sitemapConfigType -> this.m_type.getTypeName().equals(sitemapConfigType.getTypeName()));
    }

    @Override
    public String description(Locale locale) {
        try {
            return CmsWorkplaceMessages.getResourceTypeDescription(locale, this.m_type.getTypeName());
        }
        catch (Throwable e) {
            return this.m_type.getTypeName();
        }
    }

    public List<CmsFormatterInfoWrapper> formatterInfoForContainer(String containerType) {
        return this.m_context.wrapFormatters(this.m_activeFormattersByContainerType.get((Object)containerType));
    }

    @Override
    public String getDescription() {
        return this.description(this.m_cms.getRequestContext().getLocale());
    }

    @Override
    public String getDescriptionKey() {
        CmsExplorerTypeSettings explorerType = OpenCms.getWorkplaceManager().getExplorerTypeSetting(this.m_type.getTypeName());
        return explorerType.getInfo();
    }

    @Override
    public String getDescriptionRaw() {
        return this.getDescriptionKey();
    }

    public Set<String> getFormatterContainerTypes() {
        return Collections.unmodifiableSet(this.m_activeFormattersByContainerType.keySet());
    }

    public List<CmsFormatterInfoWrapper> getFormatterInfo() {
        return this.m_context.wrapFormatters(this.m_activeFormatters);
    }

    @Override
    public boolean getIsActive() {
        return this.m_active;
    }

    @Override
    public boolean getIsFormatter() {
        return false;
    }

    @Override
    public boolean getIsFunction() {
        return false;
    }

    @Override
    public boolean getIsResourceType() {
        return true;
    }

    @Override
    public String getName() {
        return this.m_type.getTypeName();
    }

    @Override
    public String getNiceName() {
        return this.niceName(this.m_cms.getRequestContext().getLocale());
    }

    @Override
    public String getNiceNameKey() {
        CmsExplorerTypeSettings explorerType = OpenCms.getWorkplaceManager().getExplorerTypeSetting(this.m_type.getTypeName());
        return explorerType.getKey();
    }

    @Override
    public String getNiceNameRaw() {
        return this.getNiceNameKey();
    }

    @Override
    public String niceName(Locale locale) {
        try {
            return CmsWorkplaceMessages.getResourceTypeName(locale, this.m_type.getTypeName());
        }
        catch (Throwable e) {
            return this.m_type.getTypeName();
        }
    }
}

