/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.letsencrypt;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.malkusch.whoisServerList.publicSuffixList.PublicSuffixList;
import de.malkusch.whoisServerList.publicSuffixList.PublicSuffixListFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONObject;
import org.opencms.letsencrypt.CmsLetsEncryptConfiguration;
import org.opencms.letsencrypt.CmsLetsEncryptUpdater;
import org.opencms.letsencrypt.I_CmsLetsEncryptUpdater;
import org.opencms.main.CmsLog;
import org.opencms.report.I_CmsReport;
import org.opencms.site.CmsSSLMode;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteManagerImpl;
import org.opencms.site.CmsSiteMatcher;
import org.opencms.ui.apps.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsSiteConfigToLetsEncryptConfigConverter {
    static final Log LOG = CmsLog.getLog(CmsSiteConfigToLetsEncryptConfigConverter.class);
    public static final boolean GROUPING_DISABLED = true;
    private static Object LOCK = new Object();
    private static SuffixListCache SUFFIX_LIST_CACHE = new SuffixListCache();
    private CmsLetsEncryptConfiguration m_config;
    private I_CmsLetsEncryptUpdater m_configUpdater;

    public CmsSiteConfigToLetsEncryptConfigConverter(CmsLetsEncryptConfiguration config) {
        this.m_config = config;
        this.m_configUpdater = new CmsLetsEncryptUpdater(config);
    }

    private static SiteDomainInfo getDomainInfo(CmsSite site) {
        ArrayList urls = Lists.newArrayList();
        for (CmsSiteMatcher matcher : site.getAllMatchers()) {
            urls.add(matcher.getUrl());
        }
        return CmsSiteConfigToLetsEncryptConfigConverter.getDomainInfo(urls);
    }

    private static SiteDomainInfo getDomainInfo(Collection<String> uris) {
        HashSet rootDomains = Sets.newHashSet();
        HashSet domains = Sets.newHashSet();
        boolean invalidPort = false;
        for (String uriStr : uris) {
            try {
                String rootDomain;
                URI uri = new URI(uriStr);
                int port = uri.getPort();
                if (port != 80 && port != 443 && port != -1) {
                    invalidPort = true;
                }
                if ((rootDomain = CmsSiteConfigToLetsEncryptConfigConverter.getDomainRoot(uri)) == null) {
                    LOG.warn((Object)("Host is not under public suffix, skipping it: " + uri));
                    continue;
                }
                domains.add(uri.getHost());
                rootDomains.add(rootDomain);
            }
            catch (URISyntaxException e) {
                LOG.warn((Object)("getDomainInfo: invalid URI " + uriStr), (Throwable)e);
            }
        }
        String rootDomain = rootDomains.size() == 1 ? (String)rootDomains.iterator().next() : null;
        return new SiteDomainInfo(domains, rootDomain, invalidPort);
    }

    private static String getDomainRoot(URI uri) {
        String host = uri.getHost();
        return SUFFIX_LIST_CACHE.getPublicSuffixList().getRegistrableDomain(host);
    }

    private static Set<String> getDomains(Collection<SiteDomainInfo> infos) {
        HashSet domains = Sets.newHashSet();
        for (SiteDomainInfo info : infos) {
            for (String domain : info.getDomains()) {
                domains.add(domain);
            }
        }
        return domains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(I_CmsReport report, CmsSiteManagerImpl siteManager) {
        Object object = LOCK;
        synchronized (object) {
            IdentityHashMap<CmsSite, CmsSite> siteIdMap = new IdentityHashMap<CmsSite, CmsSite>();
            for (CmsSite site : siteManager.getSites().values()) {
                if (site.getSSLMode() != CmsSSLMode.LETS_ENCRYPT) continue;
                siteIdMap.put(site, site);
            }
            ArrayList sites = Lists.newArrayList(siteIdMap.values());
            List<String> workplaceServers = siteManager.getWorkplaceServers(CmsSSLMode.LETS_ENCRYPT);
            return this.run(report, sites, workplaceServers);
        }
    }

    private DomainGrouping computeDomainGrouping(Collection<CmsSite> sites, Collection<String> workplaceUrls) {
        DomainGrouping result = new DomainGrouping();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Computing domain grouping for sites...");
            ArrayList servers = Lists.newArrayList();
            for (CmsSite site : sites) {
                servers.add(site.getUrl());
            }
            LOG.info((Object)("SITES = " + CmsStringUtil.listAsString(servers, ", ")));
        }
        CmsLetsEncryptConfiguration.Mode mode = this.m_config.getMode();
        boolean addWp = false;
        boolean addSites = false;
        if (mode == CmsLetsEncryptConfiguration.Mode.all || mode == CmsLetsEncryptConfiguration.Mode.sites) {
            addSites = true;
        }
        if (mode == CmsLetsEncryptConfiguration.Mode.all || mode == CmsLetsEncryptConfiguration.Mode.workplace) {
            addWp = true;
        }
        if (addWp) {
            HashSet workplaceDomains = Sets.newHashSet();
            for (String string : workplaceUrls) {
                try {
                    URI uri = new URI(string);
                    workplaceDomains.add(uri.getHost());
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            result.addDomainSet(workplaceDomains);
        }
        if (addSites) {
            Set<String> domains;
            ArrayListMultimap infosByRootDomain = ArrayListMultimap.create();
            ArrayList ungroupedSites = Lists.newArrayList();
            for (CmsSite site : sites) {
                SiteDomainInfo info = CmsSiteConfigToLetsEncryptConfigConverter.getDomainInfo(site);
                if (info.hasInvalidPort()) {
                    LOG.warn((Object)("Invalid port occuring in site definition: " + site));
                    continue;
                }
                String root = info.getCommonRootDomain();
                if (root != null) {
                    // empty if block
                }
                ungroupedSites.add(info);
            }
            ArrayList arrayList = Lists.newArrayList();
            for (String key : infosByRootDomain.keySet()) {
                Collection siteInfos = infosByRootDomain.get((Object)key);
                Set<String> domains2 = CmsSiteConfigToLetsEncryptConfigConverter.getDomains(siteInfos);
                if (domains2.size() <= 100) continue;
                LOG.info((Object)("Too many domains for root domain " + key + ", splitting them up by site instead."));
                arrayList.add(key);
                for (SiteDomainInfo info : siteInfos) {
                    ungroupedSites.add(info);
                }
            }
            for (String key : arrayList) {
                infosByRootDomain.removeAll((Object)key);
            }
            for (SiteDomainInfo ungroupedSite : ungroupedSites) {
                domains = CmsSiteConfigToLetsEncryptConfigConverter.getDomains(Collections.singletonList(ungroupedSite));
                result.addDomainSet(domains);
                LOG.info((Object)("DOMAINS (site config): " + domains));
            }
            for (String key : infosByRootDomain.keySet()) {
                domains = CmsSiteConfigToLetsEncryptConfigConverter.getDomains(infosByRootDomain.get((Object)key));
                result.addDomainSet(domains);
                LOG.info((Object)("DOMAINS (" + key + ")" + domains));
            }
        }
        return result;
    }

    private boolean run(I_CmsReport report, Collection<CmsSite> sites, Collection<String> workplaceUrls) {
        try {
            DomainGrouping domainGrouping = this.computeDomainGrouping(sites, workplaceUrls);
            if (domainGrouping.isEmpty()) {
                report.println(Messages.get().container("RPT_LETSENCRYPT_NO_DOMAINS_0"));
                return false;
            }
            String certConfig = domainGrouping.generateCertJson();
            if (!this.m_configUpdater.update(certConfig)) {
                report.println(Messages.get().container("RPT_LETSENCRYPT_UPDATE_FAILED_0"), 1);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            report.println(e);
            return false;
        }
    }

    public static class SiteDomainInfo {
        private String m_commonRootDomain;
        private Set<String> m_domains = Sets.newHashSet();
        private boolean m_invalidPort;

        public SiteDomainInfo(Set<String> domains, String commonRootDomain, boolean invalidPort) {
            this.m_domains = domains;
            this.m_commonRootDomain = commonRootDomain;
            this.m_invalidPort = invalidPort;
        }

        public String getCommonRootDomain() {
            return this.m_commonRootDomain;
        }

        public Set<String> getDomains() {
            return this.m_domains;
        }

        public boolean hasInvalidPort() {
            return this.m_invalidPort;
        }
    }

    static class SuffixListCache {
        private PublicSuffixList m_suffixList;
        private long m_timestamp = -1L;

        SuffixListCache() {
        }

        public synchronized PublicSuffixList getPublicSuffixList() {
            long now = System.currentTimeMillis();
            if (this.m_suffixList == null || now - this.m_timestamp > 3600000L) {
                PublicSuffixListFactory factory = new PublicSuffixListFactory();
                try (InputStream stream = CmsSiteConfigToLetsEncryptConfigConverter.class.getResourceAsStream("public_suffix_list.dat");){
                    this.m_suffixList = factory.build(stream);
                    this.m_timestamp = now;
                }
                catch (IOException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return this.m_suffixList;
        }
    }

    public static class DomainGrouping {
        private List<Set<String>> m_domainGroups = Lists.newArrayList();

        public void addDomainSet(Set<String> domains) {
            if (!domains.isEmpty()) {
                this.m_domainGroups.add(domains);
            }
        }

        public String generateCertJson() {
            try {
                JSONObject result = new JSONObject();
                for (Set<String> domainGroup : this.m_domainGroups) {
                    String key = this.computeName(domainGroup);
                    if (key == null) continue;
                    result.put(key, new JSONArray(domainGroup));
                }
                return result.toString();
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }

        public Set<String> getUnresolvableDomains() {
            HashSet result = Sets.newHashSet();
            for (Set<String> domainGroup : this.m_domainGroups) {
                for (String domain : domainGroup) {
                    try {
                        InetAddress.getByName(domain);
                    }
                    catch (UnknownHostException e) {
                        result.add(domain);
                    }
                    catch (SecurityException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            return result;
        }

        public boolean isEmpty() {
            return this.m_domainGroups.isEmpty();
        }

        private String computeName(Set<String> domains) {
            try {
                ArrayList domainList = Lists.newArrayList(domains);
                Collections.sort(domainList);
                String prefix = (String)domainList.get(0);
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                for (String domain : domainList) {
                    md5.update(domain.getBytes("UTF-8"));
                    md5.update((byte)10);
                }
                return prefix + "-" + new String(Hex.encodeHex((byte[])md5.digest()));
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
        }
    }
}

