/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.galleries.CmsPreviewService;
import org.opencms.cache.CmsVfsNameBasedDiskCache;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.loader.CmsDumpLoader;
import org.opencms.loader.CmsImageScaler;
import org.opencms.loader.Messages;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.scheduler.jobs.CmsImageCacheCleanupJob;
import org.opencms.util.CmsStringUtil;

public class CmsImageLoader
extends CmsDumpLoader
implements I_CmsEventListener {
    public static final String CONFIGURATION_DOWNSCALE = "image.scaling.downscale";
    public static final String CONFIGURATION_IMAGE_FOLDER = "image.folder";
    public static final String CONFIGURATION_MAX_BLUR_SIZE = "image.scaling.maxblursize";
    public static final String CONFIGURATION_MAX_SCALE_SIZE = "image.scaling.maxsize";
    public static final String CONFIGURATION_SCALING_ENABLED = "image.scaling.enabled";
    public static final String IMAGE_REPOSITORY_DEFAULT = "/WEB-INF/imagecache/";
    public static final String PARAM_CLEAR_IMAGES_CACHE = "_IMAGES_CACHE_";
    public static final int RESOURCE_LOADER_ID_IMAGE_LOADER = 2;
    protected static final Log LOG = CmsLog.getLog(CmsImageLoader.class);
    protected static String m_downScaleParams;
    protected static boolean m_enabled;
    protected static int m_maxBlurSize;
    protected static CmsVfsNameBasedDiskCache m_vfsDiskCache;
    protected String m_imageRepositoryFolder;
    protected int m_maxScaleSize = 2500;

    public static String getDownScaleParams() {
        return m_downScaleParams;
    }

    public static String getImageRepositoryPath() {
        return m_vfsDiskCache.getRepositoryPath();
    }

    public static int getMaxBlurSize() {
        return m_maxBlurSize;
    }

    public static boolean isEnabled() {
        return m_enabled;
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        if (CmsStringUtil.isNotEmpty(paramName) && CmsStringUtil.isNotEmpty(paramValue)) {
            if (CONFIGURATION_SCALING_ENABLED.equals(paramName)) {
                m_enabled = Boolean.valueOf(paramValue);
            }
            if (CONFIGURATION_IMAGE_FOLDER.equals(paramName)) {
                this.m_imageRepositoryFolder = paramValue.trim();
            }
            if (CONFIGURATION_MAX_SCALE_SIZE.equals(paramName)) {
                this.m_maxScaleSize = CmsStringUtil.getIntValue(paramValue, 2500, paramName);
            }
            if (CONFIGURATION_MAX_BLUR_SIZE.equals(paramName)) {
                m_maxBlurSize = CmsStringUtil.getIntValue(paramValue, 6250000, paramName);
            }
            if (CONFIGURATION_DOWNSCALE.equals(paramName)) {
                m_downScaleParams = paramValue.trim();
            }
        }
        super.addConfigurationParameter(paramName, paramValue);
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        if (event == null) {
            return;
        }
        int type = event.getType();
        if (type != 5) {
            return;
        }
        Map<String, Object> data = event.getData();
        if (data == null) {
            return;
        }
        Object param = data.get(PARAM_CLEAR_IMAGES_CACHE);
        if (param == null) {
            return;
        }
        float age = -1.0f;
        if (param instanceof String) {
            age = Float.valueOf((String)param).floatValue();
        } else if (param instanceof Number) {
            age = ((Number)param).floatValue();
        }
        CmsImageCacheCleanupJob.cleanImageCache(age);
    }

    @Override
    public void destroy() {
        m_enabled = false;
        this.m_imageRepositoryFolder = null;
        m_vfsDiskCache = null;
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        CmsParameterConfiguration result = new CmsParameterConfiguration();
        CmsParameterConfiguration config = super.getConfiguration();
        if (config != null) {
            result.putAll(config);
        }
        result.put(CONFIGURATION_SCALING_ENABLED, String.valueOf(m_enabled));
        result.put(CONFIGURATION_IMAGE_FOLDER, this.m_imageRepositoryFolder);
        return result;
    }

    @Override
    public int getLoaderId() {
        return 2;
    }

    protected CmsFile getScaledImage(CmsObject cms, CmsResource resource, CmsImageScaler scaler) throws IOException, CmsException {
        CmsFile file;
        String cacheParam = scaler.isValid() ? scaler.toString() : null;
        String cacheName = m_vfsDiskCache.getCacheName(resource, cacheParam);
        byte[] content = m_vfsDiskCache.getCacheContent(cacheName);
        if (content != null) {
            file = resource instanceof CmsFile ? (CmsFile)resource : new CmsFile(resource);
            file.setContents(content);
        } else {
            file = cms.readFile(resource);
            if (scaler.isValid()) {
                if (scaler.getType() == 8) {
                    scaler.setFocalPoint(CmsPreviewService.readFocalPoint(cms, resource));
                }
                content = scaler.scaleImage(file);
                file.setContents(content);
            }
            m_vfsDiskCache.saveCacheFile(cacheName, file.getContents());
        }
        return file;
    }

    @Override
    public void initConfiguration() {
        if (CmsStringUtil.isEmpty(this.m_imageRepositoryFolder)) {
            this.m_imageRepositoryFolder = IMAGE_REPOSITORY_DEFAULT;
        }
        if (m_vfsDiskCache == null) {
            m_vfsDiskCache = new CmsVfsNameBasedDiskCache(OpenCms.getSystemInfo().getWebApplicationRfsPath(), this.m_imageRepositoryFolder);
        }
        OpenCms.addCmsEventListener(this);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_IMAGE_REPOSITORY_PATH_1", m_vfsDiskCache.getRepositoryPath()));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_IMAGE_SCALING_ENABLED_1", (Object)m_enabled));
        }
    }

    @Override
    public void load(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws IOException, CmsException {
        if (m_enabled) {
            if (this.canSendLastModifiedHeader(resource, req, res)) {
                return;
            }
            CmsImageScaler scaler = new CmsImageScaler(req, this.m_maxScaleSize, m_maxBlurSize);
            CmsFile file = this.getScaledImage(cms, resource, scaler);
            super.load(cms, file, req, res);
        } else {
            super.load(cms, resource, req, res);
        }
    }

    static {
        m_maxBlurSize = 6250000;
    }
}

