/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import org.opencms.file.CmsResource;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.CmsTemplateContext;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.loader.Messages;

public class CmsTemplateLoaderFacade {
    private CmsTemplateContext m_context;
    private I_CmsResourceLoader m_loader;
    private CmsResource m_resource;
    private CmsResource m_template;
    private String m_templateName = "";

    public CmsTemplateLoaderFacade(I_CmsResourceLoader loader, CmsResource resource, CmsResource template) throws CmsLoaderException {
        if (!loader.isUsableForTemplates()) {
            throw new CmsLoaderException(Messages.get().container("ERR_LOADER_NOT_TEMPLATE_ENABLED_0"));
        }
        this.m_loader = loader;
        this.m_resource = resource;
        this.m_template = template;
    }

    public I_CmsResourceLoader getLoader() {
        return this.m_loader;
    }

    public CmsResource getLoaderStartResource() {
        if (this.m_loader.isUsingUriWhenLoadingTemplate()) {
            return this.m_resource;
        }
        return this.m_template;
    }

    public CmsResource getResource() {
        return this.m_resource;
    }

    public CmsResource getTemplate() {
        return this.m_template;
    }

    public CmsTemplateContext getTemplateContext() {
        return this.m_context;
    }

    public String getTemplateName() {
        return this.m_templateName;
    }

    public void setTemplateContext(CmsTemplateContext context) {
        this.m_context = context;
    }

    public void setTemplateName(String templateName) {
        this.m_templateName = templateName;
    }
}

