/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.lock;

import org.opencms.util.A_CmsModeIntEnumeration;

public final class CmsLockType
extends A_CmsModeIntEnumeration {
    public static final CmsLockType EXCLUSIVE = new CmsLockType(4);
    public static final CmsLockType INHERITED = new CmsLockType(3);
    public static final CmsLockType PUBLISH = new CmsLockType(7);
    public static final CmsLockType SHALLOW = new CmsLockType(9);
    public static final CmsLockType SHARED_EXCLUSIVE = new CmsLockType(2);
    public static final CmsLockType SHARED_INHERITED = new CmsLockType(1);
    public static final CmsLockType TEMPORARY = new CmsLockType(6);
    public static final CmsLockType UNLOCKED = new CmsLockType(0);
    protected static final CmsLockType SYSTEM_UNLOCKED = new CmsLockType(8);
    private static final long serialVersionUID = 5333767594124738789L;

    private CmsLockType(int type) {
        super(type);
    }

    public static CmsLockType valueOf(int type) {
        switch (type) {
            case 1: {
                return SHARED_INHERITED;
            }
            case 2: {
                return SHARED_EXCLUSIVE;
            }
            case 3: {
                return INHERITED;
            }
            case 4: {
                return EXCLUSIVE;
            }
            case 6: {
                return TEMPORARY;
            }
            case 7: {
                return PUBLISH;
            }
            case 8: {
                return SYSTEM_UNLOCKED;
            }
        }
        return UNLOCKED;
    }

    public boolean isDirectlyInherited() {
        return this == INHERITED;
    }

    public boolean isExclusive() {
        return this == EXCLUSIVE || this == TEMPORARY || this == SHALLOW;
    }

    public boolean isInherited() {
        return this.isDirectlyInherited() || this.isSharedInherited();
    }

    public boolean isPersistent() {
        return this == EXCLUSIVE || this.isPublish();
    }

    public boolean isPublish() {
        return this == PUBLISH;
    }

    public boolean isShallow() {
        return this == SHALLOW;
    }

    public boolean isShared() {
        return this.isSharedExclusive() || this.isSharedInherited();
    }

    public boolean isSharedExclusive() {
        return this == SHARED_EXCLUSIVE;
    }

    public boolean isSharedInherited() {
        return this == SHARED_INHERITED;
    }

    public boolean isSystem() {
        return this.isPublish() || this == SYSTEM_UNLOCKED;
    }

    public boolean isTemporary() {
        return this == TEMPORARY || this == SHALLOW;
    }

    public boolean isUnlocked() {
        return this == UNLOCKED || this == SYSTEM_UNLOCKED;
    }

    @Override
    public String toString() {
        switch (this.getMode()) {
            case 1: {
                return "shared inherited";
            }
            case 2: {
                return "shared exclusive";
            }
            case 3: {
                return "inherited";
            }
            case 4: {
                return "exclusive";
            }
            case 6: {
                return "temporary exclusive";
            }
            case 7: {
                return "publish";
            }
            case 8: {
                return "system unlocked";
            }
            case 9: {
                return "shallow";
            }
        }
        return "unlocked";
    }
}

