/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.mail;

public class CmsMailHost
implements Comparable<CmsMailHost> {
    private String m_hostname;
    private Integer m_order;
    private String m_password;
    private int m_port;
    private String m_protocol;
    private String m_username;
    private String m_security;
    private String m_id;
    private String m_mailfrom;

    public CmsMailHost(String hostname, Integer port, Integer order, String protocol, String security, String username, String password) {
        this(hostname, port, order, protocol, security, username, password, null, null);
    }

    public CmsMailHost(String hostname, Integer port, Integer order, String protocol, String security, String username, String password, String id, String mailfrom) {
        this.m_hostname = hostname;
        int portInt = port;
        this.m_port = portInt < 0 ? 25 : portInt;
        this.m_protocol = protocol != null ? protocol : "smtp";
        this.m_username = username;
        this.m_password = password;
        this.m_security = security;
        this.m_order = order;
        this.m_id = id;
        this.m_mailfrom = mailfrom;
    }

    @Override
    public int compareTo(CmsMailHost obj) {
        if (obj == this) {
            return 0;
        }
        return this.m_order.compareTo(obj.m_order);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsMailHost) {
            CmsMailHost other = (CmsMailHost)obj;
            return this.m_hostname.equals(other.m_hostname) && this.m_protocol.equals(other.m_protocol) && this.m_username.equals(other.m_username);
        }
        return false;
    }

    public String getHostname() {
        return this.m_hostname;
    }

    public String getId() {
        return this.m_id;
    }

    public String getMailfrom() {
        return this.m_mailfrom;
    }

    public Integer getOrder() {
        return this.m_order;
    }

    public String getPassword() {
        return this.m_password;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public String getSecurity() {
        return this.m_security;
    }

    public String getUsername() {
        return this.m_username;
    }

    public int hashCode() {
        return this.m_hostname.hashCode() * 1117 + this.m_protocol.hashCode() * 2003 + this.m_username.hashCode();
    }

    public boolean isAuthenticating() {
        return this.m_username != null && this.m_password != null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append(this.getClass().getName());
        buf.append(" hostname=");
        buf.append(this.getHostname());
        buf.append(" port=");
        buf.append(this.getPort());
        buf.append(" order=");
        buf.append(this.m_order);
        buf.append(" protocol=");
        buf.append(this.getProtocol());
        buf.append(" security=" + this.getSecurity());
        if (this.isAuthenticating()) {
            buf.append(" user=");
            buf.append(this.getUsername());
            buf.append(" password=");
            buf.append(this.getPassword());
        }
        buf.append(" id=");
        buf.append(this.getId());
        buf.append(" mailfrom=");
        buf.append(this.getMailfrom());
        return buf.toString();
    }
}

