/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsSitesConfiguration;
import org.opencms.configuration.CmsVariablesConfiguration;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsLoginManager;
import org.opencms.db.CmsLoginMessage;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessages;
import org.opencms.importexport.CmsExportParameters;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.CmsVfsImportExportHandler;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsBroadcast;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsShell;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.I_CmsShellCommands;
import org.opencms.main.Messages;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleImportExportHandler;
import org.opencms.module.CmsModuleManager;
import org.opencms.report.CmsLogReport;
import org.opencms.report.CmsMultiplexReport;
import org.opencms.report.CmsPrintStreamReport;
import org.opencms.report.CmsShellLogReport;
import org.opencms.report.CmsShellReport;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.I_CmsSearchIndex;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsAccessControlList;
import org.opencms.security.CmsOrgUnitManager;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.site.CmsSite;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.ui.apps.search.CmsSearchReplaceSettings;
import org.opencms.ui.apps.search.CmsSearchReplaceThread;
import org.opencms.ui.apps.search.CmsSourceSearchForm;
import org.opencms.ui.favorites.CmsFavoriteDAO;
import org.opencms.ui.favorites.CmsFavoriteEntry;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlFileTransformer;
import org.opencms.xml.content.CmsXmlContent;

class CmsShellCommands
implements I_CmsShellCommands {
    private static final Log LOG = CmsLog.getLog(CmsShellCommands.class);
    private CmsObject m_cms;
    private CmsShell m_shell;

    protected CmsShellCommands() {
    }

    public void addBookmark(String user, String siteRoot, String sitePath, String project) throws Exception {
        CmsObject cms = OpenCms.initCmsObject(this.m_cms);
        if (project != null) {
            cms.getRequestContext().setCurrentProject(cms.readProject(project));
        }
        cms.getRequestContext().setSiteRoot(siteRoot);
        CmsFavoriteDAO favDao = new CmsFavoriteDAO(cms, user);
        List<CmsFavoriteEntry> entries = favDao.loadFavorites();
        CmsResource res = cms.readResource(sitePath);
        CmsFavoriteEntry entry = new CmsFavoriteEntry();
        CmsProject currProject = cms.getRequestContext().getCurrentProject();
        if (res.isFolder()) {
            entry.setType(CmsFavoriteEntry.Type.explorerFolder);
            entry.setStructureId(res.getStructureId());
            entry.setProjectId(currProject.getId());
            entry.setSiteRoot(siteRoot);
        } else {
            if (currProject.isOnlineProject()) {
                throw new IllegalArgumentException("Can not set bookmark for page in Online project.");
            }
            entry.setType(CmsFavoriteEntry.Type.page);
            entry.setStructureId(res.getStructureId());
            entry.setProjectId(currProject.getId());
            entry.setSiteRoot(siteRoot);
        }
        entries.add(entry);
        favDao.saveFavorites(entries);
    }

    public void addResourceToOU(String ouFqn, String resource) throws Exception {
        CmsObject cms = this.m_cms;
        CmsOrgUnitManager ouManager = OpenCms.getOrgUnitManager();
        ouManager.addResourceToOrgUnit(cms, ouFqn, resource);
    }

    public void addUserToRole(String user, String role) throws CmsException {
        OpenCms.getRoleManager().addUserToRole(this.m_cms, CmsRole.valueOfRoleName(role), user);
    }

    public void cd(String target) throws Exception {
        String resolvedTarget;
        CmsResource res;
        String folder = CmsResource.getFolderPath(this.m_cms.getRequestContext().getUri());
        if (!((String)target).endsWith("/")) {
            target = (String)target + "/";
        }
        if (!(res = this.m_cms.readResource(resolvedTarget = CmsLinkManager.getAbsoluteUri((String)target, folder))).isFolder()) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_NOT_A_FOLDER_1", resolvedTarget));
        }
        this.m_cms.getRequestContext().setUri(resolvedTarget);
        this.m_shell.getOut().println("\n" + this.getMessages().key("GUI_SHELL_CURRENT_FOLDER_1", new Object[]{resolvedTarget}));
        this.m_shell.getOut().println();
    }

    public void chacc(String resourceName, String principalType, String principalName, String permissionString) throws CmsException {
        this.m_cms.lockResource(resourceName);
        principalName = "GROUP".equalsIgnoreCase(principalType.trim()) ? OpenCms.getImportExportManager().translateGroup(principalName) : OpenCms.getImportExportManager().translateUser(principalName);
        this.m_cms.chacc(resourceName, principalType, principalName, permissionString);
    }

    public void changeUserSettingsStartParameters(String username, String startProject, String startSite, String startFolder, String startView) throws CmsException {
        CmsUser user = this.m_cms.readUser(username);
        CmsUserSettings settings = new CmsUserSettings(user);
        settings.setStartProject(startProject);
        settings.setStartSite(startSite);
        settings.setStartFolder(startFolder);
        settings.setStartView(startView);
        settings.save(this.m_cms);
    }

    public void clearCaches() throws Exception {
        OpenCms.fireCmsEvent(new CmsEvent(5, new HashMap<String, Object>()));
    }

    public void clearLoginMessage() throws CmsRoleViolationException {
        OpenCms.getLoginManager().setLoginMessage(this.m_cms, null);
        OpenCms.writeConfiguration(CmsVariablesConfiguration.class);
    }

    public void copyright() {
        String[] copy = Messages.COPYRIGHT_BY_ALKACON;
        for (int i = 0; i < copy.length; ++i) {
            this.m_shell.getOut().println(copy[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultProject(String name, String description) throws Exception {
        String storedSiteRoot = this.m_cms.getRequestContext().getSiteRoot();
        try {
            this.m_cms.getRequestContext().setSiteRoot("/");
            CmsProject project = this.m_cms.createProject(name, description, OpenCms.getDefaultUsers().getGroupUsers(), OpenCms.getDefaultUsers().getGroupUsers(), CmsProject.PROJECT_TYPE_NORMAL);
            this.m_cms.getRequestContext().setCurrentProject(project);
            this.m_cms.copyResourceToProject("/");
        }
        finally {
            this.m_cms.getRequestContext().setSiteRoot(storedSiteRoot);
        }
        if (OpenCms.getRoleManager().hasRole(this.m_cms, CmsRole.WORKPLACE_MANAGER)) {
            OpenCms.getSearchManager().initialize(this.m_cms);
        }
    }

    public CmsResource createFolder(String targetFolder, String folderName) throws Exception {
        if (this.m_cms.existsResource(targetFolder + folderName)) {
            this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_FOLDER_ALREADY_EXISTS_1", targetFolder + folderName));
            return null;
        }
        return this.m_cms.createResource(targetFolder + folderName, CmsResourceTypeFolder.getStaticTypeId());
    }

    public CmsGroup createGroup(String name, String description) throws Exception {
        return this.m_cms.createGroup(name, description, 0, null);
    }

    public CmsOrganizationalUnit createOU(String ouFqn, String description, boolean hideLogin, String resource) throws Exception {
        return OpenCms.getOrgUnitManager().createOrganizationalUnit(this.m_cms, ouFqn, description, hideLogin ? 1 : 0, resource);
    }

    public CmsPropertyDefinition createPropertydefinition(String name) throws Exception {
        return this.m_cms.createPropertyDefinition(name);
    }

    public CmsUser createUser(String name, String password, String description) throws Exception {
        if (this.existsUser(name)) {
            this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_USER_ALREADY_EXISTS_1", name));
            return null;
        }
        return this.m_cms.createUser(name, password, description, new Hashtable<String, Object>());
    }

    public CmsUser createUser(String name, String password, String description, String firstname, String lastname, String email) throws Exception {
        if (this.existsUser(name)) {
            this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_USER_ALREADY_EXISTS_1", name));
            return null;
        }
        CmsUser user = this.m_cms.createUser(name, password, description, new Hashtable<String, Object>());
        user.setEmail(email);
        user.setFirstname(firstname);
        user.setLastname(lastname);
        this.m_cms.writeUser(user);
        return user;
    }

    public CmsOrganizationalUnit createWebOU(String ouFqn, String description, boolean hideLogin) {
        try {
            return OpenCms.getOrgUnitManager().createOrganizationalUnit(this.m_cms, ouFqn, description, (hideLogin ? 1 : 0) | 8, null);
        }
        catch (CmsException e) {
            this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_WEB_OU_CREATION_FAILED_2", ouFqn, description));
            return null;
        }
    }

    public void deleteHistoricalVersions(int versionsToKeep, int versionsDeleted, long timeDeleted) throws Exception {
        this.m_cms.deleteHistoricalVersions(versionsToKeep, versionsDeleted, timeDeleted, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void deleteModule(String moduleName) throws Exception {
        OpenCms.getModuleManager().deleteModule(this.m_cms, moduleName, false, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void deleteProject(String name) throws Exception {
        this.m_cms.deleteProject(this.m_cms.readProject(name).getUuid());
    }

    public void deletepropertydefinition(String name) throws Exception {
        this.m_cms.deletePropertyDefinition(name);
    }

    public void deleteResource(String name) throws Exception {
        this.m_cms.lockResource(name);
        this.m_cms.deleteResource(name, CmsResource.DELETE_PRESERVE_SIBLINGS);
    }

    public void deleteResourceWithSiblings(String name) throws Exception {
        this.m_cms.lockResource(name);
        this.m_cms.deleteResource(name, CmsResource.DELETE_REMOVE_SIBLINGS);
    }

    public void disableModuleUpdates() {
        OpenCms.getModuleManager().setModuleUpdateEnabled(false);
    }

    public void echo(String echo) {
        if (echo == null) {
            return;
        }
        boolean b = "on".equalsIgnoreCase(echo.trim());
        this.m_shell.setEcho(b);
        if (b) {
            this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_ECHO_ON_0"));
        } else {
            this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_ECHO_OFF_0"));
        }
    }

    public void exit() {
        this.m_shell.exit();
    }

    public void exportAllResources(String exportFile) throws Exception {
        this.exportAllResources(exportFile, false);
    }

    public void exportAllResources(String exportFile, boolean isReducedExportMode) throws Exception {
        ArrayList<String> exportPaths = new ArrayList<String>(1);
        exportPaths.add("/");
        CmsVfsImportExportHandler vfsExportHandler = new CmsVfsImportExportHandler();
        CmsExportParameters params = new CmsExportParameters(exportFile, null, true, false, false, exportPaths, true, true, 0L, true, false, isReducedExportMode ? CmsModule.ExportMode.REDUCED : CmsModule.ExportMode.DEFAULT);
        vfsExportHandler.setExportParams(params);
        OpenCms.getImportExportManager().exportData(this.m_cms, vfsExportHandler, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void exportModule(String moduleName) throws Exception {
        CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
        if (module == null) {
            throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_UNKNOWN_MODULE_1", moduleName));
        }
        String filename = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(OpenCms.getSystemInfo().getPackagesRfsPath() + CmsSystemInfo.FOLDER_MODULES + moduleName + "_" + OpenCms.getModuleManager().getModule(moduleName).getVersion().toString());
        List<String> moduleResources = CmsModule.calculateModuleResourceNames(this.m_cms, module);
        String[] resources = new String[moduleResources.size()];
        System.arraycopy(moduleResources.toArray(), 0, resources, 0, resources.length);
        CmsModuleImportExportHandler moduleExportHandler = new CmsModuleImportExportHandler();
        moduleExportHandler.setFileName(filename);
        moduleExportHandler.setAdditionalResources(resources);
        moduleExportHandler.setModuleName(module.getName().replace('\\', '/'));
        moduleExportHandler.setDescription(this.getMessages().key("GUI_SHELL_IMPORTEXPORT_MODULE_HANDLER_NAME_1", new Object[]{moduleExportHandler.getModuleName()}));
        OpenCms.getImportExportManager().exportData(this.m_cms, moduleExportHandler, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void exportResources(String exportFile, String pathList) throws Exception {
        this.exportResources(exportFile, pathList, false);
    }

    public void exportResources(String exportFile, String pathList, boolean isReducedExportMode) throws Exception {
        this.exportResources(exportFile, pathList, isReducedExportMode, false);
    }

    public void exportResources(String exportFile, String pathList, boolean isReducedExportMode, boolean skipParentFolders) throws Exception {
        StringTokenizer tok = new StringTokenizer(pathList, ";");
        ArrayList<String> exportPaths = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            exportPaths.add(tok.nextToken());
        }
        boolean includeSystem = false;
        if (pathList.startsWith("/system/") || pathList.indexOf(";/system/") > -1) {
            includeSystem = true;
        }
        CmsVfsImportExportHandler vfsExportHandler = new CmsVfsImportExportHandler();
        CmsExportParameters params = new CmsExportParameters(exportFile, null, true, false, false, exportPaths, includeSystem, true, 0L, true, false, isReducedExportMode ? CmsModule.ExportMode.REDUCED : CmsModule.ExportMode.DEFAULT);
        params.setSkipParentFolders(skipParentFolders);
        vfsExportHandler.setExportParams(params);
        OpenCms.getImportExportManager().exportData(this.m_cms, vfsExportHandler, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void exportResourcesAndUserdata(String exportFile, String pathList) throws Exception {
        this.exportResourcesAndUserdata(exportFile, pathList, false);
    }

    public void exportResourcesAndUserdata(String exportFile, String pathList, boolean isReducedExportMode) throws Exception {
        this.exportResourcesAndUserdata(exportFile, pathList, isReducedExportMode, false);
    }

    public void exportResourcesAndUserdata(String exportFile, String pathList, boolean isReducedExportMode, boolean skipParentFolders) throws Exception {
        StringTokenizer tok = new StringTokenizer(pathList, ";");
        ArrayList<String> exportPaths = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            exportPaths.add(tok.nextToken());
        }
        boolean includeSystem = false;
        if (pathList.startsWith("/system/") || pathList.indexOf(";/system/") > -1) {
            includeSystem = true;
        }
        CmsVfsImportExportHandler vfsExportHandler = new CmsVfsImportExportHandler();
        CmsExportParameters params = new CmsExportParameters(exportFile, null, true, true, false, exportPaths, includeSystem, true, 0L, true, false, isReducedExportMode ? CmsModule.ExportMode.REDUCED : CmsModule.ExportMode.DEFAULT);
        params.setSkipParentFolders(skipParentFolders);
        vfsExportHandler.setExportParams(params);
        OpenCms.getImportExportManager().exportData(this.m_cms, vfsExportHandler, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void forceDeleteModule(String moduleName) throws Exception {
        OpenCms.getModuleManager().deleteModule(this.m_cms, moduleName, true, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void forcePasswordResetForUsers() throws Exception {
        CmsObject cms = this.m_cms;
        OpenCms.getRoleManager().checkRole(cms, CmsRole.ACCOUNT_MANAGER);
        CmsLoginManager loginManager = OpenCms.getLoginManager();
        String ou = "";
        List<CmsUser> users = OpenCms.getOrgUnitManager().getUsers(cms, ou, true);
        for (CmsUser user : users) {
            if (loginManager.isExcludedFromPasswordReset(cms, user)) {
                LOG.info((Object)("Excluded user " + user.getName() + " from password reset."));
                continue;
            }
            try {
                if (user.getAdditionalInfo("RESET_PASSWORD") != null) continue;
                LOG.info((Object)("Marking user " + user.getName() + " for password reset."));
                user.setAdditionalInfo("RESET_PASSWORD", "true");
                cms.writeUser(user);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void getAcl(String resourceName) throws Exception {
        CmsAccessControlList acList = this.m_cms.getAccessControlList(resourceName);
        Iterator<CmsUUID> principals = acList.getPrincipals().iterator();
        while (principals.hasNext()) {
            I_CmsPrincipal p = this.m_cms.lookupPrincipal(principals.next());
            this.m_shell.getOut().println(p.getName() + ": " + acList.getPermissions(p.getId()).getPermissionString());
        }
    }

    public void getLocales() {
        this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_LOCALES_AVAILABLE_0"));
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = locales.length - 1; i >= 0; --i) {
            this.m_shell.getOut().println("  \"" + locales[i].toString() + "\"");
        }
    }

    public void help() {
        this.m_shell.getOut().println();
        this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_HELP1_0"));
        this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_HELP2_0"));
        this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_HELP3_0"));
        this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_HELP4_0"));
        this.m_shell.getOut().println();
    }

    public void help(String command) {
        if ("*".equalsIgnoreCase(command)) {
            this.m_shell.help(null);
        } else if ("help".equalsIgnoreCase(command)) {
            this.help();
        } else {
            this.m_shell.help(command);
        }
    }

    public void importModule(String importFile) throws Exception {
        CmsImportParameters params = new CmsImportParameters(importFile, "/", true);
        OpenCms.getImportExportManager().importData(this.m_cms, new CmsShellReport(this.m_cms.getRequestContext().getLocale()), params);
    }

    public void importModuleFromDefault(String importFile) throws Exception {
        String exportPath = OpenCms.getSystemInfo().getPackagesRfsPath();
        String fileName = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(exportPath + CmsSystemInfo.FOLDER_MODULES + importFile);
        CmsImportParameters params = new CmsImportParameters(fileName, "/", true);
        OpenCms.getImportExportManager().importData(this.m_cms, new CmsShellReport(this.m_cms.getRequestContext().getLocale()), params);
    }

    public void importModulesFromSetupBean() {
    }

    public void importResources(String importFile, String importPath) throws Exception {
        CmsImportParameters params = new CmsImportParameters(OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(importFile), importPath, true);
        OpenCms.getImportExportManager().importData(this.m_cms, new CmsShellReport(this.m_cms.getRequestContext().getLocale()), params);
    }

    public void importResources(String importFile, String importPath, boolean keepPermissions) throws Exception {
        CmsImportParameters params = new CmsImportParameters(OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(importFile), importPath, keepPermissions);
        OpenCms.getImportExportManager().importData(this.m_cms, new CmsShellReport(this.m_cms.getRequestContext().getLocale()), params);
    }

    public void importResourcesWithTempProject(String importFile) throws Exception {
        CmsProject project = this.m_cms.createProject("SystemUpdate", this.getMessages().key("GUI_SHELL_IMPORT_TEMP_PROJECT_NAME_0"), OpenCms.getDefaultUsers().getGroupAdministrators(), OpenCms.getDefaultUsers().getGroupAdministrators(), CmsProject.PROJECT_TYPE_TEMPORARY);
        CmsUUID id = project.getUuid();
        this.m_cms.getRequestContext().setCurrentProject(project);
        this.m_cms.copyResourceToProject("/");
        CmsImportParameters params = new CmsImportParameters(importFile, "/", true);
        OpenCms.getImportExportManager().importData(this.m_cms, new CmsShellReport(this.m_cms.getRequestContext().getLocale()), params);
        this.m_cms.unlockProject(id);
        OpenCms.getPublishManager().publishProject(this.m_cms);
        OpenCms.getPublishManager().waitWhileRunning();
    }

    public void initAdeManager() {
        OpenCms.getADEManager();
    }

    @Override
    public void initShellCmsObject(CmsObject cms, CmsShell shell) {
        this.m_cms = cms;
        this.m_shell = shell;
    }

    public void listModules() throws Exception {
        Set<String> modules = OpenCms.getModuleManager().getModuleNames();
        this.m_shell.getOut().println("\n" + this.getMessages().key("GUI_SHELL_LIST_MODULES_1", modules.size()));
        for (String moduleName : modules) {
            this.m_shell.getOut().println(moduleName);
        }
        this.m_shell.getOut().println();
    }

    public void login(String username, String password) {
        username = OpenCms.getImportExportManager().translateUser(username);
        try {
            this.m_cms.loginUser(username, password);
            this.m_shell.initSettings();
            this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_LOGIN_1", this.whoami().getName()));
            CmsLoginMessage message = OpenCms.getLoginManager().getLoginMessage();
            if (message != null && message.isActive()) {
                this.m_shell.getOut().println(message.getMessage());
            }
        }
        catch (Exception exc) {
            this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_LOGIN_FAILED_0"));
        }
    }

    public void ls() throws Exception {
        String folder = CmsResource.getFolderPath(this.m_cms.getRequestContext().getUri());
        List<CmsResource> resources = this.m_cms.getResourcesInFolder(folder, CmsResourceFilter.IGNORE_EXPIRATION);
        this.m_shell.getOut().println("\n" + this.getMessages().key("GUI_SHELL_LS_2", folder, resources.size()));
        for (CmsResource r : resources) {
            this.m_shell.getOut().println(this.m_cms.getSitePath(r));
        }
        this.m_shell.getOut().println();
    }

    public void lsacc(String resourceName) throws Exception {
        List<CmsAccessControlEntry> acList = this.m_cms.getAccessControlEntries(resourceName);
        for (int i = 0; i < acList.size(); ++i) {
            CmsAccessControlEntry ace = acList.get(i);
            I_CmsPrincipal acePrincipal = this.m_cms.lookupPrincipal(ace.getPrincipal());
            String pName = acePrincipal != null ? acePrincipal.getName() : ace.getPrincipal().toString();
            this.m_shell.getOut().println(pName + ": " + ace.getPermissions().getPermissionString() + " " + ace);
        }
    }

    public void lsacc(String resourceName, String principalName) throws Exception {
        I_CmsPrincipal principal = this.m_cms.lookupPrincipal(principalName);
        List<CmsAccessControlEntry> acList = this.m_cms.getAccessControlEntries(resourceName);
        for (int i = 0; i < acList.size(); ++i) {
            CmsAccessControlEntry ace = acList.get(i);
            I_CmsPrincipal acePrincipal = this.m_cms.lookupPrincipal(ace.getPrincipal());
            if (!principal.equals(acePrincipal)) continue;
            String pName = acePrincipal != null ? acePrincipal.getName() : ace.getPrincipal().toString();
            this.m_shell.getOut().println(pName + ": " + ace.getPermissions().getPermissionString() + " " + ace);
        }
    }

    public void onError(String errorCode) {
        this.m_shell.m_errorCode = Integer.parseInt(errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perf() throws Exception {
        int maxTests = 50000;
        String storedSiteRoot = this.m_cms.getRequestContext().getSiteRoot();
        try {
            this.m_cms.getRequestContext().setSiteRoot("/");
            Random random = new Random();
            List<CmsResource> testResources = this.m_cms.readResources("/", CmsResourceFilter.ALL);
            int resourceCount = testResources.size();
            this.m_shell.getOut().println("#Resources:\t" + resourceCount);
            long totalTime = 0L;
            long minTime = Long.MAX_VALUE;
            long maxTime = Long.MIN_VALUE;
            this.m_shell.getOut().print("readFileHeader:\t");
            for (int i = maxTests; i > 0; --i) {
                int index = random.nextInt(resourceCount);
                CmsResource resource = testResources.get(index);
                long start = System.currentTimeMillis();
                this.m_cms.readResource(this.m_cms.getSitePath(resource), CmsResourceFilter.ALL);
                long time = System.currentTimeMillis() - start;
                totalTime += time;
                if (time < minTime) {
                    minTime = time;
                }
                if (time > maxTime) {
                    maxTime = time;
                }
                if (i % 100 != 0) continue;
                this.m_shell.getOut().print('.');
            }
            this.m_shell.getOut().println("\nreadFileHeader:\t" + minTime + "\t" + maxTime + "\t" + (float)totalTime / (float)maxTests + " ms");
        }
        finally {
            this.m_cms.getRequestContext().setSiteRoot(storedSiteRoot);
        }
    }

    public void prompt(String prompt) {
        this.m_shell.setPrompt(prompt);
    }

    public void publishProjectAndWait() throws Exception {
        OpenCms.getPublishManager().publishProject(this.m_cms);
        OpenCms.getPublishManager().waitWhileRunning();
    }

    public void purgeJspRepository() throws Exception {
        OpenCms.fireCmsEvent(new CmsEvent(8, new HashMap<String, Object>()));
    }

    public String pwd() throws Exception {
        return CmsResource.getFolderPath(this.m_cms.getRequestContext().getUri());
    }

    public void quit() {
        this.exit();
    }

    public String readFileContent(String filename) throws CmsException {
        filename = CmsLinkManager.getAbsoluteUri(filename, CmsResource.getFolderPath(this.m_cms.getRequestContext().getUri()));
        CmsFile file = this.m_cms.readFile(filename, CmsResourceFilter.IGNORE_EXPIRATION);
        return new String(file.getContents());
    }

    public CmsGroup readGroupOfProject(CmsUUID project) throws Exception {
        return this.m_cms.readGroup(this.m_cms.readProject(project));
    }

    public CmsGroup readManagerGroup(CmsUUID project) throws Exception {
        return this.m_cms.readManagerGroup(this.m_cms.readProject(project));
    }

    public CmsUser readOwnerOfProject(CmsUUID project) throws Exception {
        return this.m_cms.readOwner(this.m_cms.readProject(project));
    }

    public void rebuildAllIndexes() throws Exception {
        CmsShellReport report = new CmsShellReport(this.m_cms.getRequestContext().getLocale());
        OpenCms.getSearchManager().rebuildAllIndexes(report);
    }

    public void rebuildIndex(String index) throws Exception {
        OpenCms.getSearchManager().rebuildIndex(index, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void reindexResources(String path, boolean reindexRelated) throws CmsException {
        CmsObject cms = OpenCms.initCmsObject(this.m_cms);
        HashMap<String, Object> eventData = new HashMap<String, Object>(3);
        boolean online = cms.getRequestContext().getCurrentProject().isOnlineProject();
        if (!online) {
            eventData.put("projectId", cms.getRequestContext().getCurrentProject().getId());
        }
        CmsResource resource = cms.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
        eventData.put("resources", Collections.singletonList(resource));
        eventData.put("report", new CmsLogReport(CmsLocaleManager.getDefaultLocale(), CmsSearchManager.class));
        eventData.put("related", reindexRelated);
        CmsEvent reindexEvent = new CmsEvent(online ? 34 : 35, eventData);
        OpenCms.fireCmsEvent(reindexEvent);
    }

    public void renameNestedContainers(String elementPath, String oldName, String newName, String project, String basePath, boolean ignoreSubSites) {
        try {
            CmsObject cms = OpenCms.initCmsObject(this.m_cms);
            cms.getRequestContext().setCurrentProject(cms.readProject(project));
            cms.getRequestContext().setSiteRoot("");
            CmsResource resource = cms.readResource(elementPath);
            CmsSearchReplaceSettings settings = new CmsSearchReplaceSettings();
            settings.setType(CmsSourceSearchForm.SearchType.renameContainer);
            settings.setSearchpattern(CmsSearchReplaceSettings.searchElementInPagePattern(resource));
            settings.setElementResource(resource);
            settings.setReplacepattern(oldName + ";" + newName);
            String siteRoot = OpenCms.getSiteManager().getSiteRoot(basePath);
            if (siteRoot != null) {
                settings.setSiteRoot(siteRoot);
                settings.setPaths(Collections.singletonList(basePath.substring(siteRoot.length())));
            } else {
                settings.setSiteRoot("");
                settings.setPaths(Collections.singletonList(basePath));
            }
            settings.setIgnoreSubSites(ignoreSubSites);
            settings.setProject(project);
            settings.setTypes("containerpage,modelgroup");
            CmsSearchReplaceThread thread = new CmsSearchReplaceThread(null, cms, settings, new CmsShellLogReport(this.m_cms.getRequestContext().getLocale()));
            thread.run();
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    public void replaceElementsInPages(String elementPath, String targetElementPath, String project, String basePath, boolean ignoreSubSites) {
        try {
            CmsObject cms = OpenCms.initCmsObject(this.m_cms);
            cms.getRequestContext().setCurrentProject(cms.readProject(project));
            cms.getRequestContext().setSiteRoot("");
            CmsResource resource = cms.readResource(elementPath);
            CmsResource targetResource = cms.readResource(targetElementPath);
            CmsSearchReplaceSettings settings = new CmsSearchReplaceSettings();
            settings.setType(CmsSourceSearchForm.SearchType.resourcetype);
            settings.setSearchpattern(CmsSearchReplaceSettings.searchElementInPagePattern(resource));
            settings.setReplacepattern(CmsSearchReplaceSettings.replaceElementInPagePattern(targetResource));
            String siteRoot = OpenCms.getSiteManager().getSiteRoot(basePath);
            if (siteRoot != null) {
                settings.setSiteRoot(siteRoot);
                settings.setPaths(Collections.singletonList(basePath.substring(siteRoot.length())));
            } else {
                settings.setSiteRoot("");
                settings.setPaths(Collections.singletonList(basePath));
            }
            settings.setIgnoreSubSites(ignoreSubSites);
            settings.setProject(project);
            settings.setTypes("containerpage,modelgroup");
            CmsSearchReplaceThread thread = new CmsSearchReplaceThread(null, cms, settings, new CmsShellLogReport(this.m_cms.getRequestContext().getLocale()));
            thread.run();
        }
        catch (CmsException e) {
            LOG.error((Object)"test", (Throwable)e);
        }
    }

    public void replaceModule(String importFile) throws Exception {
        OpenCms.getModuleManager().replaceModule(this.m_cms, importFile, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
    }

    public void replaceModule(String moduleName, String importFile) throws Exception {
        CmsModule module = CmsModuleImportExportHandler.readModuleFromImport(importFile);
        if (moduleName.equals(module.getName())) {
            this.replaceModule(importFile);
        } else {
            if (OpenCms.getModuleManager().getModule(moduleName) != null) {
                OpenCms.getModuleManager().deleteModule(this.m_cms, moduleName, true, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
            }
            this.importModule(importFile);
        }
    }

    public void replaceModuleFromDefault(String importFile) throws Exception {
        String exportPath = OpenCms.getSystemInfo().getPackagesRfsPath();
        String fileName = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(exportPath + CmsSystemInfo.FOLDER_MODULES + importFile);
        CmsModule module = CmsModuleImportExportHandler.readModuleFromImport(fileName);
        String moduleName = module.getName();
        this.replaceModuleFromDefault(moduleName, importFile);
    }

    public void replaceModuleFromDefault(String moduleName, String importFile) throws Exception {
        if (OpenCms.getModuleManager().getModule(moduleName) != null) {
            OpenCms.getModuleManager().deleteModule(this.m_cms, moduleName, true, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
        }
        this.importModuleFromDefault(importFile);
    }

    public void sendBroadcast(String message) {
        OpenCms.getSessionManager().sendBroadcast(this.m_cms, message, CmsBroadcast.ContentMode.plain);
    }

    public CmsProject setCurrentProject(CmsUUID id) throws Exception {
        return this.m_cms.getRequestContext().setCurrentProject(this.m_cms.readProject(id));
    }

    public CmsProject setCurrentProject(String name) throws Exception {
        return this.m_cms.getRequestContext().setCurrentProject(this.m_cms.readProject(name));
    }

    public void setIndexRebuildMode(String searchIndex, String mode) {
        I_CmsSearchIndex index = OpenCms.getSearchManager().getIndex(searchIndex);
        if (index != null) {
            index.setRebuildMode(mode);
            OpenCms.getSearchManager().initOfflineIndexes();
        }
    }

    public void setLocale(String localeName) throws CmsException {
        Locale locale = CmsLocaleManager.getLocale(localeName);
        this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_SETLOCALE_2", locale, this.m_cms.getRequestContext().getCurrentUser().getName()));
        this.m_shell.setLocale(locale);
        this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_SETLOCALE_POST_1", locale));
    }

    public void setLoginMessage(String messageText, boolean loginDisabled) throws CmsRoleViolationException {
        CmsLoginMessage message = new CmsLoginMessage(0L, 0L, messageText, loginDisabled);
        OpenCms.getLoginManager().setLoginMessage(this.m_cms, message);
        OpenCms.writeConfiguration(CmsVariablesConfiguration.class);
    }

    public void setSiteParam(String siteRoot, String key, String value) {
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(siteRoot);
        if (site == null) {
            throw new IllegalArgumentException("No site found for path: " + siteRoot);
        }
        site.getParameters().put(key, value);
        OpenCms.writeConfiguration(CmsSitesConfiguration.class);
    }

    public void setUserInfo(String username, String infoName, String value) throws CmsException {
        CmsUser user = this.m_cms.readUser(username);
        user.setAdditionalInfo(infoName, value);
        this.m_cms.writeUser(user);
    }

    @Override
    public void shellExit() {
        this.m_shell.getOut().println();
        this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_GOODBYE_0"));
    }

    @Override
    public void shellStart() {
        this.m_shell.getOut().println();
        this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_WELCOME_0"));
        this.m_shell.getOut().println();
        this.version();
        this.copyright();
        if (this.m_shell.isInteractive()) {
            this.help();
        }
    }

    public void sleep(String sleepMillis) throws NumberFormatException {
        try {
            Thread.sleep(Long.parseLong(sleepMillis));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void startBenchmark(String name) {
        this.m_shell.getBenchmarkTable().start(name);
    }

    public void stopBenchmark(String name) {
        this.m_shell.getBenchmarkTable().stop(name);
    }

    public void touchAllModules() {
        CmsModuleManager manager = OpenCms.getModuleManager();
        long time = System.currentTimeMillis();
        for (CmsModule module : manager.getAllInstalledModules()) {
            this.m_shell.getOut().println("Touching module: " + module.getName());
            module.setCheckpointTime(time);
        }
        this.m_shell.getOut().println("Writing module configuration.");
        manager.updateModuleConfiguration();
    }

    public void touchModule(String moduleName) {
        CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
        if (module == null) {
            this.m_shell.getOut().println("touchModule: could not find module " + moduleName);
        } else {
            this.m_shell.getOut().println("Touching module: " + moduleName);
            module.setCheckpointTime(System.currentTimeMillis());
            this.m_shell.getOut().println("Writing module configuration.");
            OpenCms.getModuleManager().updateModuleConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touchResource(String resourcePath) throws Exception {
        CmsResource resource = this.m_cms.readResource(resourcePath);
        CmsLockActionRecord action = CmsLockUtil.ensureLock(this.m_cms, resource);
        try {
            OpenCms.getWorkplaceManager().flushMessageCache();
            this.touchSingleResource(this.m_cms, resourcePath, System.currentTimeMillis(), true, true, true);
        }
        finally {
            if (action.getChange() == CmsLockActionRecord.LockChange.locked) {
                this.m_cms.unlockResource(resource);
            }
        }
    }

    public void transformXmlContents(String path, String typeName, String transform) throws Exception {
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis()));
        String additionalLogName = "xml_transform_" + timestamp + ".log";
        String additionalLogPath = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf("logs/" + additionalLogName);
        transform = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(transform);
        try (FileOutputStream additionalLog = new FileOutputStream(additionalLogPath);){
            CmsMultiplexReport report = new CmsMultiplexReport();
            report.addReport(new CmsPrintStreamReport(this.m_shell.getOut(), Locale.ENGLISH, false));
            report.addReport(new CmsPrintStreamReport(new PrintStream(additionalLog), Locale.ENGLISH, false));
            try (FileInputStream stream = new FileInputStream(transform);){
                CmsXmlFileTransformer fileTransformer = new CmsXmlFileTransformer(this.m_cms, path, typeName, transform, stream, report);
                fileTransformer.run();
            }
        }
    }

    public void unlockCurrentProject() throws Exception {
        this.m_cms.unlockProject(this.m_cms.getRequestContext().getCurrentProject().getUuid());
    }

    public void updateModule(String importFile) throws Exception {
        CmsModule module = CmsModuleImportExportHandler.readModuleFromImport(importFile);
        String moduleName = module.getName();
        String moduleVersion = module.getVersionStr();
        this.m_shell.getOut().println("Updating module " + moduleName + " version " + moduleVersion);
        if (OpenCms.getModuleManager().getModule(moduleName) != null) {
            String oldVersion = OpenCms.getModuleManager().getModule(moduleName).getVersionStr();
            this.m_shell.getOut().println("Previous version '" + oldVersion + "' detected");
            if (!oldVersion.equals(moduleVersion)) {
                OpenCms.getModuleManager().replaceModule(this.m_cms, importFile, new CmsShellReport(this.m_cms.getRequestContext().getLocale()));
            }
        } else {
            this.importModule(importFile);
        }
    }

    public void updateModuleFromDefault(String importFile) throws Exception {
        String exportPath = OpenCms.getSystemInfo().getPackagesRfsPath();
        String fileName = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(exportPath + CmsSystemInfo.FOLDER_MODULES + importFile);
        this.updateModule(fileName);
    }

    public void updateOfflineIndexes() {
        OpenCms.getSearchManager().updateOfflineIndexes();
    }

    public CmsResource uploadFile(String localfile, String folder, String filename, String type) throws Exception, CmsIllegalArgumentException {
        I_CmsResourceType t = OpenCms.getResourceManager().getResourceType(type);
        return this.m_cms.createResource(folder + filename, t, CmsFileUtil.readFile(new File(localfile)), null);
    }

    public String userName() {
        return this.m_cms.getRequestContext().getCurrentUser().getName();
    }

    public void version() {
        this.m_shell.getOut().println();
        this.m_shell.getOut().println(this.getMessages().key("GUI_SHELL_VERSION_1", OpenCms.getSystemInfo().getVersionNumber()));
    }

    public CmsUser whoami() {
        return this.m_cms.getRequestContext().getCurrentUser();
    }

    public void writeProperty(String resourceName, String propertyName, String value) throws CmsException {
        this.m_cms.lockResource(resourceName);
        this.m_cms.writePropertyObject(resourceName, new CmsProperty(propertyName, value, null));
    }

    protected CmsMessages getMessages() {
        return this.m_shell.getMessages();
    }

    private boolean existsUser(String name) {
        CmsUser user = null;
        try {
            user = this.m_cms.readUser(name);
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        return user != null;
    }

    private void hardTouch(CmsObject cms, CmsResource resource) throws CmsException {
        CmsFile file = cms.readFile(resource);
        cms = OpenCms.initCmsObject(cms);
        cms.getRequestContext().setAttribute(CmsXmlContent.AUTO_CORRECTION_ATTRIBUTE, Boolean.TRUE);
        file.setContents(file.getContents());
        cms.writeFile(file);
    }

    private void touchSingleResource(CmsObject cms, String resourceName, long timeStamp, boolean recursive, boolean correctDate, boolean touchContent) throws CmsException {
        CmsResource sourceRes = cms.readResource(resourceName, CmsResourceFilter.ALL);
        if (!correctDate) {
            timeStamp = sourceRes.getDateLastModified();
        }
        cms.setDateLastModified(resourceName, timeStamp, recursive);
        if (touchContent) {
            if (sourceRes.isFile()) {
                this.hardTouch(cms, sourceRes);
            } else if (recursive) {
                for (CmsResource subRes : cms.readResources(resourceName, CmsResourceFilter.ALL, true)) {
                    if (!subRes.isFile()) continue;
                    this.hardTouch(cms, subRes);
                }
            }
        }
    }
}

