/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.module;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.CmsExport;
import org.opencms.importexport.CmsExportParameters;
import org.opencms.importexport.CmsImport;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.CmsImportHelper;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.I_CmsImportExportHandler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsShell;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleDependency;
import org.opencms.module.CmsModuleXmlHandler;
import org.opencms.module.Messages;
import org.opencms.report.CmsHtmlReport;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlErrorHandler;
import org.opencms.xml.CmsXmlException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class CmsModuleImportExportHandler
implements I_CmsImportExportHandler {
    private static final Log LOG = CmsLog.getLog(CmsModuleImportExportHandler.class);
    private List<String> m_additionalResources;
    private String m_description = org.opencms.importexport.Messages.get().getBundle().key("GUI_CMSIMPORTHANDLER_DEFAULT_DESC_0");
    private String m_fileName;
    private CmsModule m_importedModule;
    private CmsImportParameters m_importParams;
    private String m_moduleName;

    public static CmsModuleImportExportHandler getExportHandler(CmsObject cms, CmsModule module, String handlerDescription) {
        String moduleName;
        List<Object> resListCopy;
        block6: {
            resListCopy = new ArrayList();
            moduleName = module.getName();
            try {
                cms = OpenCms.initCmsObject(cms);
                String importSite = module.getSite();
                if (!CmsStringUtil.isEmptyOrWhitespaceOnly(importSite)) {
                    cms.getRequestContext().setSiteRoot(importSite);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            try {
                resListCopy = CmsModule.calculateModuleResourceNames(cms, module);
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block6;
                LOG.warn((Object)Messages.get().getBundle().key("ERR_READ_MODULE_RESOURCES_1", module.getName()), (Throwable)e);
            }
        }
        resListCopy = CmsFileUtil.removeRedundancies(resListCopy);
        String[] resources = new String[resListCopy.size()];
        for (int i = 0; i < resListCopy.size(); ++i) {
            resources[i] = (String)resListCopy.get(i);
        }
        String filename = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(OpenCms.getSystemInfo().getPackagesRfsPath() + CmsSystemInfo.FOLDER_MODULES + moduleName + "_%(version)");
        CmsModuleImportExportHandler moduleExportHandler = new CmsModuleImportExportHandler();
        moduleExportHandler.setFileName(filename);
        moduleExportHandler.setModuleName(moduleName.replace('\\', '/'));
        moduleExportHandler.setAdditionalResources(resources);
        moduleExportHandler.setDescription(handlerDescription);
        return moduleExportHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CmsModule readModuleFromImport(String importResource) throws CmsConfigurationException {
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.setValidating(false);
        digester.setRuleNamespaceURI(null);
        digester.setErrorHandler((ErrorHandler)new CmsXmlErrorHandler(importResource));
        CmsModuleImportExportHandler handler = new CmsModuleImportExportHandler();
        final String[] version = new String[]{null};
        digester.push((Object)handler);
        digester.addRule("*/export_version", new Rule(){

            public void body(String namespace, String name, String text) throws Exception {
                version[0] = text.trim();
            }
        });
        CmsModuleXmlHandler.addXmlDigesterRules(digester);
        InputStream stream = null;
        ZipFile importZip = null;
        try {
            File file = new File(importResource);
            if (!file.exists()) {
                throw new IOException("readModuleFromImport: Path '" + importResource + "' does not exist.");
            }
            if (file.isFile()) {
                importZip = new ZipFile(importResource);
                ZipEntry entry = importZip.getEntry("manifest.xml");
                if (entry == null) {
                    CmsMessageContainer message = Messages.get().container("ERR_NO_MANIFEST_MODULE_IMPORT_1", importResource);
                    LOG.error((Object)message.key());
                    throw new CmsConfigurationException(message);
                }
                stream = importZip.getInputStream(entry);
            } else if (file.isDirectory()) {
                file = new File(file, "manifest.xml");
                stream = new FileInputStream(file);
            }
            digester.parse(stream);
        }
        catch (IOException e) {
            CmsMessageContainer message = Messages.get().container("ERR_IO_MODULE_IMPORT_1", importResource);
            LOG.error((Object)message.key(), (Throwable)e);
            throw new CmsConfigurationException(message, (Throwable)e);
        }
        catch (SAXException e) {
            CmsMessageContainer message = Messages.get().container("ERR_SAX_MODULE_IMPORT_1", importResource);
            LOG.error((Object)message.key(), (Throwable)e);
            throw new CmsConfigurationException(message, (Throwable)e);
        }
        finally {
            try {
                if (importZip != null) {
                    importZip.close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception exception) {}
        }
        CmsModule importedModule = handler.getModule();
        if (importedModule == null) {
            throw new CmsConfigurationException(Messages.get().container("ERR_IMPORT_MOD_ALREADY_INSTALLED_1", importResource));
        }
        importedModule.setExportVersion(version[0]);
        return importedModule;
    }

    public static CmsModule readModuleFromManifest(byte[] manifest) throws CmsConfigurationException {
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.setValidating(false);
        digester.setRuleNamespaceURI(null);
        digester.setErrorHandler((ErrorHandler)new CmsXmlErrorHandler("manifest data"));
        CmsModuleImportExportHandler handler = new CmsModuleImportExportHandler();
        final String[] version = new String[]{null};
        digester.push((Object)handler);
        digester.addRule("*/export_version", new Rule(){

            public void body(String namespace, String name, String text) throws Exception {
                version[0] = text.trim();
            }
        });
        CmsModuleXmlHandler.addXmlDigesterRules(digester);
        ByteArrayInputStream stream = new ByteArrayInputStream(manifest);
        try {
            digester.parse((InputStream)stream);
        }
        catch (IOException e) {
            CmsMessageContainer message = Messages.get().container("ERR_IO_MODULE_IMPORT_1", "manifest data");
            LOG.error((Object)message.key(), (Throwable)e);
            throw new CmsConfigurationException(message, (Throwable)e);
        }
        catch (SAXException e) {
            CmsMessageContainer message = Messages.get().container("ERR_SAX_MODULE_IMPORT_1", "manifest data");
            LOG.error((Object)message.key(), (Throwable)e);
            throw new CmsConfigurationException(message, (Throwable)e);
        }
        CmsModule importedModule = handler.getModule();
        if (importedModule == null) {
            throw new CmsConfigurationException(Messages.get().container("ERR_IMPORT_MOD_ALREADY_INSTALLED_1", "manifest data"));
        }
        importedModule.setExportVersion(version[0]);
        return importedModule;
    }

    public static void reportBeginImport(I_CmsReport report, String modulePackageName) {
        report.print(Messages.get().container("RPT_IMPORT_MODULE_BEGIN_0"), 2);
        if (report instanceof CmsHtmlReport) {
            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", "<i>" + modulePackageName + "</i>"));
        } else {
            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", modulePackageName));
        }
        report.println(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
    }

    public static void reportEndImport(I_CmsReport report) {
        report.println(Messages.get().container("RPT_IMPORT_MODULE_END_0"), 2);
    }

    @Override
    public void exportData(CmsObject cms, I_CmsReport report) throws CmsConfigurationException, CmsImportExportException, CmsRoleViolationException {
        boolean shouldIncrementVersion;
        OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        report.print(Messages.get().container("RPT_EXPORT_MODULE_BEGIN_0"), 2);
        if (report instanceof CmsHtmlReport) {
            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", "<i>" + this.getModuleName() + "</i>"));
        } else {
            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", this.getModuleName()));
        }
        report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
        if (!OpenCms.getModuleManager().hasModule(this.getModuleName())) {
            throw new CmsConfigurationException(Messages.get().container("ERR_NO_MOD_FOR_EXPORT_1", this.getModuleName()));
        }
        CmsModule module = OpenCms.getModuleManager().getModule(this.getModuleName());
        try {
            shouldIncrementVersion = module.isAutoIncrement() && (module.getVersion().isUpdated() || module.shouldIncrementVersionBasedOnResources(cms));
        }
        catch (CmsException e) {
            shouldIncrementVersion = false;
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        module.getVersion().setUpdated(false);
        if (shouldIncrementVersion) {
            module.getVersion().increment();
            module.setCheckpointTime(System.currentTimeMillis());
            OpenCms.getModuleManager().updateModuleConfiguration();
        }
        Element moduleElement = CmsModuleXmlHandler.generateXml(module, CmsModuleXmlHandler.XmlWriteMode.manifest);
        CmsExportParameters params = new CmsExportParameters(this.getFileName(), moduleElement, true, false, false, this.getAdditionalResources(), true, true, 0L, true, false, module.getExportMode(), null == module.getExcludeResources() || module.getExcludeResources().isEmpty() ? null : module.getResources());
        CmsObject exportCms = cms;
        String importSite = module.getSite();
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(importSite)) {
            try {
                exportCms = OpenCms.initCmsObject(exportCms);
                exportCms.getRequestContext().setSiteRoot(importSite);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        new CmsExport(exportCms, report).exportData(params);
        report.println(Messages.get().container("RPT_EXPORT_MODULE_END_0"), 2);
    }

    public List<String> getAdditionalResources() {
        return this.m_additionalResources;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public String getFileName() {
        CmsMacroResolver resolver = new CmsMacroResolver();
        resolver.addMacro("version", OpenCms.getModuleManager().getModule(this.m_moduleName).getVersionStr());
        return resolver.resolveMacros(this.m_fileName);
    }

    @Override
    public CmsImportParameters getImportParameters() {
        return this.m_importParams;
    }

    public String getModuleName() {
        return this.m_moduleName;
    }

    public List<String> getResourcesAsList() {
        return this.m_additionalResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void importData(CmsObject cms, I_CmsReport report) throws CmsXmlException, CmsImportExportException, CmsRoleViolationException, CmsException {
        CmsImportParameters parameters = this.getImportParameters();
        CmsProject previousProject = cms.getRequestContext().getCurrentProject();
        try {
            CmsProject importProject = null;
            String modulePackageName = null;
            String storedSiteRoot = cms.getRequestContext().getSiteRoot();
            CmsImportHelper helper = new CmsImportHelper(parameters);
            try {
                cms.getRequestContext().setSiteRoot("/");
                helper.openFile();
                modulePackageName = helper.getFileName();
                try {
                    importProject = cms.readProject(Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_IMPORT_MODULE_PROJECT_NAME_1", new Object[]{modulePackageName}));
                }
                catch (CmsException e) {
                    importProject = cms.createProject(Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_IMPORT_MODULE_PROJECT_NAME_1", new Object[]{modulePackageName}), Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_IMPORT_MODULE_PROJECT_DESC_1", new Object[]{modulePackageName}), OpenCms.getDefaultUsers().getGroupAdministrators(), OpenCms.getDefaultUsers().getGroupAdministrators(), CmsProject.PROJECT_TYPE_TEMPORARY);
                }
                cms.getRequestContext().setCurrentProject(importProject);
                cms.copyResourceToProject("/");
            }
            catch (Exception e) {
                throw new CmsImportExportException(Messages.get().container("ERR_IO_MODULE_IMPORT_1", parameters.getPath()), (Throwable)e);
            }
            finally {
                helper.closeFile();
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
            }
            CmsModuleImportExportHandler.reportBeginImport(report, modulePackageName);
            this.importModule(cms, report, parameters);
            report.println(Messages.get().container("RPT_PUBLISH_PROJECT_BEGIN_0"), 2);
            cms.unlockProject(importProject.getUuid());
            OpenCms.getPublishManager().publishProject(cms, report);
            OpenCms.getPublishManager().waitWhileRunning();
            report.println(Messages.get().container("RPT_PUBLISH_PROJECT_END_0"), 2);
            CmsModuleImportExportHandler.reportEndImport(report);
        }
        finally {
            cms.getRequestContext().setCurrentProject(previousProject);
        }
    }

    @Override
    @Deprecated
    public void importData(CmsObject cms, String importFile, String importPath, I_CmsReport report) throws CmsXmlException, CmsImportExportException, CmsRoleViolationException, CmsException {
        CmsImportParameters parameters = new CmsImportParameters(importFile, importPath, true);
        this.setImportParameters(parameters);
        this.importData(cms, report);
    }

    @Override
    public boolean matches(Document manifest) {
        Element rootElement = manifest.getRootElement();
        return rootElement.selectNodes("./module/name").size() > 0;
    }

    public void setAdditionalResources(String[] resources) {
        this.m_additionalResources = Arrays.asList(resources);
    }

    @Override
    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    @Override
    public void setImportParameters(CmsImportParameters importParams) {
        this.m_importParams = importParams;
    }

    public void setModule(CmsModuleXmlHandler moduleHandler) {
        this.m_importedModule = moduleHandler.getModule();
    }

    public void setModuleName(String moduleName) {
        this.m_moduleName = moduleName;
    }

    private CmsModule getModule() {
        return this.m_importedModule;
    }

    private synchronized CmsModule importModule(CmsObject cms, I_CmsReport report, CmsImportParameters parameters) throws CmsSecurityException, CmsConfigurationException, CmsException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        CmsModule importedModule = CmsModuleImportExportHandler.readModuleFromImport(parameters.getPath());
        if (OpenCms.getModuleManager().hasModule(importedModule.getName())) {
            throw new CmsConfigurationException(Messages.get().container("ERR_MOD_ALREADY_INSTALLED_1", importedModule.getName()));
        }
        List<CmsModuleDependency> dependencies = OpenCms.getModuleManager().checkDependencies(importedModule, 1);
        if (dependencies.size() > 0) {
            StringBuffer missingModules = new StringBuffer();
            for (CmsModuleDependency dependency : dependencies) {
                missingModules.append("  ").append(dependency.getName()).append(", Version ").append(dependency.getVersion()).append("\r\n");
            }
            throw new CmsConfigurationException(Messages.get().container("ERR_MOD_DEPENDENCY_INFO_2", importedModule.getName() + ", Version " + importedModule.getVersion(), missingModules));
        }
        ArrayList<I_CmsResourceType> checkedTypes = new ArrayList<I_CmsResourceType>();
        for (I_CmsResourceType type : importedModule.getResourceTypes()) {
            I_CmsResourceType conflictingType;
            int externalConflictIndex = OpenCms.getResourceManager().getResourceTypes().indexOf(type);
            if (externalConflictIndex >= 0 && !type.isIdentical(conflictingType = OpenCms.getResourceManager().getResourceTypes().get(externalConflictIndex))) {
                throw new CmsConfigurationException(org.opencms.loader.Messages.get().container("ERR_CONFLICTING_MODULE_RESOURCE_TYPES_5", new Object[]{type.getTypeName(), type.getTypeId(), importedModule.getName(), conflictingType.getTypeName(), conflictingType.getTypeId()}));
            }
            int internalConflictIndex = checkedTypes.indexOf(type);
            if (internalConflictIndex >= 0) {
                I_CmsResourceType conflictingType2 = (I_CmsResourceType)checkedTypes.get(internalConflictIndex);
                throw new CmsConfigurationException(org.opencms.loader.Messages.get().container("ERR_CONFLICTING_RESTYPES_IN_MODULE_5", new Object[]{importedModule.getName(), type.getTypeName(), type.getTypeId(), conflictingType2.getTypeName(), conflictingType2.getTypeId()}));
            }
            checkedTypes.add(type);
        }
        CmsObject importCms = OpenCms.initCmsObject(cms);
        String importSite = importedModule.getImportSite();
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(importSite)) {
            importCms.getRequestContext().setSiteRoot(importSite);
        } else {
            String siteToSet = importCms.getRequestContext().getSiteRoot();
            if ("".equals(siteToSet)) {
                siteToSet = "/";
            }
            importedModule.setSite(siteToSet);
        }
        OpenCms.getModuleManager().addModule(cms, importedModule);
        if (importedModule.getResourceTypes() != Collections.EMPTY_LIST) {
            OpenCms.getResourceManager().initialize(cms);
        }
        if (importedModule.getExplorerTypes() != Collections.EMPTY_LIST) {
            OpenCms.getWorkplaceManager().addExplorerTypeSettings(importedModule);
        }
        CmsImport cmsImport = new CmsImport(importCms, report);
        cmsImport.importData(parameters);
        Object importScript = importedModule.getImportScript();
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly((String)importScript)) {
            LOG.info((Object)("Executing import script for module " + importedModule.getName()));
            report.println(Messages.get().container("RPT_IMPORT_SCRIPT_HEADER_0"), 2);
            importScript = "echo on\n" + (String)importScript;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(buffer);
            CmsShell shell = new CmsShell(cms, "${user}@${project}:${siteroot}|${uri}>", null, out, out);
            shell.execute((String)importScript);
            String outputString = buffer.toString();
            LOG.info((Object)("Shell output for import script was: \n" + outputString));
            report.println(Messages.get().container("RPT_IMPORT_SCRIPT_OUTPUT_1", outputString));
        }
        importedModule.setCheckpointTime(System.currentTimeMillis());
        OpenCms.getModuleManager().updateModuleConfiguration();
        return importedModule;
    }
}

