/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.module;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.importexport.CmsImportVersion10;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.util.CmsFileUtil;

public class CmsResourceImportData {
    private List<CmsAccessControlEntry> m_aces;
    private boolean m_skipResourceIdCheck;
    private File m_contentFile;
    private boolean m_hasDateLastModified;
    private boolean m_hasStructureId;
    private CmsResource m_importResource;
    private String m_path;
    private List<CmsProperty> m_properties;
    private List<CmsImportVersion10.RelationData> m_relationData;
    private CmsResource m_resource;
    private String m_typeName;

    public CmsResourceImportData(CmsResource resource, String path, byte[] content, List<CmsProperty> properties, List<CmsAccessControlEntry> aces, List<CmsImportVersion10.RelationData> relationData, boolean hasStructureId, boolean hasDateLastModified, String typeName) {
        this.m_typeName = typeName;
        this.m_resource = resource;
        this.m_path = path;
        if (content != null) {
            this.m_contentFile = this.createTempFile(content);
        }
        if (properties == null) {
            properties = new ArrayList<CmsProperty>();
        }
        this.m_properties = properties;
        if (aces == null) {
            aces = new ArrayList<CmsAccessControlEntry>();
        }
        this.m_aces = aces;
        if (relationData == null) {
            relationData = new ArrayList<CmsImportVersion10.RelationData>();
        }
        this.m_relationData = relationData;
        this.m_hasStructureId = hasStructureId;
        this.m_hasDateLastModified = hasDateLastModified;
    }

    public void cleanUp() {
        if (this.m_contentFile != null) {
            this.m_contentFile.delete();
        }
    }

    public Object computeRootPath(CmsObject cms) {
        return cms.getRequestContext().addSiteRoot(this.m_path);
    }

    public List<CmsAccessControlEntry> getAccessControlEntries() {
        return this.m_aces;
    }

    public byte[] getContent() {
        if (this.m_contentFile == null) {
            return null;
        }
        try {
            return CmsFileUtil.readFile(this.m_contentFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CmsResource getImportResource() {
        return this.m_importResource;
    }

    public String getPath() {
        return this.m_path;
    }

    public Map<String, CmsProperty> getProperties() {
        return CmsProperty.getPropertyMap(this.m_properties);
    }

    public List<CmsImportVersion10.RelationData> getRelations() {
        return this.m_relationData;
    }

    public CmsResource getResource() {
        return this.m_resource;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public boolean hasContent() {
        return this.m_contentFile != null;
    }

    public boolean hasDateLastModified() {
        return this.m_hasDateLastModified;
    }

    public boolean hasStructureId() {
        return this.m_hasStructureId;
    }

    public boolean isSkipResourceIdCheck() {
        return this.m_skipResourceIdCheck;
    }

    public void setImportResource(CmsResource importRes) {
        this.m_importResource = importRes;
    }

    public void setSkipResourceIdCheck(boolean skipResourceIdCheck) {
        this.m_skipResourceIdCheck = skipResourceIdCheck;
    }

    private File createTempFile(byte[] content) {
        try {
            File file = File.createTempFile("ocms-moduleresource-", ".dat");
            file.deleteOnExit();
            try (FileOutputStream output = new FileOutputStream(file);){
                output.write(content);
            }
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

