/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.notification;

import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.mail.EmailException;
import org.htmlparser.util.ParserException;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.i18n.CmsMessages;
import org.opencms.mail.CmsHtmlMail;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.notification.CmsNotificationMacroResolver;
import org.opencms.notification.Messages;
import org.opencms.util.CmsHtml2TextConverter;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public abstract class A_CmsNotification
extends CmsHtmlMail {
    public static final String SYSTEM_MAIL_HOST = "system";
    public static final String HEADER_FOOTER_CONFIG_PATH = "notification-header-footer.html";
    public static final String HEADER_FOOTER_SEPARATOR = Pattern.quote("$BODY");
    private static final Log LOG = CmsLog.getLog(A_CmsNotification.class);
    protected String m_configuredHeader;
    protected String m_configuredFooter;
    protected CmsXmlContent m_mailContent;
    protected CmsObject m_cms;
    protected Locale m_locale;
    protected CmsNotificationMacroResolver m_macroResolver;
    private CmsUser m_receiver;

    public A_CmsNotification(CmsObject cms, CmsUser receiver) {
        super(SYSTEM_MAIL_HOST);
        this.m_cms = cms;
        this.m_receiver = receiver;
        this.m_macroResolver = new CmsNotificationMacroResolver(cms, receiver);
        this.m_macroResolver.setCmsObject(cms);
    }

    public void addMacro(String key, String value) {
        this.m_macroResolver.addMacro(key, value);
    }

    public CmsObject getCmsObject() {
        return this.m_cms;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public CmsUser getReceiver() {
        return this.m_receiver;
    }

    public String send() throws EmailException {
        String messageID = null;
        try {
            Locale userLocale;
            if (CmsStringUtil.isEmpty(this.m_receiver.getEmail())) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_NOTIFICATION_NO_ADDRESS_1", this.m_receiver.getName()));
                return null;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_NOTIFICATION_SEND_1", this.m_receiver.getEmail()));
            }
            this.m_mailContent = CmsXmlContentFactory.unmarshal(this.m_cms, this.m_cms.readFile(this.getNotificationContent()));
            List<Locale> locales = this.m_mailContent.getLocales();
            this.m_locale = locales.contains(userLocale = new CmsUserSettings(this.m_receiver).getLocale()) ? userLocale : (locales.contains(OpenCms.getWorkplaceManager().getDefaultLocale()) ? OpenCms.getWorkplaceManager().getDefaultLocale() : locales.get(0));
            String mailCharset = Messages.get().getBundle(this.m_locale).key("GUI_MAIL_CHARSET_0");
            if (!CmsMessages.isUnknownKey(mailCharset)) {
                this.setCharset(mailCharset);
            }
            this.m_macroResolver.addMacro("firstname", this.m_receiver.getFirstname());
            this.m_macroResolver.addMacro("lastname", this.m_receiver.getLastname());
            this.m_macroResolver.addMacro("project", this.m_cms.getRequestContext().getCurrentProject().getName());
            try {
                CmsResource configRes = this.m_cms.readResource(OpenCms.getSystemInfo().getConfigFilePath(this.m_cms, HEADER_FOOTER_CONFIG_PATH));
                CmsFile configFile = this.m_cms.readFile(configRes);
                String configContent = new String(configFile.getContents(), "UTF-8");
                String[] configParts = configContent.split(HEADER_FOOTER_SEPARATOR);
                if (configParts.length == 2) {
                    this.m_configuredHeader = configParts[0];
                    this.m_configuredFooter = configParts[1];
                } else {
                    LOG.error((Object)"Invalid notification header/footer configuration: notification-header-footer.html");
                }
            }
            catch (CmsVfsResourceNotFoundException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            StringBuffer msg = new StringBuffer();
            this.appendHtmlHeader(msg);
            this.appendXMLContent(msg);
            this.appenHtmlFooter(msg);
            this.addTo(this.m_receiver.getEmail(), this.m_receiver.getFirstname() + " " + this.m_receiver.getLastname());
            this.setSubject(CmsMacroResolver.resolveMacros(this.m_mailContent.getStringValue(this.m_cms, "Subject", this.m_locale), this.m_macroResolver));
            this.setHtmlMsg(msg.toString());
            try {
                String textMsg = CmsHtml2TextConverter.html2text(msg.toString(), mailCharset);
                this.setTextMsg(textMsg);
            }
            catch (ParserException e) {
                LOG.error((Object)"Failed to process the text version of a HTML message.", (Throwable)e);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            super.send();
            messageID = this.getMimeMessage().getMessageID();
        }
        catch (CmsException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_NOTIFICATION_SEND_ERROR_0"), (Throwable)e);
        }
        catch (MessagingException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_NOTIFICATION_SEND_ERROR_0"), (Throwable)e);
        }
        return messageID;
    }

    protected void appendHtmlHeader(StringBuffer buffer) {
        if (this.m_configuredHeader != null) {
            buffer.append(this.m_configuredHeader);
        } else {
            buffer.append("<html>\r\n");
            buffer.append("  <head>\r\n");
            buffer.append("    <style type=\"text/css\">\r\n");
            buffer.append("      body { font-family: Verdana, Arial, Helvetica, sans-serif; background-color:white; }\r\n");
            buffer.append("      a { color:#b31b43; text-decoration:none; font-weight: bold; }\r\n");
            buffer.append("      a:hover { color:#b31b43; text-decoration:underline; font-weight: bold; }\r\n");
            buffer.append("      div.publish_link { margin: 20px 0; }\r\n");
            buffer.append("      table { white-space: nowrap; font-size: small; }\r\n");
            buffer.append("      tr.trow1 { background-color: #cdc0b0; }\r\n");
            buffer.append("      tr.trow2 { background-color: #eedfcc; }\r\n");
            buffer.append("      tr.trow3 { background-color: #ffefdb; }\r\n");
            buffer.append("      th.rescol { border-width: 1px 0 2px 1px; border-style: solid; border-color: #222222; padding: 5px; }\r\n");
            buffer.append("      th.titlecol { border-width: 1px 1px 2px 1px; border-style: solid; border-color: #222222; padding: 5px; }\r\n");
            buffer.append("      td.rescol { border-width: 0 0 1px 1px; border-style: solid; border-color: #222222; padding: 5px; }\r\n");
            buffer.append("      td.titlecol { border-width: 0 1px 1px 1px; border-style: solid; border-color: #222222; padding: 5px; }\r\n");
            buffer.append("    </style>\r\n");
            buffer.append("  </head>\r\n");
            buffer.append("  <body>\r\n");
        }
    }

    protected void appendXMLContent(StringBuffer msg) {
        msg.append(CmsMacroResolver.resolveMacros(this.m_mailContent.getStringValue(this.m_cms, "Header", this.m_locale), this.m_macroResolver));
        msg.append("\n<br/><br/>\n");
        msg.append(this.generateHtmlMsg());
        msg.append("\n<br/><br/>\n");
        msg.append(CmsMacroResolver.resolveMacros(this.m_mailContent.getStringValue(this.m_cms, "Footer", this.m_locale), this.m_macroResolver));
    }

    protected void appenHtmlFooter(StringBuffer buffer) {
        if (this.m_configuredFooter != null) {
            buffer.append(this.m_configuredFooter);
        } else {
            buffer.append("  </body>\r\n</html>");
        }
    }

    protected abstract String generateHtmlMsg();

    protected abstract String getNotificationContent();
}

