/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.notification;

import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;

public class CmsNotificationMacroResolver
extends CmsMacroResolver {
    public static final String RECEIVER_SIMPLENAME = "receiver.simplename";
    public static final String RECEIVER_EMAIL = "receiver.email";
    public static final String RECEIVER_FIRSTNAME = "receiver.firstname";
    public static final String RECEIVER_LASTNAME = "receiver.lastname";
    public static final String RECEIVER_OU = "receiver.ou";
    public static final String RECEIVER_OU_FQN = "receiver.ou-fqn";
    public static final String RECEIVER_ADDRESS = "receiver.address";
    public static final String RECEIVER_CITY = "receiver.city";
    public static final String RECEIVER_COUNTRY = "receiver.country";
    public static final String RECEIVER_INSTITUTION = "receiver.institution";
    public static final String RECEIVER_FULLNAME = "receiver.fullname";
    public static final String AUTHOR_SIMPLENAME = "author.simplename";
    public static final String WORKPLACE_URL = "workplace.url";
    public static final String WORKPLACE_LOGIN_URL = "workplace.login-url";
    public static final String WORKPLACE_LOGIN_LINK = "workplace.login-url.html";

    public CmsNotificationMacroResolver(CmsObject cms, CmsUser receiver) {
        this.addMacro(RECEIVER_SIMPLENAME, receiver.getSimpleName());
        this.addMacro(RECEIVER_FIRSTNAME, receiver.getFirstname());
        this.addMacro(RECEIVER_LASTNAME, receiver.getLastname());
        this.addMacro(RECEIVER_EMAIL, receiver.getEmail());
        this.addMacro(RECEIVER_OU_FQN, receiver.getOuFqn());
        try {
            this.addMacro(RECEIVER_OU, OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, receiver.getOuFqn()).getDisplayName(new CmsUserSettings(receiver).getLocale()));
        }
        catch (CmsException e) {
            this.addMacro(RECEIVER_OU, receiver.getOuFqn());
        }
        this.addMacro(RECEIVER_ADDRESS, receiver.getAddress());
        this.addMacro(RECEIVER_CITY, receiver.getCity());
        this.addMacro(RECEIVER_COUNTRY, receiver.getCountry());
        this.addMacro(RECEIVER_INSTITUTION, receiver.getInstitution());
        this.addMacro(RECEIVER_FULLNAME, receiver.getFirstname() + " " + receiver.getLastname());
        this.addMacro(AUTHOR_SIMPLENAME, cms.getRequestContext().getCurrentUser().getSimpleName());
        this.addMacro(WORKPLACE_URL, OpenCms.getSiteManager().getWorkplaceServer());
        this.addMacro(WORKPLACE_LOGIN_URL, OpenCms.getLinkManager().getWorkplaceLink(cms, "/system/login", false));
        this.addMacro(WORKPLACE_LOGIN_LINK, "<a href =\"" + OpenCms.getLinkManager().getWorkplaceLink(cms, "/system/login", false) + "\">" + OpenCms.getLinkManager().getWorkplaceLink(cms, "/system/login", false) + "</a>");
    }
}

