/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.publish;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.commons.collections.buffer.TypedBuffer;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.generic.CmsPublishHistoryCleanupFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.publish.CmsPublishEngine;
import org.opencms.publish.CmsPublishJobFinished;
import org.opencms.publish.CmsPublishJobInfoBean;
import org.opencms.publish.Messages;

public class CmsPublishHistory {
    protected static final Log LOG = CmsLog.getLog(CmsPublishHistory.class);
    protected final CmsPublishEngine m_publishEngine;

    protected CmsPublishHistory(CmsPublishEngine publishEngine) {
        this.m_publishEngine = publishEngine;
    }

    public static Buffer getQueue(int size) {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_PUBLISH_HISTORY_SIZE_SET_1", size));
        }
        return BufferUtils.synchronizedBuffer((Buffer)TypedBuffer.decorate((Buffer)new CircularFifoBuffer(size){
            private static final long serialVersionUID = -6257542123241183114L;

            public Object remove() {
                CmsPublishJobInfoBean publishJob;
                block2: {
                    publishJob = (CmsPublishJobInfoBean)super.remove();
                    try {
                        OpenCms.getPublishManager().getEngine().getPublishHistory().remove(publishJob);
                    }
                    catch (CmsException exc) {
                        if (!LOG.isErrorEnabled()) break block2;
                        LOG.error((Object)exc.getLocalizedMessage(), (Throwable)exc);
                    }
                }
                return publishJob;
            }
        }, CmsPublishJobInfoBean.class));
    }

    protected void add(CmsPublishJobInfoBean publishJob) throws CmsException {
        OpenCms.getMemoryMonitor().cachePublishJobInHistory(publishJob);
        if (OpenCms.getMemoryMonitor().requiresPersistency()) {
            CmsDbContext dbc = this.m_publishEngine.getDbContext(null);
            try {
                this.m_publishEngine.getDriverManager().writePublishJob(dbc, publishJob);
                this.m_publishEngine.getDriverManager().writePublishReport(dbc, publishJob);
                this.m_publishEngine.getDriverManager().deletePublishList(dbc, publishJob.getPublishHistoryId());
            }
            catch (CmsException e) {
                dbc.rollback();
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
            finally {
                dbc.clear();
            }
        }
    }

    protected List<CmsPublishJobFinished> asList() {
        List<CmsPublishJobInfoBean> cachedPublishJobs = OpenCms.getMemoryMonitor().getAllCachedPublishJobsInHistory();
        ArrayList<CmsPublishJobFinished> result = new ArrayList<CmsPublishJobFinished>(cachedPublishJobs.size());
        for (CmsPublishJobInfoBean publishJob : cachedPublishJobs) {
            result.add(new CmsPublishJobFinished(publishJob));
        }
        return Collections.unmodifiableList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        CmsDriverManager driverManager = this.m_publishEngine.getDriverManager();
        CmsDbContext dbc = this.m_publishEngine.getDbContext(null);
        try {
            OpenCms.getMemoryMonitor().flushCache(CmsMemoryMonitor.CacheType.PUBLISH_HISTORY);
            List<CmsPublishJobInfoBean> publishJobs = driverManager.readPublishJobs(dbc, 1L, Long.MAX_VALUE);
            for (CmsPublishJobInfoBean job : publishJobs) {
                OpenCms.getMemoryMonitor().cachePublishJobInHistory(job);
            }
        }
        catch (CmsException exc) {
            dbc.rollback();
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)exc.getLocalizedMessage(), (Throwable)exc);
            }
        }
        finally {
            dbc.clear();
        }
    }

    protected void remove(CmsPublishJobInfoBean publishJob) throws CmsException {
        OpenCms.getMemoryMonitor().uncachePublishJobInHistory(publishJob);
        if (OpenCms.getMemoryMonitor().requiresPersistency()) {
            CmsDbContext dbc = this.m_publishEngine.getDbContext(null);
            try {
                OpenCms.getPublishManager().getEngine().getDriverManager().deletePublishJob(dbc, publishJob.getPublishHistoryId());
                if (OpenCms.getPublishManager().isAutoCleanupHistoryEntries()) {
                    OpenCms.getPublishManager().getEngine().getDriverManager().cleanupPublishHistory(dbc, CmsPublishHistoryCleanupFilter.forHistoryId(publishJob.getPublishHistoryId()));
                }
            }
            catch (CmsException e) {
                dbc.rollback();
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
            finally {
                dbc.clear();
            }
        }
        this.m_publishEngine.publishJobRemoved(publishJob);
    }
}

