/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.publish;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishEngine;
import org.opencms.publish.CmsPublishJobBase;
import org.opencms.publish.CmsPublishJobEnqueued;
import org.opencms.publish.CmsPublishJobFinished;
import org.opencms.publish.CmsPublishJobRunning;
import org.opencms.publish.I_CmsPublishEventListener;
import org.opencms.publish.Messages;
import org.opencms.staticexport.CmsAfterPublishStaticExportHandler;
import org.opencms.util.CmsUUID;

public final class CmsPublishListenerCollection
extends Vector<I_CmsPublishEventListener> {
    private static final Log LOG = CmsLog.getLog(CmsPublishListenerCollection.class);
    private static final long serialVersionUID = -4945973010986412449L;
    private transient CmsPublishEngine m_publishEngine;

    protected CmsPublishListenerCollection(CmsPublishEngine publishEngine) {
        this.m_publishEngine = publishEngine;
    }

    protected void fireAbort(CmsUUID userId, CmsPublishJobEnqueued publishJob) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_PUBLISH_JOB_ABORT_0"));
        }
        for (I_CmsPublishEventListener listener : this) {
            try {
                listener.onAbort(userId, publishJob);
            }
            catch (Throwable t) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PUBLISH_JOB_ABORT_ERROR_1", listener.getClass().getName()), t);
                }
                if (publishJob.m_publishJob.getPublishReport() == null) continue;
                publishJob.m_publishJob.getPublishReport().println(t);
            }
        }
        if (userId != null && userId.equals(publishJob.getUserId())) {
            return;
        }
        String msgText = Messages.get().getBundle(publishJob.getLocale()).key("GUI_PUBLISH_JOB_ABORTED_2", publishJob.getEnqueueTime(), this.m_publishEngine.getUser(userId).getName());
        this.m_publishEngine.sendMessage(publishJob.getUserId(), msgText, true);
    }

    protected void fireEnqueued(CmsPublishJobBase publishJob) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_PUBLISH_JOB_ENQUEUE_0"));
        }
        for (I_CmsPublishEventListener listener : this) {
            try {
                listener.onEnqueue(publishJob);
            }
            catch (Throwable t) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PUBLISH_JOB_ENQUEUE_ERROR_1", listener.getClass().getName()), t);
                }
                if (publishJob.m_publishJob.getPublishReport() == null) continue;
                publishJob.m_publishJob.getPublishReport().println(t);
            }
        }
    }

    protected void fireFinish(CmsPublishJobRunning publishJob) {
        String msgText;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_PUBLISH_JOB_FINISH_0"));
        }
        for (I_CmsPublishEventListener listener : this) {
            try {
                listener.onFinish(publishJob);
            }
            catch (Throwable t) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PUBLISH_JOB_FINISH_ERROR_1", listener.getClass().getName()), t);
                }
                if (publishJob.m_publishJob.getPublishReport() == null) continue;
                publishJob.m_publishJob.getPublishReport().println(t);
            }
        }
        boolean hasError = false;
        if (!publishJob.getReport().hasError() && !publishJob.getReport().hasWarning()) {
            msgText = Messages.get().getBundle(publishJob.getLocale()).key("GUI_PUBLISH_JOB_FINISHED_1", publishJob.getEnqueueTime());
        } else {
            hasError = true;
            Object[] params = new Object[]{publishJob.getEnqueueTime(), publishJob.getReport().getErrors().size(), publishJob.getReport().getWarnings().size()};
            msgText = Messages.get().getBundle(publishJob.getLocale()).key("GUI_PUBLISH_JOB_FINISHED_WITH_WARNS_3", params);
        }
        this.m_publishEngine.sendMessage(publishJob.getUserId(), msgText, hasError);
    }

    protected void fireRemove(CmsPublishJobFinished publishJob) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_PUBLISH_JOB_REMOVE_0"));
        }
        for (I_CmsPublishEventListener listener : this) {
            try {
                listener.onRemove(publishJob);
            }
            catch (Throwable t) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PUBLISH_JOB_REMOVE_ERROR_1", listener.getClass().getName()), t);
                }
                if (publishJob.m_publishJob.getPublishReport() == null) continue;
                publishJob.m_publishJob.getPublishReport().println(t);
            }
        }
    }

    protected void fireStart(CmsPublishJobEnqueued publishJob) {
        boolean bigJob;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_PUBLISH_JOB_START_0"));
        }
        for (I_CmsPublishEventListener listener : this) {
            try {
                listener.onStart(publishJob);
            }
            catch (Throwable t) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PUBLISH_JOB_START_ERROR_1", listener.getClass().getName()), t);
                }
                if (publishJob.m_publishJob.getPublishReport() == null) continue;
                publishJob.m_publishJob.getPublishReport().println(t);
            }
        }
        boolean busyStart = System.currentTimeMillis() - publishJob.getEnqueueTime() > 2000L;
        boolean bl = bigJob = publishJob.getPublishList().size() > 25 || OpenCms.getStaticExportManager().getHandler() instanceof CmsAfterPublishStaticExportHandler;
        if (busyStart || bigJob) {
            String msgText = Messages.get().getBundle(publishJob.getLocale()).key("GUI_PUBLISH_JOB_STARTED_1", publishJob.getEnqueueTime());
            this.m_publishEngine.sendMessage(publishJob.getUserId(), msgText, false);
        }
    }
}

