/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.report;

import com.google.common.collect.Maps;
import java.util.Map;

public enum CmsReportFormatType {
    fmtDefault("FORMAT_DEFAULT", 0),
    fmtError("FORMAT_ERROR", 5),
    fmtException("EXCEPTION", -2),
    fmtHeadline("FORMAT_HEADLINE", 2),
    fmtNewline("NEWLINE", -1),
    fmtNote("FORMAT_NOTE", 3),
    fmtOk("FORMAT_OK", 4),
    fmtWarning("FORMAT_WARNING", 1);

    private static Map<Integer, CmsReportFormatType> m_byId;
    private static Map<String, CmsReportFormatType> m_byName;
    private int m_id;
    private String m_name;

    private CmsReportFormatType(String formatName, int formatId) {
        this.m_name = formatName;
        this.m_id = formatId;
    }

    public static CmsReportFormatType byId(int id) {
        return m_byId.get(id);
    }

    public static CmsReportFormatType byName(String name) {
        return m_byName.get(name);
    }

    public int getFormatId() {
        return this.m_id;
    }

    public String getFormatName() {
        return this.m_name;
    }

    static {
        m_byId = Maps.newHashMap();
        m_byName = Maps.newHashMap();
        for (CmsReportFormatType type : CmsReportFormatType.values()) {
            m_byId.put(type.getFormatId(), type);
            m_byName.put(type.getFormatName(), type);
        }
    }
}

