/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.report;

import java.io.PrintStream;
import java.util.Locale;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsShell;
import org.opencms.report.CmsPrintStreamReport;

public class CmsShellReport
extends CmsPrintStreamReport {
    private boolean m_stillRunning;

    public CmsShellReport(Locale locale) {
        super(CmsShellReport.getOutputStream(), locale, false);
    }

    public static PrintStream getOutputStream() {
        CmsShell shell = CmsShell.getTopShell();
        if (shell != null) {
            return shell.getOut();
        }
        return System.out;
    }

    @Override
    public void addError(Object obj) {
        super.addError(obj);
        CmsShell.setReportError();
    }

    @Override
    public synchronized String getReportUpdate() {
        if (this.m_stillRunning) {
            this.m_stillRunning = false;
            return "*";
        }
        return "";
    }

    @Override
    public void print(CmsMessageContainer container) {
        super.print(container);
        this.m_stillRunning = true;
    }

    @Override
    public void print(CmsMessageContainer container, int format) {
        super.print(container, format);
        this.m_stillRunning = true;
    }

    @Override
    public void println() {
        super.println();
        this.m_stillRunning = true;
    }

    @Override
    public void println(CmsMessageContainer container) {
        super.println(container);
        this.m_stillRunning = true;
    }

    @Override
    public void println(CmsMessageContainer container, int format) {
        super.println(container, format);
        this.m_stillRunning = true;
    }

    @Override
    public void println(Throwable t) {
        super.println(t);
        this.m_stillRunning = true;
    }

    @Override
    public void printMessageWithParam(CmsMessageContainer container, Object param) {
        super.printMessageWithParam(container, param);
        this.m_stillRunning = true;
    }

    @Override
    public void printMessageWithParam(int m, int n, CmsMessageContainer container, Object param) {
        super.printMessageWithParam(m, n, container, param);
        this.m_stillRunning = true;
    }

    @Override
    public void start() {
        super.start();
        this.m_stillRunning = true;
    }
}

