/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.report.I_CmsReport;
import org.opencms.search.CmsIndexingThreadManager;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchIndexUpdateData;
import org.opencms.search.I_CmsIndexWriter;
import org.opencms.search.I_CmsIndexer;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.I_CmsSearchIndex;
import org.opencms.search.Messages;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsUUID;

public class CmsVfsIndexer
implements I_CmsIndexer {
    private static final Log LOG = CmsLog.getLog(CmsVfsIndexer.class);
    protected CmsObject m_cms;
    protected I_CmsSearchIndex m_index;
    protected I_CmsReport m_report;

    @Override
    public void deleteResources(I_CmsIndexWriter indexWriter, List<CmsPublishedResource> resourcesToDelete) {
        if (resourcesToDelete == null || resourcesToDelete.isEmpty()) {
            return;
        }
        ArrayList<CmsUUID> resourcesAlreadyDeleted = new ArrayList<CmsUUID>(resourcesToDelete.size());
        for (CmsPublishedResource res : resourcesToDelete) {
            if (resourcesAlreadyDeleted.contains(res.getStructureId())) continue;
            resourcesAlreadyDeleted.add(res.getStructureId());
            if (res.isFolder() || CmsResource.isTemporaryFileName(res.getRootPath())) continue;
            this.deleteResource(indexWriter, res);
        }
    }

    public CmsObject getCms() {
        return this.m_cms;
    }

    public I_CmsSearchIndex getIndex() {
        return this.m_index;
    }

    public I_CmsReport getReport() {
        return this.m_report;
    }

    @Override
    public CmsSearchIndexUpdateData getUpdateData(CmsSearchIndexSource source, List<CmsPublishedResource> publishedResources) {
        CmsSearchIndexUpdateData result = new CmsSearchIndexUpdateData(source, this);
        for (CmsPublishedResource pubRes : publishedResources) {
            if (pubRes.getStructureId().isNullUUID() || !CmsProject.isInsideProject(source.getResourcesNames(), pubRes.getRootPath())) continue;
            this.addResourceToUpdateData(pubRes, result);
        }
        return result;
    }

    @Override
    public boolean isLocaleDependenciesEnable() {
        return false;
    }

    @Override
    public I_CmsIndexer newInstance(CmsObject cms, I_CmsReport report, I_CmsSearchIndex index) {
        CmsVfsIndexer indexer = null;
        try {
            indexer = (CmsVfsIndexer)this.getClass().newInstance();
            indexer.m_cms = cms;
            indexer.m_report = report;
            indexer.m_index = index;
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_INDEXSOURCE_INDEXER_CLASS_NAME_2", this.getClass().getName(), CmsVfsIndexer.class), (Throwable)e);
        }
        return indexer;
    }

    @Override
    public void rebuildIndex(I_CmsIndexWriter writer, CmsIndexingThreadManager threadManager, CmsSearchIndexSource source) {
        List<String> resourceNames = source.getResourcesNames();
        for (String resourceName : resourceNames) {
            List<CmsResource> resources;
            block5: {
                resources = null;
                try {
                    resources = this.m_cms.readResources(resourceName, CmsResourceFilter.IGNORE_EXPIRATION.addRequireFile());
                }
                catch (CmsException e) {
                    if (this.m_report != null) {
                        this.m_report.println(Messages.get().container("RPT_UNABLE_TO_READ_SOURCE_2", resourceName, e.getLocalizedMessage()), 1);
                    }
                    if (!LOG.isWarnEnabled()) break block5;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_UNABLE_TO_READ_SOURCE_2", resourceName, this.m_index.getName()), (Throwable)e);
                }
            }
            if (resources == null) continue;
            for (CmsResource resource : resources) {
                this.updateResource(writer, threadManager, resource);
            }
        }
    }

    @Override
    public void updateResources(I_CmsIndexWriter writer, CmsIndexingThreadManager threadManager, List<CmsPublishedResource> resourcesToUpdate) {
        if (resourcesToUpdate == null || resourcesToUpdate.isEmpty()) {
            return;
        }
        ArrayList<String> resourcesAlreadyUpdated = new ArrayList<String>(resourcesToUpdate.size());
        for (CmsPublishedResource res : resourcesToUpdate) {
            CmsResource resource;
            block8: {
                resource = null;
                if (CmsResource.isTemporaryFileName(res.getRootPath())) continue;
                try {
                    resource = this.m_cms.readResource(res.getRootPath(), CmsResourceFilter.IGNORE_EXPIRATION);
                }
                catch (CmsException e) {
                    if (!LOG.isWarnEnabled()) break block8;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_UNABLE_TO_READ_RESOURCE_2", res.getRootPath(), this.m_index.getName()), (Throwable)e);
                }
            }
            if (resource == null) continue;
            if (!resourcesAlreadyUpdated.contains(resource.getRootPath())) {
                resourcesAlreadyUpdated.add(resource.getRootPath());
                this.updateResource(writer, threadManager, resource);
            }
            if (!resource.isFolder()) continue;
            try {
                CmsResource defaultFile = this.m_cms.readDefaultFile(resource, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                if (defaultFile == null || resourcesAlreadyUpdated.contains(defaultFile.getRootPath())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_INDEXING_DEFAULT_FILE_FOR_FOLDER_3", defaultFile.getRootPath(), res.getRootPath(), this.m_index.getName()));
                }
                this.updateResource(writer, threadManager, defaultFile);
            }
            catch (CmsSecurityException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_UNABLE_TO_READ_DEFAULT_FILE_FOR_FOLDER_2", res.getRootPath(), this.m_index.getName()), (Throwable)e);
            }
        }
    }

    protected void addResourceToUpdateData(CmsPublishedResource pubRes, CmsSearchIndexUpdateData updateData) {
        if (pubRes.getState().isDeleted()) {
            updateData.addResourceToDelete(pubRes);
        } else if (pubRes.getState().isNew() || pubRes.getState().isChanged() || pubRes.getState().isUnchanged()) {
            updateData.addResourceToUpdate(pubRes);
        }
    }

    protected void deleteResource(I_CmsIndexWriter indexWriter, CmsPublishedResource resource) {
        block3: {
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_DELETING_FROM_INDEX_1", resource.getRootPath()));
                }
                indexWriter.deleteDocument(resource);
            }
            catch (IOException e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_IO_INDEX_DOCUMENT_DELETE_2", resource.getRootPath(), this.m_index.getName()), (Throwable)e);
            }
        }
    }

    protected boolean isResourceInTimeWindow(CmsPublishedResource resource) {
        return this.m_cms.existsResource(this.m_cms.getRequestContext().removeSiteRoot(resource.getRootPath()), CmsResourceFilter.DEFAULT);
    }

    protected void updateResource(I_CmsIndexWriter writer, CmsIndexingThreadManager threadManager, CmsResource resource) {
        block4: {
            if (resource.isFolder() || resource.isTemporaryFile()) {
                return;
            }
            try {
                threadManager.createIndexingThread(this, writer, resource);
            }
            catch (Throwable e) {
                if (this.m_report != null) {
                    this.m_report.println(Messages.get().container("RPT_SEARCH_INDEXING_FAILED_0"), 1);
                }
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)Messages.get().getBundle().key("ERR_INDEX_RESOURCE_FAILED_2", resource.getRootPath(), this.m_index.getName()), e);
            }
        }
    }

    protected void updateResource(I_CmsIndexWriter indexWriter, String rootPath, I_CmsSearchDocument doc) {
        block2: {
            try {
                indexWriter.updateDocument(rootPath, doc);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_IO_INDEX_DOCUMENT_UPDATE_2", rootPath, this.m_index.getName()), (Throwable)e);
            }
        }
    }
}

