/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.uninverting.UninvertingReader;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.fields.I_CmsSearchFieldConfiguration;

public abstract class A_CmsSearchFieldConfiguration
implements I_CmsSearchFieldConfiguration {
    private static final long serialVersionUID = 7948072454782743591L;
    private String m_description;
    private String m_name;
    private Map<String, CmsSearchField> m_fields = new LinkedHashMap<String, CmsSearchField>();

    @Override
    public void addField(CmsSearchField field) {
        if (field != null && field.getName() != null) {
            this.m_fields.put(field.getName(), field);
        }
    }

    @Override
    public void addUninvertingMappings(Map<String, UninvertingReader.Type> uninvertingMap) {
    }

    @Override
    public int compareTo(I_CmsSearchFieldConfiguration o) {
        return this.m_name.compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().getName().equals(obj.getClass().getName())) {
            return Objects.equals(((CmsSearchFieldConfiguration)obj).getName(), this.getName());
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public CmsSearchField getField(String name) {
        return this.m_fields.get(name);
    }

    public List<String> getFieldNames() {
        return new ArrayList<String>(this.m_fields.keySet());
    }

    @Override
    public List<CmsSearchField> getFields() {
        return new ArrayList<CmsSearchField>(this.m_fields.values());
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public int hashCode() {
        return null == this.m_name ? 0 : this.m_name.hashCode();
    }

    @Override
    public void init() {
    }

    @Override
    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }
}

