/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.galleries.CmsGalleryNameMacroResolver;
import org.opencms.util.CmsMacroResolver;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsMacroResolvingSearchFieldMapping
extends CmsSearchFieldMapping {
    private static final long serialVersionUID = 7690286960084342440L;
    protected static final Log LOG = CmsLog.getLog(CmsMacroResolvingSearchFieldMapping.class);

    @Override
    public String getStringValue(CmsObject cms, CmsResource res, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        String result = super.getStringValue(cms, res, extractionResult, properties, propertiesSearched);
        if (result != null && !result.isEmpty()) {
            try {
                CmsObject cmsClone = OpenCms.initCmsObject(cms);
                if (null != this.m_locale) {
                    cmsClone.getRequestContext().setLocale(this.m_locale);
                }
                CmsFile file = cmsClone.readFile(res);
                CmsXmlContent content = CmsXmlContentFactory.unmarshal(cmsClone, file);
                CmsGalleryNameMacroResolver resolver = new CmsGalleryNameMacroResolver(cms, content, this.m_locale);
                return ((CmsMacroResolver)resolver).resolveMacros(result);
            }
            catch (CmsException e) {
                LOG.error((Object)("Failed to resolve macros in a search field mapping for content " + (res != null ? res.getRootPath() : "null") + ". Returning unresolved value."), (Throwable)e);
            }
        }
        return result;
    }
}

