/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsSearchFieldMappingType;
import org.opencms.search.fields.I_CmsSearchFieldMapping;
import org.opencms.search.galleries.CmsGalleryNameMacroResolver;
import org.opencms.util.CmsMacroResolver;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsMacroSearchFieldMapping
implements I_CmsSearchFieldMapping {
    private static final long serialVersionUID = 1L;
    protected static final Log LOG = CmsLog.getLog(CmsMacroSearchFieldMapping.class);
    private String m_param = null;
    private CmsSearchFieldMappingType m_type;
    private String m_defaultValue = null;
    private Locale m_locale = null;

    public CmsMacroSearchFieldMapping() {
        this.setType(CmsSearchFieldMappingType.DYNAMIC);
    }

    public CmsMacroSearchFieldMapping(CmsSearchFieldMappingType type, String param) {
        this();
        this.setParam(param);
        this.setType(type);
    }

    @Override
    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    @Override
    public String getParam() {
        return this.m_param;
    }

    @Override
    public String getStringValue(CmsObject cms, CmsResource res, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        if (this.m_param != null) {
            try {
                CmsObject cmsClone = OpenCms.initCmsObject(cms);
                if (null != this.m_locale) {
                    cmsClone.getRequestContext().setLocale(this.m_locale);
                }
                CmsFile file = cmsClone.readFile(res);
                CmsXmlContent content = CmsXmlContentFactory.unmarshal(cmsClone, file);
                CmsGalleryNameMacroResolver resolver = new CmsGalleryNameMacroResolver(cms, content, this.m_locale);
                return ((CmsMacroResolver)resolver).resolveMacros(this.m_param);
            }
            catch (CmsException e) {
                LOG.error((Object)"Failed to resolve search field mapping value. Returning null.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public CmsSearchFieldMappingType getType() {
        return this.m_type;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.m_defaultValue = defaultValue;
    }

    @Override
    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    @Override
    public void setParam(String param) {
        this.m_param = param;
    }

    @Override
    public void setType(CmsSearchFieldMappingType type) {
        this.m_type = type;
    }

    @Override
    public void setType(String type) {
        this.m_type = CmsSearchFieldMappingType.valueOf(type);
    }
}

