/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.uninverting.UninvertingReader;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategoryService;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.I_CmsSearchIndex;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.A_CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.I_CmsSearchFieldMapping;
import org.opencms.util.CmsStringUtil;

public class CmsSearchFieldConfiguration
extends A_CmsSearchFieldConfiguration {
    public static final List<String> LAZY_FIELDS = new ArrayList<String>();
    public static final String STR_STANDARD = "standard";
    private static final long serialVersionUID = -7581572963583498549L;
    private transient CmsSearchIndex m_index;

    public static final String getLocaleExtendedName(String lookup, Locale locale) {
        if (locale == null) {
            return lookup;
        }
        return CmsSearchFieldConfiguration.getLocaleExtendedName(lookup, locale.toString());
    }

    public static final String getLocaleExtendedName(String lookup, String locale) {
        StringBuffer result = new StringBuffer(32);
        result.append(lookup);
        result.append('_');
        result.append(locale);
        return result.toString();
    }

    public static String getParentFolderTokens(String rootPath) {
        if (CmsStringUtil.isEmpty(rootPath)) {
            return "/";
        }
        StringBuffer result = new StringBuffer(128);
        String folderName = CmsResource.getFolderPath(rootPath);
        for (int i = 0; i < folderName.length(); ++i) {
            char c = folderName.charAt(i);
            if (c != '/') continue;
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(folderName.substring(0, i + 1));
        }
        return result.toString();
    }

    @Override
    public void addUninvertingMappings(Map<String, UninvertingReader.Type> uninvertingMap) {
        for (String fieldName : this.getFieldNames()) {
            uninvertingMap.put(fieldName, UninvertingReader.Type.SORTED);
        }
    }

    @Override
    public I_CmsSearchDocument createDocument(CmsObject cms, CmsResource resource, I_CmsSearchIndex index, I_CmsExtractionResult extraction) throws CmsException {
        this.m_index = (CmsSearchIndex)index;
        I_CmsSearchDocument document = this.m_index.createEmptyDocument(resource);
        List<CmsProperty> propertiesSearched = cms.readPropertyObjects(resource, true);
        List<CmsProperty> properties = cms.readPropertyObjects(resource, false);
        document = this.appendContentBlob(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendPath(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendType(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendFileSize(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendDates(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendLocales(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendProperties(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendCategories(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendFieldMappings(document, cms, resource, extraction, properties, propertiesSearched);
        document = this.appendAdditionalValuesToDcoument(document, cms, resource, extraction, properties, propertiesSearched);
        return document;
    }

    public I_CmsSearchIndex getIndex() {
        return this.m_index;
    }

    public void setIndex(CmsSearchIndex index) {
        this.m_index = index;
    }

    protected I_CmsSearchDocument appendAdditionalValuesToDcoument(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        return document;
    }

    protected I_CmsSearchDocument appendCategories(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) throws CmsException {
        CmsCategoryService categoryService = CmsCategoryService.getInstance();
        document.addCategoryField(categoryService.readResourceCategories(cms, resource));
        return document;
    }

    protected I_CmsSearchDocument appendContentBlob(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        byte[] data;
        if (extractionResult != null && (data = extractionResult.getBytes()) != null) {
            document.addContentField(data);
        }
        return document;
    }

    protected I_CmsSearchDocument appendDates(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        document.addDateField("created", resource.getDateCreated(), true);
        document.addDateField("lastmodified", resource.getDateLastModified(), true);
        document.addDateField("contentdate", resource.getDateContent(), false);
        return document;
    }

    protected I_CmsSearchDocument appendFieldMapping(I_CmsSearchDocument document, CmsSearchField field, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        StringBuffer text = new StringBuffer();
        for (I_CmsSearchFieldMapping mapping : field.getMappings()) {
            String mapResult = mapping.getStringValue(cms, resource, extractionResult, properties, propertiesSearched);
            if (mapResult == null) continue;
            if (text.length() > 0) {
                text.append('\n');
            }
            text.append(mapResult);
        }
        if (text.length() > 0) {
            document.addSearchField(field, text.toString());
        }
        return document;
    }

    protected I_CmsSearchDocument appendFieldMappings(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        for (CmsSearchField field : this.getFields()) {
            document = this.appendFieldMapping(document, field, cms, resource, extractionResult, properties, propertiesSearched);
        }
        return document;
    }

    protected I_CmsSearchDocument appendFileSize(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        document.addFileSizeField(resource.getLength());
        return document;
    }

    protected I_CmsSearchDocument appendLocales(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        return document;
    }

    protected I_CmsSearchDocument appendPath(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        document.addPathField(resource.getRootPath());
        document.addRootPathField(resource.getRootPath());
        return document;
    }

    protected I_CmsSearchDocument appendProperties(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        return document;
    }

    protected I_CmsSearchDocument appendType(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) throws CmsLoaderException {
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
        String typeName = "VFS";
        if (type != null) {
            typeName = type.getTypeName();
        }
        document.addTypeField(typeName);
        String resName = CmsResource.getName(resource.getRootPath());
        int index = resName.lastIndexOf(46);
        if (index != -1 && resName.length() > index) {
            document.addSuffixField(resName.substring(index + 1));
        }
        return document;
    }

    static {
        LAZY_FIELDS.add("content");
        LAZY_FIELDS.add("contentblob");
    }
}

