/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.jsp.util.CmsObjectFunctionTransformer;
import org.opencms.jsp.util.CmsStringTemplateRenderer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsMacroResolver;
import org.opencms.xml.A_CmsXmlDocument;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsGalleryNameMacroResolver
extends CmsMacroResolver {
    public static final String NO_PREFIX = "no_prefix";
    public static final Pattern NO_PREFIX_PATTERN = Pattern.compile("%\\(no_prefix:(.*?)\\)");
    public static final String PAGE_NAV = "page_nav";
    public static final String PAGE_ROOTPATH = "page_rootpath";
    public static final String PAGE_SITEPATH = "page_sitepath";
    public static final String PAGE_TITLE = "page_title";
    public static final String PREFIX_ISDETAILPAGE = "isDetailPage?";
    public static final String PREFIX_STRINGTEMPLATE = "stringtemplate:";
    public static final String PREFIX_VALUE = "value:";
    private static final Log LOG = CmsLog.getLog(CmsGalleryNameMacroResolver.class);
    private A_CmsXmlDocument m_content;
    private Locale m_contentLocale;
    private final Function<String, String> m_defaultStringTemplateSource = s -> this.m_content.getHandler().getParameter((String)s);
    private Collection<CmsResource> m_pages;
    private Function<String, String> m_stringTemplateSource = this.m_defaultStringTemplateSource;
    private Boolean m_isOnDetailPage;

    public CmsGalleryNameMacroResolver(CmsObject cms, A_CmsXmlDocument content, Locale locale) {
        this.setCmsObject(cms);
        if (null == locale) {
            locale = OpenCms.getLocaleManager().getBestAvailableLocaleForXmlContent(cms, content.getFile(), content);
        }
        CmsMultiMessages message = new CmsMultiMessages(locale);
        message.addMessages(OpenCms.getWorkplaceManager().getMessages(locale));
        message.addMessages(content.getContentDefinition().getContentHandler().getMessages(locale));
        this.setMessages(message);
        this.m_content = content;
        this.m_contentLocale = locale;
    }

    @Override
    public String getMacroValue(String macro) {
        if (macro.startsWith(PREFIX_VALUE)) {
            String path = macro.substring(PREFIX_VALUE.length());
            I_CmsXmlContentValue contentValue = this.m_content.getValue(path, this.m_contentLocale);
            String value = null;
            if (contentValue != null) {
                value = contentValue.getStringValue(this.m_cms);
            }
            if (value == null) {
                value = "";
            }
            return value;
        }
        if (macro.equals(PAGE_TITLE)) {
            return this.getContainerPageProperty("Title");
        }
        if (macro.equals(PAGE_NAV)) {
            return this.getContainerPageProperty("NavText");
        }
        if (macro.equals(PAGE_ROOTPATH)) {
            return this.getContainerPagePath(false);
        }
        if (macro.equals(PAGE_SITEPATH)) {
            return this.getContainerPagePath(true);
        }
        if (macro.startsWith(PREFIX_STRINGTEMPLATE)) {
            return this.resolveStringTemplate(macro.substring(PREFIX_STRINGTEMPLATE.length()));
        }
        if (macro.startsWith(PREFIX_ISDETAILPAGE)) {
            return this.resolveIsDetailPage(macro.substring(PREFIX_ISDETAILPAGE.length()));
        }
        if (macro.startsWith(NO_PREFIX)) {
            return "%(" + macro + ")";
        }
        return super.getMacroValue(macro);
    }

    @Override
    public String resolveMacros(String input) {
        if (input == null) {
            return null;
        }
        String result = super.resolveMacros(input);
        Matcher matcher = NO_PREFIX_PATTERN.matcher(result);
        if (matcher.find()) {
            StringBuffer resultBuffer = new StringBuffer();
            matcher.appendReplacement(resultBuffer, matcher.start() == 0 ? "" : result.substring(matcher.start(1), matcher.end(1)));
            matcher.appendTail(resultBuffer);
            result = resultBuffer.toString();
        }
        return result;
    }

    public void setStringTemplateSource(Function<String, String> stringtemplateSource) {
        if (stringtemplateSource == null) {
            stringtemplateSource = this.m_defaultStringTemplateSource;
        }
        this.m_stringTemplateSource = stringtemplateSource;
    }

    protected String getContainerPagePath(boolean isSitePath) {
        Collection<CmsResource> pages = this.getContainerPages();
        if (pages.isEmpty()) {
            return null;
        }
        HashMap pagePathByLocale = Maps.newHashMap();
        for (CmsResource page : pages) {
            Locale pageLocale = OpenCms.getLocaleManager().getDefaultLocale(this.m_cms, page);
            String pagePathCandidate = page.getRootPath();
            if (isSitePath) {
                pagePathCandidate = OpenCms.getSiteManager().getSiteForRootPath(pagePathCandidate).getSitePath(pagePathCandidate);
            }
            if (pagePathCandidate == null) continue;
            if (pagePathByLocale.get(pageLocale) == null) {
                pagePathByLocale.put(pageLocale, pagePathCandidate);
                continue;
            }
            return "";
        }
        Locale matchingLocale = OpenCms.getLocaleManager().getBestMatchingLocale(this.m_contentLocale, OpenCms.getLocaleManager().getDefaultLocales(), Lists.newArrayList(pagePathByLocale.keySet()));
        String result = (String)pagePathByLocale.get(matchingLocale);
        if (result == null) {
            result = "";
        }
        return result;
    }

    protected String getContainerPageProperty(String propName) {
        Collection<CmsResource> pages = this.getContainerPages();
        if (pages.isEmpty()) {
            return "";
        }
        try {
            HashMap pagePropsByLocale = Maps.newHashMap();
            for (CmsResource page : pages) {
                List<CmsProperty> pagePropertiesList = this.m_cms.readPropertyObjects(page, true);
                Map<String, CmsProperty> pageProperties = CmsProperty.toObjectMap(pagePropertiesList);
                Locale pageLocale = OpenCms.getLocaleManager().getDefaultLocale(this.m_cms, page);
                CmsProperty pagePropCandidate = pageProperties.get(propName);
                if (pagePropCandidate == null) continue;
                if (pagePropsByLocale.get(pageLocale) == null) {
                    pagePropsByLocale.put(pageLocale, pagePropCandidate.getValue());
                    continue;
                }
                return "";
            }
            Locale matchingLocale = OpenCms.getLocaleManager().getBestMatchingLocale(this.m_contentLocale, OpenCms.getLocaleManager().getDefaultLocales(), Lists.newArrayList(pagePropsByLocale.keySet()));
            String result = (String)pagePropsByLocale.get(matchingLocale);
            if (result == null) {
                result = "";
            }
            return result;
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    Collection<CmsResource> getContainerPages() {
        if (null != this.m_pages) {
            return this.m_pages;
        }
        this.m_pages = new HashSet<CmsResource>();
        try {
            List<CmsRelation> relations = this.m_cms.readRelations(CmsRelationFilter.relationsToStructureId(this.m_content.getFile().getStructureId()));
            for (CmsRelation relation : relations) {
                CmsResource source = relation.getSource(this.m_cms, CmsResourceFilter.IGNORE_EXPIRATION);
                if (!CmsResourceTypeXmlContainerPage.isContainerPage(source)) continue;
                this.m_pages.add(source);
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            this.m_pages = Collections.emptySet();
        }
        return this.m_pages;
    }

    private boolean isOnDetailPage() {
        if (this.m_isOnDetailPage != null) {
            return this.m_isOnDetailPage;
        }
        try {
            String uri = this.m_cms.getRequestContext().getUri();
            CmsResource page = this.m_cms.readResource(uri);
            boolean result = OpenCms.getADEManager().isDetailPage(this.m_cms, page);
            this.m_isOnDetailPage = result;
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    private String resolveIsDetailPage(String content) {
        int colonPos = content.indexOf(":");
        if (colonPos != -1) {
            String beforeColon = content.substring(0, colonPos);
            String afterColon = content.substring(colonPos + 1);
            return this.isOnDetailPage() ? beforeColon : afterColon;
        }
        LOG.error((Object)("Invalid body for isDetailPage? macro: " + content));
        return content;
    }

    private String resolveStringTemplate(String stMacro) {
        String template = this.m_stringTemplateSource.apply(stMacro.trim());
        if (template == null) {
            return "";
        }
        CmsJspContentAccessBean jspContentAccess = new CmsJspContentAccessBean(this.m_cms, this.m_contentLocale, this.m_content);
        HashMap params = Maps.newHashMap();
        params.put("fn", CmsCollectionsGenericWrapper.createLazyMap(new CmsObjectFunctionTransformer(this.m_cms)));
        params.put(PAGE_TITLE, new Object(){

            public String toString() {
                return CmsGalleryNameMacroResolver.this.getContainerPageProperty("Title");
            }
        });
        params.put("isDetailPage", this.isOnDetailPage());
        params.put(PAGE_NAV, new Object(){

            public String toString() {
                return CmsGalleryNameMacroResolver.this.getContainerPageProperty("NavText");
            }
        });
        String result = CmsStringTemplateRenderer.renderTemplate(this.m_cms, template, jspContentAccess, (Map<String, Object>)params);
        return result;
    }
}

