/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsGallerySearchResult
implements Comparable<CmsGallerySearchResult>,
Cloneable {
    public static final Log LOG = CmsLog.getLog(CmsGallerySearchResult.class);
    private static String[] m_requiredSolrFields;
    protected List<String> m_containerTypes;
    protected Date m_dateCreated;
    protected Date m_dateExpired;
    protected Date m_dateLastModified;
    protected Date m_dateReleased;
    protected String m_description;
    protected String m_excerpt;
    protected int m_length;
    protected List<String> m_locales;
    protected String m_path;
    protected String m_resourceType;
    protected int m_score;
    protected int m_state;
    protected String m_structureId;
    protected String m_title;
    protected String m_userCreated;
    protected String m_userLastModified;

    public CmsGallerySearchResult(CmsObject cms, CmsResource res, String title) {
        this.m_title = title;
        try {
            Map<String, String> props = CmsProperty.toMap(cms.readPropertyObjects(res, CmsResourceTypeXmlContainerPage.isContainerPage(res)));
            if (this.m_title == null) {
                this.m_title = props.get("Title");
            }
            this.m_description = props.get("Description");
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (this.m_description == null) {
            this.m_description = "";
        }
        if (this.m_title == null) {
            this.m_title = res.getName();
        }
        this.m_dateCreated = new Date(res.getDateCreated());
        this.m_dateExpired = new Date(res.getDateExpired());
        this.m_dateLastModified = new Date(res.getDateLastModified());
        this.m_dateReleased = new Date(res.getDateReleased());
        this.m_length = res.getLength();
        this.m_locales = null;
        this.m_path = res.getRootPath();
        try {
            this.m_resourceType = OpenCms.getResourceManager().getResourceType(res.getTypeId()).getTypeName();
        }
        catch (CmsLoaderException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.m_state = res.getState().getState();
        this.m_structureId = res.getStructureId().toString();
        try {
            this.m_userCreated = cms.readUser(res.getUserCreated()).getFullName();
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            this.m_userLastModified = cms.readUser(res.getUserLastModified()).getFullName();
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public CmsGallerySearchResult(I_CmsSearchDocument doc, CmsObject cms, int score, Locale locale) {
        if (null == doc) {
            throw new IllegalArgumentException();
        }
        if (doc.getType().equals("function_config")) {
            locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        }
        this.m_score = score;
        this.m_path = doc.getFieldValueAsString("path");
        if (null == locale) {
            OpenCms.getLocaleManager();
            locale = CmsLocaleManager.getDefaultLocale();
        }
        String mainTitleField = CmsSearchFieldConfiguration.getLocaleExtendedName("title", locale.toString()) + "_s";
        String localizedTitlePropertyField = CmsSearchFieldConfiguration.getLocaleExtendedName("Title", locale.toString()) + "_dprop_s";
        String titlePropertyField = "Title_dprop_s";
        for (String fieldName : Arrays.asList(mainTitleField, localizedTitlePropertyField, titlePropertyField)) {
            this.m_title = doc.getFieldValueAsString(fieldName);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_title)) continue;
            break;
        }
        String mainDescField = CmsSearchFieldConfiguration.getLocaleExtendedName("description", locale.toString()) + "_s";
        String localizedDescPropertyField = CmsSearchFieldConfiguration.getLocaleExtendedName("Description", locale.toString()) + "_prop_s";
        String descPropertyField = "Description_prop_s";
        for (String fieldName : Arrays.asList(mainDescField, localizedDescPropertyField, descPropertyField)) {
            this.m_description = doc.getFieldValueAsString(fieldName);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_description)) continue;
            break;
        }
        this.m_resourceType = doc.getFieldValueAsString("type");
        this.m_dateCreated = doc.getFieldValueAsDate("created");
        this.m_dateLastModified = doc.getFieldValueAsDate("lastmodified");
        this.m_dateExpired = doc.getFieldValueAsDate("expired");
        this.m_dateReleased = doc.getFieldValueAsDate("released");
        this.m_length = 0;
        String s_length = doc.getFieldValueAsString("size");
        if (null != s_length) {
            try {
                this.m_length = Integer.parseInt(s_length);
            }
            catch (NumberFormatException fieldName) {
                // empty catch block
            }
        }
        this.m_state = 0;
        String s_state = doc.getFieldValueAsString("state");
        if (s_state != null) {
            try {
                this.m_state = Integer.parseInt(s_state);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_userCreated = doc.getFieldValueAsString("userCreated");
        this.m_structureId = doc.getFieldValueAsString("id");
        this.m_userLastModified = doc.getFieldValueAsString("userLastModified");
        String s_locales = doc.getFieldValueAsString("res_locales");
        this.m_locales = null != s_locales ? CmsStringUtil.splitAsList(s_locales, ' ') : new ArrayList<String>(0);
        if (null != cms && null != this.m_structureId) {
            this.initializeMissingFieldsFromVfs(cms, new CmsUUID(this.m_structureId));
        }
    }

    public static final String[] getRequiredSolrFields() {
        if (null == m_requiredSolrFields) {
            List<Locale> locales = OpenCms.getLocaleManager().getAvailableLocales();
            m_requiredSolrFields = new String[14 + locales.size() * 6];
            int count = 0;
            CmsGallerySearchResult.m_requiredSolrFields[count++] = "path";
            CmsGallerySearchResult.m_requiredSolrFields[count++] = "type";
            CmsGallerySearchResult.m_requiredSolrFields[count++] = "created";
            CmsGallerySearchResult.m_requiredSolrFields[count++] = "lastmodified";
            CmsGallerySearchResult.m_requiredSolrFields[count++] = "expired";
            CmsGallerySearchResult.m_requiredSolrFields[count++] = "released";
            CmsGallerySearchResult.m_requiredSolrFields[count++] = "size";
            CmsGallerySearchResult.m_requiredSolrFields[count++] = "state";
            CmsGallerySearchResult.m_requiredSolrFields[count++] = "userCreated";
            CmsGallerySearchResult.m_requiredSolrFields[count++] = "id";
            CmsGallerySearchResult.m_requiredSolrFields[count++] = "userLastModified";
            CmsGallerySearchResult.m_requiredSolrFields[count++] = "res_locales";
            for (Locale locale : locales) {
                CmsGallerySearchResult.m_requiredSolrFields[count++] = CmsSearchFieldConfiguration.getLocaleExtendedName("title", locale.toString()) + "_s";
                CmsGallerySearchResult.m_requiredSolrFields[count++] = CmsSearchFieldConfiguration.getLocaleExtendedName("Title", locale.toString()) + "_dprop_s";
                CmsGallerySearchResult.m_requiredSolrFields[count++] = "Title_dprop_s";
                CmsGallerySearchResult.m_requiredSolrFields[count++] = CmsSearchFieldConfiguration.getLocaleExtendedName("description", locale.toString()) + "_s";
                CmsGallerySearchResult.m_requiredSolrFields[count++] = CmsSearchFieldConfiguration.getLocaleExtendedName("Description", locale.toString()) + "_prop_s";
                CmsGallerySearchResult.m_requiredSolrFields[count++] = "Description_prop_s";
            }
        }
        return m_requiredSolrFields;
    }

    @Override
    public int compareTo(CmsGallerySearchResult other) {
        if (other == this) {
            return 0;
        }
        return other.m_score - this.m_score;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsGallerySearchResult) {
            CmsGallerySearchResult other = (CmsGallerySearchResult)obj;
            return this.m_path.equals(other.m_path);
        }
        return false;
    }

    public List<String> getContainerTypes() {
        return this.m_containerTypes;
    }

    public Date getDateCreated() {
        return this.m_dateCreated;
    }

    public Date getDateExpired() {
        return this.m_dateExpired;
    }

    public Date getDateLastModified() {
        return this.m_dateLastModified;
    }

    public Date getDateReleased() {
        return this.m_dateReleased;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getExcerpt() {
        return this.m_excerpt;
    }

    public int getLength() {
        return this.m_length;
    }

    public List<String> getLocales() {
        return this.m_locales;
    }

    public String getPath() {
        return this.m_path;
    }

    public String getResourceType() {
        return this.m_resourceType;
    }

    public int getScore() {
        return this.m_score;
    }

    public int getState() {
        return this.m_state;
    }

    public String getStructureId() {
        return this.m_structureId;
    }

    public String getTitle() {
        return this.m_title;
    }

    public String getUserCreated() {
        return this.m_userCreated;
    }

    public String getUserLastModified() {
        return this.m_userLastModified;
    }

    public int hashCode() {
        return this.m_path.hashCode();
    }

    public boolean isReleaseAndNotExpired(CmsObject cms) {
        long time = cms.getRequestContext().getRequestTime();
        return time == Long.MIN_VALUE || time > this.m_dateReleased.getTime() && time < this.m_dateExpired.getTime();
    }

    public CmsGallerySearchResult withTitle(String title) {
        try {
            CmsGallerySearchResult res = (CmsGallerySearchResult)this.clone();
            res.m_title = title;
            return res;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    protected void initializeMissingFieldsFromVfs(CmsObject cms, CmsUUID structureId) {
        if (structureId == null) {
            return;
        }
        if (this.m_title != null && this.m_description != null) {
            return;
        }
        try {
            CmsResource res = cms.readResource(structureId, CmsResourceFilter.ALL);
            if (this.m_description == null) {
                CmsProperty descProp = cms.readPropertyObject(res, "Description", CmsResourceTypeXmlContainerPage.isContainerPage(res));
                this.m_description = descProp.getValue();
                if (this.m_description == null) {
                    this.m_description = "";
                }
            }
            if (this.m_title == null) {
                CmsProperty titleProp = cms.readPropertyObject(res, "Title", CmsResourceTypeXmlContainerPage.isContainerPage(res));
                this.m_title = titleProp.getValue();
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_title)) {
                    this.m_title = res.getName();
                }
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return;
        }
    }
}

