/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsFormatterUtils;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsIndexException;
import org.opencms.search.I_CmsSearchIndex;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.solr.CmsSolrDocumentXmlContent;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsSolrDocumentContainerPage
extends CmsSolrDocumentXmlContent {
    private static final Log LOG = CmsLog.getLog(CmsSolrDocumentContainerPage.class);
    public static final String TYPE_CONTAINERPAGE_SOLR = "containerpage-solr";

    public CmsSolrDocumentContainerPage(String name) {
        super(name);
    }

    @Override
    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, I_CmsSearchIndex index) throws CmsException {
        return this.extractContent(cms, resource, index, null);
    }

    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, I_CmsSearchIndex index, Locale forceLocale) throws CmsException {
        this.logContentExtraction(resource, index);
        I_CmsExtractionResult ex = null;
        try {
            CmsFile file = this.readFile(cms, resource);
            CmsXmlContainerPage containerPage = CmsXmlContainerPageFactory.unmarshal(cms, file);
            ArrayList<I_CmsExtractionResult> all = new ArrayList<I_CmsExtractionResult>();
            CmsContainerPageBean containerBean = containerPage.getContainerPage(cms);
            if (containerBean != null) {
                for (Map.Entry<String, CmsContainerBean> entry : containerBean.getContainers().entrySet()) {
                    String containerName = entry.getKey();
                    for (CmsContainerElementBean element : entry.getValue().getElements()) {
                        try {
                            String key;
                            I_CmsFormatterBean formatter;
                            element.initResource(cms);
                            CmsResource elementResource = element.getResource();
                            if (cms.readProject(index.getProject()).isOnlineProject() && elementResource.isExpired(System.currentTimeMillis())) continue;
                            CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfigurationWithCache(cms, file.getRootPath());
                            CmsFormatterConfiguration formatters = adeConfig.getFormatters(cms, element.getResource());
                            boolean shouldExtractElement = false;
                            if (formatters != null && element.getFormatterId() != null && (formatters.isSearchContent(element.getFormatterId()) || adeConfig.isSearchContentFormatter(element.getFormatterId()))) {
                                shouldExtractElement = true;
                            } else if (formatters != null && (formatter = adeConfig.findFormatter(key = CmsFormatterUtils.getFormatterKey(containerName, element))) != null) {
                                shouldExtractElement = formatter.isSearchContent();
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Should extract element " + element.getResource().getRootPath() + ": " + shouldExtractElement));
                            }
                            if (!shouldExtractElement) continue;
                            all.add(CmsSolrDocumentXmlContent.extractXmlContent(cms, elementResource, index, forceLocale));
                        }
                        catch (Exception e) {
                            LOG.debug((Object)Messages.get().getBundle().key("LOG_SKIPPING_CONTAINERPAGE_ELEMENT_WITH_UNREADABLE_RESOURCE_2", file.getRootPath(), element.getId()), (Throwable)e);
                        }
                    }
                }
            }
            HashMap<String, String> fieldMappings = new HashMap<String, String>(1);
            List<Locale> localesAvailable = OpenCms.getLocaleManager().getAvailableLocales(cms, resource);
            HashMap<Locale, LinkedHashMap<String, String>> multilingualValues = new HashMap<Locale, LinkedHashMap<String, String>>(localesAvailable.size());
            for (Locale localeAvailable : localesAvailable) {
                multilingualValues.put(localeAvailable, new LinkedHashMap());
            }
            Locale locale = forceLocale != null ? forceLocale : index.getLocaleForResource(cms, resource, containerPage.getLocales());
            ex = new CmsExtractionResult(locale, multilingualValues, fieldMappings);
            ex = ex.merge(all);
            return ex;
        }
        catch (Exception e) {
            throw new CmsIndexException(Messages.get().container("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
        }
    }

    @Override
    public boolean isLocaleDependend() {
        return true;
    }
}

