/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.util.List;
import java.util.Locale;
import org.opencms.search.fields.CmsLuceneField;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.I_CmsSearchFieldMapping;

public class CmsSolrField
extends CmsSearchField {
    private static final long serialVersionUID = -3920245109164517028L;
    private List<String> m_copyFields;
    private Locale m_locale;
    private String m_targetField;

    public CmsSolrField(CmsLuceneField luceneField) {
        Object name = luceneField.getName();
        if (null != luceneField.getType()) {
            name = (String)name + "_" + luceneField.getType();
        }
        this.setName((String)name);
        this.setDefaultValue(luceneField.getDefaultValue());
        for (I_CmsSearchFieldMapping mapping : luceneField.getMappings()) {
            this.addMapping(mapping);
        }
    }

    public CmsSolrField(String targetField, List<String> copyFields, Locale locale, String defaultValue) {
        super(targetField, defaultValue);
        this.m_targetField = targetField;
        this.m_copyFields = copyFields;
        this.m_locale = locale;
    }

    public List<String> getCopyFields() {
        return this.m_copyFields;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getTargetField() {
        return this.m_targetField;
    }

    public void setCopyFields(List<String> copyFields) {
        this.m_copyFields = copyFields;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public void setTargetField(String targetField) {
        this.m_targetField = targetField;
    }

    @Override
    public String toString() {
        return this.getName() + "[ defaultValue:" + this.getDefaultValue() + " targetField:" + this.getTargetField() + " locale:" + this.getLocale() + " copyFields:" + this.getCopyFields() + " ]";
    }
}

