/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.solrj.SolrQuery;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.search.solr.CmsSolrQueryUtil;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;

public class CmsSolrQuery
extends SolrQuery {
    public static final String ALL_RETURN_FIELDS = "*,score";
    public static final String DEFAULT_FACET_DATE_GAP = "+1DAY";
    public static final String DEFAULT_QUERY = "*:*";
    public static final String DEFAULT_QUERY_TYPE = "edismax";
    public static final Integer DEFAULT_ROWS = 10;
    public static final String MINIMUM_FIELDS = "path,type,solr_id,id";
    public static final String STRUCTURE_FIELDS = "path,type,id,category,contentdate,created,expired,lastmodified,released,suffix,dependencyType,description,Title_prop,res_locales,con_locales,score,parent-folders";
    private static final long serialVersionUID = -2387357736597627703L;
    private String m_facetDateGap = "+1DAY";
    private boolean m_ignoreExpiration;
    private Map<String, String[]> m_queryParameters = new HashMap<String, String[]>();
    private String m_text;
    private List<String> m_textSearchFields = new ArrayList<String>();

    public CmsSolrQuery() {
        this(null, null);
    }

    public CmsSolrQuery(CmsObject cms, Map<String, String[]> queryParams) {
        this.setQuery(DEFAULT_QUERY);
        this.setFields(new String[]{ALL_RETURN_FIELDS});
        this.setRequestHandler(DEFAULT_QUERY_TYPE);
        this.setRows(DEFAULT_ROWS);
        if (cms != null) {
            this.setLocales(Collections.singletonList(cms.getRequestContext().getLocale()));
            this.setSearchRoots(Collections.singletonList(cms.getRequestContext().getSiteRoot() + "/"));
        }
        if (queryParams != null) {
            this.m_queryParameters = queryParams;
        }
        this.ensureParameters();
        this.ensureReturnFields();
        this.ensureExpiration();
    }

    public static String getResourceType(String[] fqs) {
        String ret = null;
        int count = 0;
        if (fqs != null) {
            for (String fq : fqs) {
                if (!fq.startsWith("type:")) continue;
                String val = fq.substring("type:".length());
                val = val.replaceAll("\"", "");
                if (!OpenCms.getResourceManager().hasResourceType(val)) continue;
                ++count;
                ret = val;
            }
        }
        return count == 1 ? ret : null;
    }

    public void addFilterQuery(String fieldName, List<String> vals, boolean all, boolean useQuotes) {
        if (this.getFilterQueries() != null) {
            for (String fq : this.getFilterQueries()) {
                if (!fq.startsWith(fieldName + ":")) continue;
                this.removeFilterQuery(fq);
            }
        }
        this.addFilterQuery(new String[]{this.createFilterQuery(fieldName, vals, all, useQuotes)});
    }

    public void addSortFieldOrders(Map<String, SolrQuery.ORDER> sortFields) {
        if (sortFields != null && !sortFields.isEmpty()) {
            for (Map.Entry<String, SolrQuery.ORDER> entry : sortFields.entrySet()) {
                this.addSort(entry.getKey(), entry.getValue());
            }
        }
    }

    public CmsSolrQuery clone() {
        CmsSolrQuery sq = new CmsSolrQuery(null, CmsRequestUtil.createParameterMap(this.toString(), true, null));
        if (this.m_ignoreExpiration) {
            sq.removeExpiration();
        }
        return sq;
    }

    public void ensureParameters() {
        if (this.m_queryParameters != null && !this.m_queryParameters.isEmpty()) {
            for (Map.Entry<String, String[]> entry : this.m_queryParameters.entrySet()) {
                if (!entry.getKey().equals("fq")) {
                    this.setParam(entry.getKey(), entry.getValue());
                    continue;
                }
                this.replaceFilterQueries(entry.getValue());
            }
        }
    }

    public void removeExpiration() {
        if (this.getFilterQueries() != null) {
            for (String fq : this.getFilterQueries()) {
                if (!fq.startsWith("expired:") && !fq.startsWith("released:")) continue;
                this.removeFilterQuery(fq);
            }
        }
        this.m_ignoreExpiration = true;
    }

    public void setCategories(List<String> categories) {
        if (categories != null && !categories.isEmpty()) {
            this.addFilterQuery("category_exact", categories, true, true);
        }
    }

    public void setCategories(String ... categories) {
        this.setCategories(Arrays.asList(categories));
    }

    public void setDateRanges(Map<String, CmsPair<Date, Date>> dateRanges) {
        if (dateRanges != null && !dateRanges.isEmpty()) {
            for (Map.Entry<String, CmsPair<Date, Date>> entry : dateRanges.entrySet()) {
                this.removeFacetField(entry.getKey());
            }
            for (Map.Entry<String, CmsPair<Date, Date>> entry : dateRanges.entrySet()) {
                this.addDateRangeFacet(entry.getKey(), entry.getValue().getFirst(), entry.getValue().getSecond(), this.m_facetDateGap);
            }
        }
    }

    public void setFacetDateGap(String facetDateGap) {
        this.m_facetDateGap = facetDateGap;
    }

    public void setGeoFilterQuery(String fieldName, String coordinates, String radius, String units) {
        String geoFilterQuery = CmsSolrQueryUtil.composeGeoFilterQuery(fieldName, coordinates, radius, units);
        if (!Arrays.asList(this.getFilterQueries()).contains(geoFilterQuery)) {
            this.addFilterQuery(new String[]{geoFilterQuery});
        }
    }

    public void setHighlightFields(List<String> highlightFields) {
        this.setParam("hl.fl", new String[]{CmsStringUtil.listAsString(highlightFields, ",")});
    }

    public void setHighlightFields(String ... highlightFields) {
        this.setParam("hl.fl", new String[]{CmsStringUtil.arrayAsString(highlightFields, ",")});
    }

    public void setLocales(List<Locale> locales) {
        this.m_textSearchFields = new ArrayList<String>();
        if (locales == null || locales.isEmpty()) {
            this.m_textSearchFields.add("text");
            if (this.getFilterQueries() != null) {
                for (String fq : this.getFilterQueries()) {
                    if (!fq.startsWith("con_locales:")) continue;
                    this.removeFilterQuery(fq);
                }
            }
        } else {
            ArrayList<String> localeStrings = new ArrayList<String>();
            for (Locale locale : locales) {
                localeStrings.add(locale.toString());
                if (!this.m_textSearchFields.contains("text") && !OpenCms.getLocaleManager().getAvailableLocales().contains(locale)) {
                    this.m_textSearchFields.add("text");
                    continue;
                }
                this.m_textSearchFields.add("text_" + locale);
            }
            this.addFilterQuery("con_locales", localeStrings, false, false);
        }
        if (this.m_text != null) {
            this.setText(this.m_text);
        }
    }

    public void setLocales(Locale ... locales) {
        this.setLocales(Arrays.asList(locales));
    }

    public SolrQuery setRequestHandler(String qt) {
        SolrQuery q = super.setRequestHandler(qt);
        if (this.m_text != null) {
            this.setText(this.m_text);
        }
        return q;
    }

    public void setResourceTypes(List<String> resourceTypes) {
        if (resourceTypes != null && !resourceTypes.isEmpty()) {
            this.addFilterQuery("type", resourceTypes, false, false);
        }
    }

    public void setResourceTypes(String ... resourceTypes) {
        this.setResourceTypes(Arrays.asList(resourceTypes));
    }

    public void setReturnFields(String returnFields) {
        this.ensureReturnFields(new String[]{returnFields});
    }

    public void setSearchRoots(List<String> searchRoots) {
        if (searchRoots != null && !searchRoots.isEmpty()) {
            this.addFilterQuery("parent-folders", searchRoots, false, true);
        }
    }

    public void setSearchRoots(String ... searchRoots) {
        this.setSearchRoots(Arrays.asList(searchRoots));
    }

    public void setStructureQuery(boolean structureQuery) {
        if (structureQuery) {
            this.setFields(new String[]{STRUCTURE_FIELDS});
        }
    }

    public void setText(String text) {
        this.m_text = text;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(text)) {
            this.setQuery(this.createTextQuery(text));
        }
    }

    public void setTextSearchFields(List<String> textSearchFields) {
        this.m_textSearchFields = textSearchFields;
        if (this.m_text != null) {
            this.setText(this.m_text);
        }
    }

    public void setTextSearchFields(String ... textSearchFields) {
        this.setTextSearchFields(Arrays.asList(textSearchFields));
    }

    private String createFilterQuery(String fieldName, List<String> vals, boolean all, boolean useQuotes) {
        String filterQuery = null;
        if (vals != null) {
            if (vals.size() == 1) {
                filterQuery = useQuotes ? fieldName + ":\"" + vals.get(0) + "\"" : fieldName + ":" + vals.get(0);
            } else if (vals.size() > 1) {
                filterQuery = fieldName + ":(";
                for (int j = 0; j < vals.size(); ++j) {
                    Object val = useQuotes ? "\"" + vals.get(j) + "\"" : vals.get(j);
                    filterQuery = filterQuery + (String)val;
                    if (vals.size() <= j + 1) continue;
                    filterQuery = all ? filterQuery + " AND " : filterQuery + " OR ";
                }
                filterQuery = filterQuery + ")";
            }
        }
        return filterQuery;
    }

    private String createTextQuery(String text) {
        if (this.m_textSearchFields.isEmpty()) {
            this.m_textSearchFields.add("text");
        }
        String q = "{!q.op=OR type=" + this.getRequestHandler() + " qf=";
        boolean first = true;
        for (String textField : this.m_textSearchFields) {
            if (!first) {
                q = q + " ";
            }
            q = q + textField;
        }
        q = q + "}" + text;
        return q;
    }

    private void ensureExpiration() {
        boolean expirationDateSet = false;
        boolean releaseDateSet = false;
        if (this.getFilterQueries() != null) {
            for (String fq : this.getFilterQueries()) {
                if (fq.startsWith("expired:")) {
                    expirationDateSet = true;
                }
                if (!fq.startsWith("released:")) continue;
                releaseDateSet = true;
            }
        }
        if (!expirationDateSet) {
            this.addFilterQuery(new String[]{"expired:[NOW TO *]"});
        }
        if (!releaseDateSet) {
            this.addFilterQuery(new String[]{"released:[* TO NOW]"});
        }
    }

    private void ensureReturnFields() {
        this.ensureReturnFields(this.getParams("fl"));
    }

    private void ensureReturnFields(String[] requestedReturnFields) {
        if (requestedReturnFields != null && requestedReturnFields.length > 0) {
            ArrayList<String> result = new ArrayList<String>();
            for (String field : requestedReturnFields) {
                List<String> list = CmsStringUtil.splitAsList(field, ',');
                list.forEach(e -> e.trim());
                if (!list.contains("*")) {
                    for (String reqField : CmsStringUtil.splitAsList(MINIMUM_FIELDS, ",")) {
                        if (list.contains(reqField)) continue;
                        list.add(reqField);
                    }
                }
                result.addAll(list);
            }
            this.setParam("fl", new String[]{CmsStringUtil.arrayAsString(result.toArray(new String[0]), ",")});
        }
    }

    private void removeFilterQueries(String[] fqs) {
        for (String fq : fqs) {
            int idx = fq.indexOf(58);
            if (idx == -1) continue;
            String fieldName = fq.substring(0, idx);
            if (this.getFilterQueries() == null) continue;
            for (String sfq : this.getFilterQueries()) {
                if (!sfq.startsWith(fieldName + ":")) continue;
                this.removeFilterQuery(sfq);
            }
        }
    }

    private void replaceFilterQueries(String[] fqs) {
        this.removeFilterQueries(fqs);
        this.addFilterQuery(fqs);
    }
}

