/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsSecurityException;
import org.opencms.security.CmsUserLog;
import org.opencms.security.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsPasswordInfo {
    private final CmsObject m_cms;
    private String m_confirmation;
    private String m_currentPwd;
    private String m_newPwd;
    private final String m_userName;

    public CmsPasswordInfo() {
        this(null);
    }

    public CmsPasswordInfo(CmsObject cms) {
        this.m_cms = cms;
        this.m_userName = this.m_cms != null ? this.m_cms.getRequestContext().getCurrentUser().getName() : null;
    }

    public void applyChanges() throws CmsException {
        if (this.m_userName == null) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_INVALID_USER_CONTEXT_0"));
        }
        this.validate();
        this.m_cms.setPassword(this.m_userName, this.getCurrentPwd(), this.getNewPwd());
        CmsUserLog.logPasswordChange(this.m_cms, this.m_userName);
    }

    public String getConfirmation() {
        return this.m_confirmation;
    }

    public String getCurrentPwd() {
        return this.m_currentPwd;
    }

    public String getNewPwd() {
        return this.m_newPwd;
    }

    public void setConfirmation(String confirmation) {
        if (CmsStringUtil.isEmpty(this.getNewPwd()) && CmsStringUtil.isEmpty(confirmation)) {
            return;
        }
        this.m_confirmation = confirmation;
    }

    public void setCurrentPwd(String currentPwd) {
        if (this.m_userName == null) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_INVALID_USER_CONTEXT_0"));
        }
        try {
            this.m_cms.readUser(this.m_userName, currentPwd);
        }
        catch (CmsException e) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_INVALID_USER_PWD_1", this.m_userName));
        }
        this.m_currentPwd = currentPwd;
    }

    public void setNewPwd(String newPwd) {
        if (CmsStringUtil.isEmpty(newPwd)) {
            return;
        }
        try {
            OpenCms.getPasswordHandler().validatePassword(newPwd);
        }
        catch (CmsSecurityException e) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_INVALID_NEWPWD_0"), (Throwable)e);
        }
        this.m_newPwd = newPwd;
    }

    public void validate() {
        if (CmsStringUtil.isEmpty(this.getNewPwd())) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_INVALID_NEWPWD_0"));
        }
        if (!this.getNewPwd().equals(this.getConfirmation())) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_NEWPWD_MISMATCH_0"));
        }
    }
}

