/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CmsPermissionSet
implements Serializable {
    public static final CmsPermissionSet ACCESS_CONTROL = new CmsPermissionSet(8);
    public static final CmsPermissionSet ACCESS_DIRECT_PUBLISH = new CmsPermissionSet(16);
    public static final CmsPermissionSet ACCESS_READ = new CmsPermissionSet(1);
    public static final CmsPermissionSet ACCESS_VIEW = new CmsPermissionSet(4);
    public static final CmsPermissionSet ACCESS_WRITE = new CmsPermissionSet(2);
    public static final int PERMISSION_CONTROL = 8;
    public static final int PERMISSION_DIRECT_PUBLISH = 16;
    public static final int PERMISSION_EMPTY = 0;
    public static final int PERMISSION_FULL = 31;
    public static final int PERMISSION_READ = 1;
    public static final int PERMISSION_VIEW = 4;
    public static final int PERMISSION_WRITE = 2;
    private static Map<String, Integer> m_permissions;
    private static final long serialVersionUID = -8374511370934922020L;
    protected int m_allowed;
    protected int m_denied;

    public CmsPermissionSet(int allowedPermissions, int deniedPermissions) {
        this.m_allowed = allowedPermissions;
        this.m_denied = deniedPermissions;
    }

    protected CmsPermissionSet() {
    }

    protected CmsPermissionSet(int allowedPermissions) {
        this.m_allowed = allowedPermissions;
        this.m_denied = 0;
    }

    public static Set<String> getPermissionKeys() {
        return CmsPermissionSet.permissions().keySet();
    }

    public static int getPermissionValue(String key) {
        return CmsPermissionSet.permissions().get(key);
    }

    private static Map<String, Integer> permissions() {
        if (m_permissions == null) {
            LinkedHashMap<String, Integer> permissions = new LinkedHashMap<String, Integer>();
            permissions.put("GUI_PERMISSION_TYPE_READ_0", 1);
            permissions.put("GUI_PERMISSION_TYPE_WRITE_0", 2);
            permissions.put("GUI_PERMISSION_TYPE_VIEW_0", 4);
            permissions.put("GUI_PERMISSION_TYPE_CONTROL_0", 8);
            permissions.put("GUI_PERMISSION_TYPE_DIRECT_PUBLISH_0", 16);
            m_permissions = Collections.unmodifiableMap(permissions);
        }
        return m_permissions;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsPermissionSet) {
            CmsPermissionSet other = (CmsPermissionSet)obj;
            return other.m_allowed == this.m_allowed && other.m_denied == this.m_denied;
        }
        return false;
    }

    public int getAllowedPermissions() {
        return this.m_allowed;
    }

    public int getDeniedPermissions() {
        return this.m_denied;
    }

    public int getPermissions() {
        return this.m_allowed & ~this.m_denied;
    }

    public String getPermissionString() {
        StringBuffer p = new StringBuffer("");
        if ((this.m_denied & 1) > 0) {
            p.append("-r");
        } else if (this.requiresReadPermission()) {
            p.append("+r");
        }
        if ((this.m_denied & 2) > 0) {
            p.append("-w");
        } else if (this.requiresWritePermission()) {
            p.append("+w");
        }
        if ((this.m_denied & 4) > 0) {
            p.append("-v");
        } else if (this.requiresViewPermission()) {
            p.append("+v");
        }
        if ((this.m_denied & 8) > 0) {
            p.append("-c");
        } else if (this.requiresControlPermission()) {
            p.append("+c");
        }
        if ((this.m_denied & 0x10) > 0) {
            p.append("-d");
        } else if (this.requiresDirectPublishPermission()) {
            p.append("+d");
        }
        return p.toString();
    }

    public int hashCode() {
        return this.m_allowed * this.m_denied;
    }

    public boolean requiresControlPermission() {
        return 0 < (this.m_allowed & 8);
    }

    public boolean requiresDirectPublishPermission() {
        return 0 < (this.m_allowed & 0x10);
    }

    public boolean requiresReadPermission() {
        return 0 < (this.m_allowed & 1);
    }

    public boolean requiresViewPermission() {
        return 0 < (this.m_allowed & 4);
    }

    public boolean requiresWritePermission() {
        return 0 < (this.m_allowed & 2);
    }

    public String toString() {
        return "[PermissionSet:] " + this.getPermissionString();
    }
}

