/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.synchronize;

import java.io.Serializable;
import org.opencms.util.CmsDateUtil;

public class CmsSynchronizeList
implements Serializable {
    private static final long serialVersionUID = -4460686435282590290L;
    private long m_modifiedFs;
    private long m_modifiedVfs;
    private String m_resName;
    private String m_transResName;

    public CmsSynchronizeList(String resName, String transResName, long modifiedVfs, long modifiedFs) {
        this.m_resName = resName;
        this.m_transResName = transResName;
        this.m_modifiedVfs = modifiedVfs;
        this.m_modifiedFs = modifiedFs;
    }

    public static String getFormatDescription() {
        Object output = "[original filename FS]:[translated filename VFS]";
        output = (String)output + ":[timestamp VFS]:[timestamp  FS]";
        output = (String)output + ":[VFS=readable timestamp VFS]:[FS=readable timestamp FS]";
        return output;
    }

    public long getModifiedFs() {
        return this.m_modifiedFs;
    }

    public long getModifiedVfs() {
        return this.m_modifiedVfs;
    }

    public String getResName() {
        return this.m_resName;
    }

    public String getTransResName() {
        return this.m_transResName;
    }

    public String toString() {
        String output = this.m_resName + ":" + this.m_transResName + ":" + this.m_modifiedVfs + ":" + this.m_modifiedFs;
        output = output + ":VFS=" + CmsDateUtil.getDateTimeShort(this.m_modifiedVfs);
        output = output + ":FS=" + CmsDateUtil.getDateTimeShort(this.m_modifiedFs);
        return output;
    }
}

