/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui;

import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsErrorDialog;
import org.opencms.util.CmsUUID;

public abstract class A_CmsDialogContext
implements I_CmsDialogContext {
    protected Window m_window;
    private String m_appId;
    private I_CmsDialogContext.ContextType m_contextType;
    private List<CmsResource> m_resources;

    protected A_CmsDialogContext(String appId, I_CmsDialogContext.ContextType contextType, List<CmsResource> resources) {
        this.m_appId = appId;
        this.m_resources = resources != null ? resources : Collections.emptyList();
        this.m_contextType = contextType;
    }

    protected void closeWindow() {
        if (this.m_window != null) {
            this.m_window.close();
            this.m_window = null;
        }
    }

    @Override
    public void error(Throwable error) {
        this.closeWindow();
        CmsErrorDialog.showErrorDialog(error, new Runnable(){

            @Override
            public void run() {
                A_CmsDialogContext.this.finish(null);
            }
        });
    }

    @Override
    public void finish(CmsProject project, String siteRoot) {
        if (project != null || siteRoot != null) {
            this.reload();
        } else {
            this.finish(null);
        }
    }

    @Override
    public void finish(Collection<CmsUUID> result) {
        this.closeWindow();
        CmsAppWorkplaceUi.get().enableGlobalShortcuts();
    }

    @Override
    public String getAppId() {
        return this.m_appId;
    }

    @Override
    public CmsObject getCms() {
        return A_CmsUI.getCmsObject();
    }

    @Override
    public I_CmsDialogContext.ContextType getContextType() {
        return this.m_contextType;
    }

    @Override
    public List<CmsResource> getResources() {
        return this.m_resources;
    }

    public Window getWindow() {
        return this.m_window;
    }

    @Override
    public void navigateTo(String appId) {
        this.closeWindow();
        A_CmsUI.get().getNavigator().navigateTo(appId);
    }

    @Override
    public void onViewChange() {
        if (this.m_window != null) {
            this.m_window.center();
        }
    }

    @Override
    public void reload() {
        this.closeWindow();
        CmsAppWorkplaceUi.get().reload();
    }

    @Override
    public void setWindow(Window window) {
        this.m_window = window;
    }

    @Override
    public void start(String title, Component dialog) {
        this.start(title, dialog, CmsBasicDialog.DialogWidth.narrow);
    }

    @Override
    public void start(String title, Component dialog, CmsBasicDialog.DialogWidth style) {
        if (dialog != null) {
            CmsAppWorkplaceUi.get().disableGlobalShortcuts();
            this.m_window = CmsBasicDialog.prepareWindow(style);
            this.m_window.setCaption(title);
            this.m_window.setContent(dialog);
            CmsAppWorkplaceUi.get().addWindow(this.m_window);
            if (dialog instanceof CmsBasicDialog) {
                ((CmsBasicDialog)dialog).initActionHandler(this.m_window);
            }
        }
    }
}

