/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.google.common.collect.Lists;
import com.vaadin.ui.UI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.gwt.shared.CmsCoreData;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.I_CmsDialogContextWithAdeContext;
import org.opencms.ui.I_CmsUpdateListener;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.actions.I_CmsADEAction;
import org.opencms.ui.components.extensions.CmsGwtDialogExtension;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.ui.contextmenu.I_CmsHasMenuItemVisibility;
import org.opencms.util.CmsUUID;

public class CmsDirectPublishDialogAction
extends A_CmsWorkplaceAction
implements I_CmsADEAction {
    public static final String ACTION_ID = "directpublish";
    public static final I_CmsHasMenuItemVisibility VISIBILITY = CmsStandardVisibilityCheck.PUBLISH;

    @Override
    public void executeAction(final I_CmsDialogContext context) {
        if (!this.hasBlockingLocks(context)) {
            CmsGwtDialogExtension extension = new CmsGwtDialogExtension(UI.getCurrent(), new I_CmsUpdateListener<String>(){

                @Override
                public void onUpdate(List<String> updatedItems) {
                    ArrayList updatedIds = Lists.newArrayList();
                    for (String item : updatedItems) {
                        updatedIds.add(new CmsUUID(item));
                    }
                    context.finish(updatedIds);
                }
            });
            extension.openPublishDialog(context.getResources());
        }
    }

    @Override
    public String getCommandClassName() {
        return "org.opencms.gwt.client.ui.contextmenu.CmsEmbeddedAction";
    }

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public String getJspPath() {
        return null;
    }

    @Override
    public Map<String, String> getParams() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("dialogId", CmsDirectPublishDialogAction.class.getName());
        return result;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return VISIBILITY.getVisibility(cms, resources);
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(I_CmsDialogContext context) {
        CmsCoreData.AdeContext adeContext;
        if (context instanceof I_CmsDialogContextWithAdeContext && ((adeContext = ((I_CmsDialogContextWithAdeContext)context).getAdeContext()) == CmsCoreData.AdeContext.publish || adeContext == CmsCoreData.AdeContext.sitemapeditor)) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        return super.getVisibility(context);
    }

    @Override
    public boolean isAdeSupported() {
        return true;
    }

    @Override
    protected String getTitleKey() {
        return "GUI_EXPLORER_CONTEXT_PUBLISH_0";
    }
}

