/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.shared.CmsCoreData;
import org.opencms.main.OpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsEditFileAction;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;

public class CmsEditContentAction
extends A_CmsEditFileAction {
    public static final String ACTION_ID = "ade_editcontent";

    @Override
    public String getId() {
        return ACTION_ID;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(I_CmsDialogContext context) {
        HashSet validContexts = Sets.newHashSet();
        for (CmsCoreData.AdeContext adecontext : Arrays.asList(CmsCoreData.AdeContext.gallery, CmsCoreData.AdeContext.resourceinfo)) {
            validContexts.add(adecontext.name());
        }
        if (!validContexts.contains(context.getAppId())) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        List<CmsResource> resources = context.getResources();
        CmsResource resource = resources.get(0);
        if (OpenCms.getADEManager().isEditorRestricted(context.getCms(), resource)) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resource);
        if (type instanceof CmsResourceTypeXmlContent && !CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
            return CmsStandardVisibilityCheck.DEFAULT.getSingleVisibility(context.getCms(), resource);
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
    }

    @Override
    protected String getFileParam() {
        return "%(file)";
    }

    @Override
    protected String getTitleKey() {
        return "GUI_ACTION_EDIT_CONTENT_0";
    }
}

