/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.gwt.shared.CmsCoreData;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.A_CmsWorkplaceAction;
import org.opencms.ui.actions.I_CmsADEAction;
import org.opencms.ui.actions.prefillpage.CmsStaticPrefillPageHandler;
import org.opencms.ui.actions.prefillpage.I_CmsPrefillPageHandler;
import org.opencms.ui.contextmenu.CmsMenuItemVisibilityMode;
import org.opencms.ui.contextmenu.CmsStandardVisibilityCheck;
import org.opencms.workplace.CmsWorkplaceMessages;

public class CmsPrefillPageAction
extends A_CmsWorkplaceAction
implements I_CmsADEAction {
    private static final Log LOG = CmsLog.getLog(CmsPrefillPageAction.class);
    public static final String GUI_EXPLORER_CONTEXT_PREFILL_PAGE_0 = "GUI_EXPLORER_CONTEXT_PREFILL_PAGE_0";
    private static final String ATTR_PREFILL_HANDLER = "template.prefill.handler";

    @Override
    public void executeAction(I_CmsDialogContext context) {
        CmsObject cms = context.getCms();
        CmsResource resource = context.getResources().get(0);
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, resource.getRootPath());
        String prefillHandler = config.getAttribute(ATTR_PREFILL_HANDLER, null);
        I_CmsPrefillPageHandler handler = null;
        if (null == prefillHandler) {
            handler = new CmsStaticPrefillPageHandler();
        } else {
            try {
                Class<?> handlerClass = Class.forName(prefillHandler);
                if (I_CmsPrefillPageHandler.class.isAssignableFrom(handlerClass)) {
                    handler = (I_CmsPrefillPageHandler)handlerClass.newInstance();
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)e, (Throwable)e);
                }
                LOG.error((Object)e);
            }
        }
        if (handler != null) {
            handler.execute(context);
        } else {
            LOG.error((Object)("Failed to execute prefill action with handler " + prefillHandler + ". The handler could not be initialized."));
        }
    }

    @Override
    public String getCommandClassName() {
        return "org.opencms.gwt.client.ui.contextmenu.CmsEmbeddedAction";
    }

    @Override
    public String getId() {
        return "template_prefill";
    }

    @Override
    public String getJspPath() {
        return null;
    }

    @Override
    public Map<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dialogId", this.getClass().getName());
        params.put("PREFILL_MENU_PLACEHOLDER", "true");
        return params;
    }

    @Override
    public String getTitle(Locale locale) {
        CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(locale);
        String result = messages.key(GUI_EXPLORER_CONTEXT_PREFILL_PAGE_0, true);
        if (result == null) {
            result = messages.key("GUI_EXPLORER_CONTEXT_PREFILL_PAGE_DEFAULT_0");
        }
        return result;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(CmsObject cms, List<CmsResource> resources) {
        return null;
    }

    @Override
    public CmsMenuItemVisibilityMode getVisibility(I_CmsDialogContext context) {
        if (!CmsCoreData.AdeContext.pageeditor.name().equals(context.getAppId())) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        List<CmsResource> resources = context.getResources();
        if (resources.size() != 1) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        CmsObject cms = context.getCms();
        CmsResource resource = resources.get(0);
        if (!CmsStandardVisibilityCheck.DEFAULT.getVisibility(cms, Arrays.asList(resource)).isActive()) {
            return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
        }
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, resource.getRootPath());
        String prefillHandler = config.getAttribute(ATTR_PREFILL_HANDLER, null);
        I_CmsPrefillPageHandler handler = null;
        if (null == prefillHandler) {
            handler = new CmsStaticPrefillPageHandler();
        } else {
            try {
                Class<?> handlerClass = Class.forName(prefillHandler);
                if (I_CmsPrefillPageHandler.class.isAssignableFrom(handlerClass)) {
                    handler = (I_CmsPrefillPageHandler)handlerClass.newInstance();
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)e, (Throwable)e);
                }
                LOG.error((Object)e);
            }
        }
        if (handler != null) {
            if (handler.isExecutable(context)) {
                return CmsMenuItemVisibilityMode.VISIBILITY_ACTIVE;
            }
        } else {
            LOG.error((Object)("Failed to execute prefill action with handler " + prefillHandler + ". The handler could not be initialized."));
        }
        return CmsMenuItemVisibilityMode.VISIBILITY_INVISIBLE;
    }

    @Override
    public boolean isAdeSupported() {
        return true;
    }

    @Override
    protected String getTitleKey() {
        return null;
    }
}

