/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.actions.prefillpage;

import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.actions.prefillpage.I_CmsPrefillPageHandler;
import org.opencms.util.CmsMacroResolver;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.mutable.CmsMutableContainerPage;

public class CmsStaticPrefillPageHandler
implements I_CmsPrefillPageHandler {
    private static final Log LOG = CmsLog.getLog(CmsStaticPrefillPageHandler.class);
    private static final String ATTR_PREFILL_CONTAINER = "template.prefill.container";
    private static final String ATTR_PREFILL_TEMPLATE = "template.prefill.file";

    @Override
    public void execute(I_CmsDialogContext context) {
        CmsObject cms = context.getCms();
        CmsResource resource = context.getResources().get(0);
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, resource.getRootPath());
        try (AutoCloseable c = CmsLockUtil.withLockedResources(cms, resource);){
            CmsFile file = cms.readFile(resource);
            CmsXmlContainerPage pageXml = CmsXmlContainerPageFactory.unmarshal(cms, file);
            CmsContainerPageBean page = pageXml.getContainerPage(cms);
            String containerName = config.getAttribute(ATTR_PREFILL_CONTAINER, null);
            CmsResource prefillTemplate = this.getPrefillTemplate(cms, resource);
            if (prefillTemplate == null) {
                throw new RuntimeException("Prefill template not found in subsitemap " + config.getBasePath());
            }
            CmsContainerBean container = page.getContainers().get(containerName);
            if (container == null) {
                CmsFile templatePageFile = cms.readFile(prefillTemplate);
                CmsXmlContainerPage templatePageXml = CmsXmlContainerPageFactory.unmarshal(cms, templatePageFile);
                CmsContainerPageBean templatePage = templatePageXml.getContainerPage(cms);
                CmsMutableContainerPage pageToRewrite = CmsMutableContainerPage.fromImmutable(page);
                CmsMutableContainerPage templatePageBean = CmsMutableContainerPage.fromImmutable(templatePage);
                pageToRewrite.containers().addAll(templatePageBean.containers());
                pageXml.save(cms, pageToRewrite.toImmutable());
            }
            context.reload();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            context.error(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isExecutable(I_CmsDialogContext context) {
        CmsObject cms = context.getCms();
        CmsResource resource = context.getResources().get(0);
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, resource.getRootPath());
        String containerName = config.getAttribute(ATTR_PREFILL_CONTAINER, null);
        if (containerName == null) {
            return false;
        }
        CmsResource prefillTemplate = this.getPrefillTemplate(cms, resource);
        if (prefillTemplate == null) {
            return false;
        }
        try {
            try {
                CmsFile file = cms.readFile(resource);
                CmsXmlContainerPage pageXml = CmsXmlContainerPageFactory.unmarshal(cms, file);
                CmsContainerPageBean page = pageXml.getContainerPage(cms);
                CmsContainerBean container = page.getContainers().get(containerName);
                return container == null;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        }
        catch (Exception e2) {
            LOG.error((Object)e2.getLocalizedMessage(), (Throwable)e2);
            return false;
        }
    }

    private CmsResource getPrefillTemplate(CmsObject cms, CmsResource resource) {
        try {
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, resource.getRootPath());
            String prefillTemplateStr = config.getAttribute(ATTR_PREFILL_TEMPLATE, null);
            if (prefillTemplateStr == null) {
                return null;
            }
            CmsMacroResolver resolver = new CmsMacroResolver();
            resolver.setCmsObject(cms);
            String subsite = cms.getRequestContext().removeSiteRoot(OpenCms.getADEManager().getSubSiteRoot(cms, resource.getRootPath()));
            if (subsite != null) {
                resolver.addMacro("subsite", subsite);
            }
            prefillTemplateStr = resolver.resolveMacros(prefillTemplateStr).replace("//", "/");
            return cms.readResource(prefillTemplateStr, CmsResourceFilter.IGNORE_EXPIRATION);
        }
        catch (Exception e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }
}

