/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.vaadin.event.Action;
import com.vaadin.event.ShortcutAction;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Page;
import com.vaadin.ui.Component;
import com.vaadin.ui.Dependency;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsAppView;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.I_CmsCachableApp;
import org.opencms.ui.apps.I_CmsHasShortcutActions;
import org.opencms.ui.apps.I_CmsWorkplaceApp;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;
import org.opencms.ui.components.CmsAppViewLayout;
import org.opencms.ui.components.I_CmsWindowCloseListener;

public class CmsAppView
implements ViewChangeListener,
I_CmsWindowCloseListener,
I_CmsAppView,
Action.Handler,
Page.BrowserWindowResizeListener {
    private static final Action ACTION_HISTORY_BACK = new ShortcutAction("Alt+ArrowLeft", 37, new int[]{18});
    private static final Action ACTION_HISTORY_FORWARD = new ShortcutAction("Alt+ArrowRight", 39, new int[]{18});
    private static final long serialVersionUID = -8128528863875050216L;
    private static final Log LOG = CmsLog.getLog(CmsAppView.class);
    private I_CmsWorkplaceApp m_app;
    private Map<Action, Runnable> m_appActions;
    private I_CmsWorkplaceAppConfiguration m_appConfig;
    private CmsAppViewLayout m_appLayout;
    private CacheStatus m_cacheStatus = CacheStatus.noCache;
    private Map<Action, Runnable> m_defaultActions;
    private boolean m_requiresRestore;

    public CmsAppView(I_CmsWorkplaceAppConfiguration appConfig) {
        this.m_appConfig = appConfig;
        this.m_defaultActions = new HashMap<Action, Runnable>();
        this.m_defaultActions.put(ACTION_HISTORY_BACK, new Runnable(){

            @Override
            public void run() {
                ((CmsAppWorkplaceUi)UI.getCurrent()).historyBack();
            }
        });
        this.m_defaultActions.put(ACTION_HISTORY_FORWARD, new Runnable(){

            @Override
            public void run() {
                ((CmsAppWorkplaceUi)UI.getCurrent()).historyForward();
            }
        });
    }

    public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
        if (this.m_app instanceof ViewChangeListener) {
            ((ViewChangeListener)this.m_app).afterViewChange(event);
        }
    }

    public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
        this.disableGlobalShortcuts();
        if (this.m_appLayout != null) {
            this.m_appLayout.closePopupViews();
        }
        if (this.m_app instanceof ViewChangeListener) {
            return ((ViewChangeListener)this.m_app).beforeViewChange(event);
        }
        return true;
    }

    public void browserWindowResized(Page.BrowserWindowResizeEvent event) {
        if (this.m_appLayout != null) {
            this.m_appLayout.browserWindowResized(event);
        }
    }

    @Override
    public void disableGlobalShortcuts() {
        UI.getCurrent().removeActionHandler((Action.Handler)this);
    }

    @Override
    public void enableGlobalShortcuts() {
        UI.getCurrent().removeActionHandler((Action.Handler)this);
        UI.getCurrent().addActionHandler((Action.Handler)this);
    }

    @Override
    public void enter(String newState) {
        this.injectAdditionalStyles();
        if (newState.startsWith("/")) {
            newState = newState.substring(1);
        }
        if (this.m_appLayout != null && this.m_appConfig != null) {
            this.m_appLayout.setAppTitle(this.m_appConfig.getName(UI.getCurrent().getLocale()));
        }
        this.m_app.onStateChange(newState);
        if (this.m_app instanceof I_CmsHasShortcutActions) {
            this.m_appActions = ((I_CmsHasShortcutActions)((Object)this.m_app)).getShortcutActions();
        }
        UI.getCurrent().addActionHandler((Action.Handler)this);
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        String newState = event.getParameters();
        this.enter(newState);
    }

    public Action[] getActions(Object target, Object sender) {
        if (this.m_appActions != null) {
            HashSet<Action> actions = new HashSet<Action>(this.m_defaultActions.keySet());
            actions.addAll(this.m_appActions.keySet());
            return actions.toArray(new Action[actions.size()]);
        }
        return this.m_defaultActions.keySet().toArray(new Action[this.m_defaultActions.size()]);
    }

    public CacheStatus getCacheStatus() {
        return this.m_cacheStatus;
    }

    public CmsAppViewLayout getComponent() {
        if (this.m_app == null) {
            return this.reinitComponent();
        }
        return this.m_appLayout;
    }

    @Override
    public String getName() {
        return this.m_appConfig.getId();
    }

    public void handleAction(Action action, Object sender, Object target) {
        if (this.m_appActions != null && this.m_appActions.containsKey(action)) {
            this.m_appActions.get(action).run();
        } else if (this.m_defaultActions.containsKey(action)) {
            this.m_defaultActions.get(action).run();
        }
    }

    @Override
    public boolean isCachable() {
        return this.m_app instanceof I_CmsCachableApp && ((I_CmsCachableApp)((Object)this.m_app)).isCachable();
    }

    @Override
    public void onWindowClose() {
        if (this.m_app instanceof I_CmsWindowCloseListener) {
            ((I_CmsWindowCloseListener)((Object)this.m_app)).onWindowClose();
        }
        this.disableGlobalShortcuts();
    }

    public CmsAppViewLayout reinitComponent() {
        if (this.m_app != null) {
            this.beforeViewChange(new ViewChangeListener.ViewChangeEvent(CmsAppWorkplaceUi.get().getNavigator(), (View)this, (View)this, this.m_appConfig.getId(), ""));
        }
        this.m_app = !this.m_appConfig.getVisibility(A_CmsUI.getCmsObject()).isActive() ? new NotAvailableApp() : this.m_appConfig.getAppInstance();
        this.m_appLayout = new CmsAppViewLayout(this.m_appConfig.getId());
        this.m_appLayout.setAppTitle(this.m_appConfig.getName(UI.getCurrent().getLocale()));
        this.m_app.initUI(this.m_appLayout);
        return this.m_appLayout;
    }

    @Override
    public boolean requiresRestore() {
        return this.m_requiresRestore;
    }

    @Override
    public void restoreFromCache() {
        ((I_CmsCachableApp)((Object)this.m_app)).onRestoreFromCache();
        this.m_requiresRestore = false;
    }

    public void setCacheStatus(CacheStatus status) {
        this.m_cacheStatus = status;
    }

    @Override
    public void setRequiresRestore(boolean restored) {
        this.m_requiresRestore = restored;
    }

    public String toString() {
        return "appView " + this.getName() + System.identityHashCode(this) + " (" + this.m_app + ")";
    }

    private void injectAdditionalStyles() {
        try {
            Collection<String> stylesheets = OpenCms.getWorkplaceAppManager().getAdditionalStyleSheets();
            for (String stylesheet : stylesheets) {
                A_CmsUI.get().getPage().addDependency(new Dependency(Dependency.Type.STYLESHEET, stylesheet));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static enum CacheStatus {
        cache,
        cacheOnce,
        noCache;

    }

    protected class NotAvailableApp
    implements I_CmsWorkplaceApp {
        protected NotAvailableApp() {
        }

        @Override
        public void initUI(I_CmsAppUIContext context) {
            Label label = new Label(CmsVaadinUtils.getMessageText("GUI_APP_NOT_AVAILABLE_0", new Object[0]));
            label.addStyleName("h2");
            label.addStyleName("o-label-error");
            VerticalLayout content = new VerticalLayout();
            content.setMargin(true);
            content.addComponent((Component)label);
            context.setAppContent((Component)content);
        }

        @Override
        public void onStateChange(String state) {
        }
    }
}

