/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.dnd.DragSourceExtension;
import com.vaadin.ui.dnd.DropTargetExtension;
import com.vaadin.ui.dnd.event.DropEvent;
import com.vaadin.ui.dnd.event.DropListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.apps.CmsAppVisibilityStatus;
import org.opencms.ui.apps.CmsDefaultAppButtonProvider;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;
import org.opencms.ui.components.CmsErrorDialog;

public class CmsQuickLaunchEditor
extends VerticalLayout {
    private static final long serialVersionUID = -6608352673763873030L;
    private CssLayout m_availableApps;
    private Button m_reset;
    private CssLayout m_standardApps;
    private CssLayout m_userApps;

    public CmsQuickLaunchEditor() {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        DropTargetExtension userDrop = new DropTargetExtension((AbstractComponent)this.m_userApps);
        userDrop.addDropListener((DropListener)new LayoutDropListener(this.m_userApps));
        this.m_userApps.addStyleName("wrapping");
        DropTargetExtension availablesDrop = new DropTargetExtension((AbstractComponent)this.m_availableApps);
        availablesDrop.addDropListener((DropListener)new LayoutDropListener(this.m_availableApps));
        this.m_reset.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsQuickLaunchEditor.this.resetAppIcons();
            }
        });
        this.addStyleName("o-quicklaunch-editor");
    }

    protected void resetAppIcons() {
        DragSourceExtension extButton;
        Button button;
        CmsAppVisibilityStatus visibility;
        CmsObject cms = A_CmsUI.getCmsObject();
        Locale locale = UI.getCurrent().getLocale();
        this.m_standardApps.removeAllComponents();
        this.m_userApps.removeAllComponents();
        this.m_availableApps.removeAllComponents();
        Collection<I_CmsWorkplaceAppConfiguration> allApps = OpenCms.getWorkplaceAppManager().getWorkplaceApps();
        List<I_CmsWorkplaceAppConfiguration> standardApps = OpenCms.getWorkplaceAppManager().getDefaultQuickLaunchConfigurations();
        List<I_CmsWorkplaceAppConfiguration> userApps = OpenCms.getWorkplaceAppManager().getUserQuickLauchConfigurations(cms);
        for (I_CmsWorkplaceAppConfiguration config : standardApps) {
            visibility = config.getVisibility(cms);
            if (!visibility.isVisible()) continue;
            button = CmsDefaultAppButtonProvider.createAppIconButton(config, locale);
            this.m_standardApps.addComponent((Component)button);
        }
        for (I_CmsWorkplaceAppConfiguration config : userApps) {
            visibility = config.getVisibility(cms);
            if (!visibility.isVisible() || !visibility.isActive()) continue;
            button = CmsDefaultAppButtonProvider.createAppIconButton(config, locale);
            extButton = new DragSourceExtension((AbstractComponent)button);
            button.setData((Object)config.getId());
            extButton.setDataTransferText(config.getId());
            this.m_userApps.addComponent((Component)button);
        }
        for (I_CmsWorkplaceAppConfiguration config : allApps) {
            visibility = config.getVisibility(cms);
            if (standardApps.contains(config) || userApps.contains(config) || !visibility.isVisible() || !visibility.isActive()) continue;
            button = CmsDefaultAppButtonProvider.createAppIconButton(config, locale);
            extButton = new DragSourceExtension((AbstractComponent)button);
            button.setData((Object)config.getId());
            extButton.setDataTransferText(config.getId());
            this.m_availableApps.addComponent((Component)button);
        }
    }

    void saveToUser() {
        ArrayList<String> apps = new ArrayList<String>();
        int count = this.m_userApps.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Button button = (Button)this.m_userApps.getComponent(i);
            apps.add((String)button.getData());
        }
        try {
            OpenCms.getWorkplaceAppManager().setUserQuickLaunchApps(A_CmsUI.getCmsObject(), apps);
        }
        catch (Exception e) {
            CmsErrorDialog.showErrorDialog("Could not write user Quicklaunch apps", e);
        }
    }

    protected class LayoutDropListener
    implements DropListener<CssLayout> {
        private static final int ITEM_HEIGHT = 88;
        private static final int ITEM_WIDTH = 176;
        private static final int LAYOUT_WIDTH = 1158;
        private static final long serialVersionUID = 8420945711551716630L;
        private CssLayout m_layout;

        protected LayoutDropListener(CssLayout layout) {
            this.m_layout = layout;
        }

        public void drop(DropEvent<CssLayout> event) {
            Component sourceComponent;
            int currentIndex;
            int layoutWidth = 1158;
            int windowWidth = UI.getCurrent().getPage().getBrowserWindowWidth();
            if (windowWidth <= 983) {
                layoutWidth = windowWidth - 22;
            } else if (windowWidth <= 1220) {
                layoutWidth = windowWidth - 62;
            }
            int top = event.getMouseEventDetails().getRelativeY();
            int left = event.getMouseEventDetails().getRelativeX();
            int columnCount = layoutWidth / 176;
            int column = left / 176;
            int row = top / 88;
            int index = row * columnCount + column;
            if (column * 176 + 88 < left) {
                ++index;
            }
            if ((currentIndex = this.m_layout.getComponentIndex(sourceComponent = (Component)event.getDragSourceComponent().get())) != -1 && currentIndex < index) {
                --index;
            }
            if (currentIndex == index) {
                return;
            }
            this.m_layout.removeComponent(sourceComponent);
            if (this.m_layout.getComponentCount() < index) {
                index = this.m_layout.getComponentCount();
            }
            this.m_layout.addComponent(sourceComponent, index);
        }
    }
}

