/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsStringUtil;

public class CmsQuickLaunchLocationCache
implements Serializable {
    private static final Log LOG = CmsLog.getLog(CmsQuickLaunchLocationCache.class);
    private static final long serialVersionUID = -6144984854691623070L;
    private Map<String, PageLocationWithContext> m_pageEditorLocations = new ConcurrentHashMap<String, PageLocationWithContext>();
    private Map<String, String> m_sitemapEditorLocations = new HashMap<String, String>();
    private Map<String, String> m_fileExplorerLocations = new HashMap<String, String>();

    public static CmsQuickLaunchLocationCache getLocationCache(HttpSession session) {
        CmsQuickLaunchLocationCache cache = (CmsQuickLaunchLocationCache)session.getAttribute(CmsQuickLaunchLocationCache.class.getName());
        if (cache == null) {
            cache = new CmsQuickLaunchLocationCache();
            session.setAttribute(CmsQuickLaunchLocationCache.class.getName(), (Object)cache);
        }
        return cache;
    }

    public String getFileExplorerLocation(String siteRoot) {
        return this.m_fileExplorerLocations.get(siteRoot);
    }

    public String getPageEditorLocation(CmsObject cms, String siteRoot) {
        PageLocationWithContext location = this.m_pageEditorLocations.get(siteRoot);
        CmsResource res = null;
        if (location != null) {
            res = location.getNearestPage(cms);
        }
        if (res == null) {
            return null;
        }
        try {
            String sitePath = cms.getSitePath(res);
            cms.readResource(sitePath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            return sitePath;
        }
        catch (CmsVfsResourceNotFoundException e) {
            try {
                CmsResource newRes = cms.readResource(res.getStructureId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(newRes.getRootPath());
                if (site == null) {
                    return null;
                }
                if (this.normalizePath(site.getSiteRoot()).equals(this.normalizePath(siteRoot))) {
                    return cms.getSitePath(newRes);
                }
                return null;
            }
            catch (CmsVfsResourceNotFoundException e2) {
                return null;
            }
            catch (CmsException e2) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e2);
                return null;
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public String getSitemapEditorLocation(String siteRoot) {
        return this.m_sitemapEditorLocations.get(siteRoot);
    }

    public void setFileExplorerLocation(String siteRoot, String location) {
        this.m_fileExplorerLocations.put(siteRoot, location);
    }

    public void setPageEditorResource(CmsObject cms, String siteRoot, CmsResource resource) {
        PageLocationWithContext location = new PageLocationWithContext(cms, resource);
        this.m_pageEditorLocations.put(siteRoot, location);
    }

    public void setSitemapEditorLocation(String siteRoot, String location) {
        this.m_sitemapEditorLocations.put(siteRoot, location);
    }

    private String normalizePath(String path) {
        return CmsStringUtil.joinPaths("/", path, "/");
    }

    static class PageLocationWithContext {
        private CmsResource m_resource;
        private boolean m_isNotPage;
        private float m_navPos;
        private List<CmsResource> m_ancestors = new ArrayList<CmsResource>();
        private CmsResource m_navResource;

        public PageLocationWithContext(CmsObject cms, CmsResource resource) {
            this.m_resource = resource;
            if (!CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
                this.m_isNotPage = true;
            } else {
                try {
                    Map<String, CmsProperty> props = CmsProperty.getPropertyMap(cms.readPropertyObjects(resource, false));
                    if (this.hasNavigationProps(props)) {
                        this.initNavigationData(cms, resource, props);
                    } else {
                        CmsResource parent = cms.readParentFolder(this.m_resource.getStructureId());
                        Map<String, CmsProperty> parentProps = CmsProperty.getPropertyMap(cms.readPropertyObjects(parent, false));
                        if (this.hasNavigationProps(parentProps)) {
                            this.initNavigationData(cms, parent, parentProps);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }

        public CmsResource getNearestPage(CmsObject cms) {
            CmsResource result = this.getNearestPageInternal(cms);
            if (result == null) {
                try {
                    CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, this.m_resource.getRootPath());
                    if (CmsStringUtil.isPrefixPath(cms.getRequestContext().getSiteRoot(), config.getBasePath())) {
                        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType("containerpage");
                        List<CmsResource> resources = cms.readResources(cms.getRequestContext().removeSiteRoot(config.getBasePath()), CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(type), true);
                        for (CmsResource resource : resources) {
                            if (!resource.getRootPath().endsWith("/index.html")) continue;
                            return resource;
                        }
                        Iterator<CmsResource> iterator = resources.iterator();
                        if (iterator.hasNext()) {
                            CmsResource resource;
                            resource = iterator.next();
                            return resource;
                        }
                    }
                }
                catch (Exception e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return result;
        }

        private float getNavPos(Map<String, CmsProperty> props) {
            float result = Float.MAX_VALUE;
            CmsProperty prop = props.get("NavPos");
            if (prop != null) {
                try {
                    result = Float.parseFloat(prop.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }

        private CmsResource getNearestPageInternal(CmsObject cms) {
            if (cms.existsResource(this.m_resource.getStructureId(), CmsResourceFilter.IGNORE_EXPIRATION)) {
                return this.m_resource;
            }
            if (this.m_isNotPage) {
                return null;
            }
            if (this.m_navResource != this.m_resource && this.m_navResource != null && cms.existsResource(this.m_navResource.getStructureId(), CmsResourceFilter.IGNORE_EXPIRATION)) {
                try {
                    CmsResource defaultFile = cms.readDefaultFile(cms.getRequestContext().getSitePath(this.m_navResource), CmsResourceFilter.IGNORE_EXPIRATION);
                    if (defaultFile != null) {
                        return defaultFile;
                    }
                }
                catch (Exception e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            CmsJspNavBuilder builder = new CmsJspNavBuilder();
            builder.init(cms, Locale.ENGLISH);
            for (int ancestorIndex = 0; ancestorIndex < this.m_ancestors.size(); ++ancestorIndex) {
                try {
                    CmsJspNavElement ancestorElem;
                    CmsResource ancestor = cms.readResource(this.m_ancestors.get(ancestorIndex).getStructureId(), CmsResourceFilter.IGNORE_EXPIRATION);
                    if (!CmsStringUtil.isPrefixPath(cms.getRequestContext().getSiteRoot(), ancestor.getRootPath())) {
                        return null;
                    }
                    if (ancestorIndex == 0) {
                        CmsResource candidate;
                        List<CmsJspNavElement> navigation = builder.getNavigationForFolder(cms.getRequestContext().getSitePath(ancestor), CmsJspNavBuilder.Visibility.navigation, CmsResourceFilter.IGNORE_EXPIRATION);
                        ArrayList<CmsJspNavElement> before = new ArrayList<CmsJspNavElement>();
                        ArrayList<CmsJspNavElement> after = new ArrayList<CmsJspNavElement>();
                        for (CmsJspNavElement elem : navigation) {
                            if (elem.getNavPosition() < this.m_navPos) {
                                before.add(elem);
                                continue;
                            }
                            after.add(elem);
                        }
                        for (CmsJspNavElement afterElem : after) {
                            try {
                                candidate = cms.readResource(afterElem.getResourceName(), CmsResourceFilter.IGNORE_EXPIRATION);
                                return candidate;
                            }
                            catch (CmsException e) {
                                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                        Collections.reverse(before);
                        for (CmsJspNavElement beforeElem : before) {
                            try {
                                candidate = cms.readResource(beforeElem.getResourceName(), CmsResourceFilter.IGNORE_EXPIRATION);
                                return candidate;
                            }
                            catch (CmsException e) {
                                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                    }
                    if ((ancestorElem = builder.getNavigationForResource(cms.getRequestContext().getSitePath(ancestor), CmsResourceFilter.IGNORE_EXPIRATION)) == null || !ancestorElem.isInNavigation()) continue;
                    try {
                        CmsResource candidate = cms.readResource(ancestorElem.getResourceName(), CmsResourceFilter.IGNORE_EXPIRATION);
                        return candidate;
                    }
                    catch (CmsException e) {
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                        continue;
                    }
                }
                catch (Exception e) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return null;
        }

        private boolean hasNavigationProps(Map<String, CmsProperty> props) {
            return props.containsKey("NavText") || props.containsKey("NavPos");
        }

        private void initNavigationData(CmsObject cms, CmsResource navResource, Map<String, CmsProperty> props) {
            this.m_navPos = this.getNavPos(props);
            this.m_navResource = navResource;
            CmsResource currentResource = navResource;
            while (!cms.getRequestContext().getSitePath(currentResource).equals("/")) {
                try {
                    currentResource = cms.readParentFolder(currentResource.getStructureId());
                    if (currentResource == null) break;
                    this.m_ancestors.add(currentResource);
                }
                catch (Exception e) {
                    break;
                }
            }
        }
    }
}

