/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.cacheadmin;

import com.alkacon.simapi.Simapi;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.opencms.file.CmsObject;
import org.opencms.loader.CmsImageLoader;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.util.CmsFileUtil;

public class CmsVariationBean {
    private String m_variationPath;
    private CmsObject m_rootCms;

    public CmsVariationBean(String variation) {
        this.m_variationPath = variation;
        try {
            this.m_rootCms = OpenCms.initCmsObject(A_CmsUI.getCmsObject());
            this.m_rootCms.getRequestContext().setSiteRoot("");
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    public String getDimensions() {
        try {
            BufferedImage img = Simapi.read((byte[])IOUtils.toByteArray((InputStream)new FileInputStream(this.m_variationPath)));
            return img.getWidth() + " x " + img.getHeight() + "px";
        }
        catch (IOException e) {
            return "";
        }
    }

    public String getLength() {
        try {
            return CmsFileUtil.formatFilesize(IOUtils.toByteArray((InputStream)new FileInputStream(this.m_variationPath)).length, A_CmsUI.get().getLocale());
        }
        catch (IOException e) {
            return "";
        }
    }

    public String getName() {
        return this.m_variationPath.substring(CmsImageLoader.getImageRepositoryPath().length());
    }
}

