/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.apps.datesearch;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalSplitPanel;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.apps.A_CmsWorkplaceApp;
import org.opencms.ui.apps.I_CmsAppUIContext;
import org.opencms.ui.apps.Messages;
import org.opencms.ui.apps.datesearch.CmsDateSearchComposite;
import org.opencms.ui.components.CmsComponentState;
import org.opencms.util.CmsStringUtil;

public class CmsDateSearchApp
extends A_CmsWorkplaceApp {
    static final Log LOG = CmsLog.getLog(CmsDateSearchApp.class);
    private CmsDateSearchComposite m_dateSearchComposite;

    @Override
    public void initUI(I_CmsAppUIContext context) {
        context.addPublishButton(changed -> {
            if (this.m_dateSearchComposite != null) {
                this.m_dateSearchComposite.search(false, false);
            }
        });
        super.initUI(context);
    }

    @Override
    protected LinkedHashMap<String, String> getBreadCrumbForState(String state) {
        LinkedHashMap<String, String> crumbs = new LinkedHashMap<String, String>();
        crumbs.put("", Messages.get().getBundle(A_CmsUI.get().getLocale()).key("GUI_DATE_SEARCH_TITLE_0"));
        return crumbs;
    }

    @Override
    protected Component getComponentForState(String state) {
        this.m_rootLayout.setMainHeightFull(true);
        HorizontalSplitPanel splitPanel = new HorizontalSplitPanel();
        splitPanel.setSizeFull();
        this.m_dateSearchComposite = new CmsDateSearchComposite();
        splitPanel.setFirstComponent(this.m_dateSearchComposite.getFilterComponent());
        splitPanel.setSecondComponent(this.m_dateSearchComposite.getResultComponent());
        splitPanel.setSplitPosition(399.0f, Sizeable.Unit.PIXELS);
        this.m_infoLayout.addComponents(new Component[]{this.m_dateSearchComposite.getResultFilterComponent()});
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(state)) {
            CmsComponentState componentState = new CmsComponentState(state);
            this.m_dateSearchComposite.setState(componentState);
            this.m_dateSearchComposite.search(false, false);
        }
        return splitPanel;
    }

    @Override
    protected List<A_CmsWorkplaceApp.NavEntry> getSubNavEntries(String state) {
        return null;
    }
}

